/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.NodeManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDiskFailures {
    private static final Logger LOG = LoggerFactory.getLogger(TestDiskFailures.class);
    private static final long DISK_HEALTH_CHECK_INTERVAL = 1000L;
    private static FileContext localFS = null;
    private static final File testDir = new File("target", TestDiskFailures.class.getName()).getAbsoluteFile();
    private static final File localFSDirBase = new File(testDir, TestDiskFailures.class.getName() + "-localDir");
    private static final int numLocalDirs = 4;
    private static final int numLogDirs = 4;
    private static MiniYARNCluster yarnCluster;
    LocalDirsHandlerService dirsHandler;

    @BeforeClass
    public static void setup() throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        localFS = FileContext.getLocalFSFileContext();
        localFS.delete(new Path(localFSDirBase.getAbsolutePath()), true);
        localFSDirBase.mkdirs();
    }

    @AfterClass
    public static void teardown() {
        if (yarnCluster != null) {
            yarnCluster.stop();
            yarnCluster = null;
        }
        FileUtil.fullyDelete((File)localFSDirBase);
    }

    @Test
    public void testLocalDirsFailures() throws IOException {
        this.testDirsFailures(true);
    }

    @Test
    public void testLogDirsFailures() throws IOException {
        this.testDirsFailures(false);
    }

    @Test
    public void testDirFailuresOnStartup() throws IOException {
        YarnConfiguration conf = new YarnConfiguration();
        String localDir1 = new File(testDir, "localDir1").getPath();
        String localDir2 = new File(testDir, "localDir2").getPath();
        String logDir1 = new File(testDir, "logDir1").getPath();
        String logDir2 = new File(testDir, "logDir2").getPath();
        conf.set("yarn.nodemanager.local-dirs", localDir1 + "," + localDir2);
        conf.set("yarn.nodemanager.log-dirs", logDir1 + "," + logDir2);
        this.prepareDirToFail(localDir1);
        this.prepareDirToFail(logDir2);
        LocalDirsHandlerService dirSvc = new LocalDirsHandlerService();
        dirSvc.init((Configuration)conf);
        List localDirs = dirSvc.getLocalDirs();
        Assert.assertEquals((long)1L, (long)localDirs.size());
        Assert.assertEquals((Object)new Path(localDir2).toString(), localDirs.get(0));
        List logDirs = dirSvc.getLogDirs();
        Assert.assertEquals((long)1L, (long)logDirs.size());
        Assert.assertEquals((Object)new Path(logDir1).toString(), logDirs.get(0));
    }

    private void testDirsFailures(boolean localORLogDirs) throws IOException {
        String dirType = localORLogDirs ? "local" : "log";
        String dirsProperty = localORLogDirs ? "yarn.nodemanager.local-dirs" : "yarn.nodemanager.log-dirs";
        Configuration conf = new Configuration();
        conf.setLong("yarn.nodemanager.disk-health-checker.interval-ms", 1000L);
        conf.setFloat("yarn.nodemanager.disk-health-checker.min-healthy-disks", 0.6f);
        if (yarnCluster != null) {
            yarnCluster.stop();
            FileUtil.fullyDelete((File)localFSDirBase);
            localFSDirBase.mkdirs();
        }
        LOG.info("Starting up YARN cluster");
        yarnCluster = new MiniYARNCluster(TestDiskFailures.class.getName(), 1, 4, 4);
        yarnCluster.init(conf);
        yarnCluster.start();
        NodeManager nm = yarnCluster.getNodeManager(0);
        LOG.info("Configured nm-" + dirType + "-dirs=" + nm.getConfig().get(dirsProperty));
        this.dirsHandler = nm.getNodeHealthChecker().getDiskHandler();
        List list = localORLogDirs ? this.dirsHandler.getLocalDirs() : this.dirsHandler.getLogDirs();
        String[] dirs = list.toArray(new String[list.size()]);
        Assert.assertEquals((String)("Number of nm-" + dirType + "-dirs is wrong."), (long)4L, (long)dirs.length);
        String expectedDirs = StringUtils.join((CharSequence)",", (Iterable)list);
        this.verifyDisksHealth(localORLogDirs, expectedDirs, true);
        this.prepareDirToFail(dirs[2]);
        expectedDirs = dirs[0] + "," + dirs[1] + "," + dirs[3];
        this.verifyDisksHealth(localORLogDirs, expectedDirs, true);
        this.prepareDirToFail(dirs[0]);
        expectedDirs = dirs[1] + "," + dirs[3];
        this.verifyDisksHealth(localORLogDirs, expectedDirs, false);
        this.prepareDirToFail(dirs[1]);
        this.prepareDirToFail(dirs[3]);
        expectedDirs = "";
        this.verifyDisksHealth(localORLogDirs, expectedDirs, false);
    }

    private void waitForDiskHealthCheck() {
        long lastDisksCheckTime;
        long time = lastDisksCheckTime = this.dirsHandler.getLastDisksCheckTime();
        for (int i = 0; i < 10 && time <= lastDisksCheckTime; ++i) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOG.error("Interrupted while waiting for NodeManager's disk health check.");
            }
            time = this.dirsHandler.getLastDisksCheckTime();
        }
    }

    private void verifyDisksHealth(boolean localORLogDirs, String expectedDirs, boolean isHealthy) {
        Iterator iter;
        this.waitForDiskHealthCheck();
        List list = localORLogDirs ? this.dirsHandler.getLocalDirs() : this.dirsHandler.getLogDirs();
        String seenDirs = StringUtils.join((CharSequence)",", (Iterable)list);
        LOG.info("ExpectedDirs=" + expectedDirs);
        LOG.info("SeenDirs=" + seenDirs);
        Assert.assertTrue((String)"NodeManager could not identify disk failure.", (boolean)expectedDirs.equals(seenDirs));
        Assert.assertEquals((String)"Node's health in terms of disks is wrong", (Object)isHealthy, (Object)this.dirsHandler.areDisksHealthy());
        for (int i = 0; !(i >= 10 || (iter = yarnCluster.getResourceManager().getRMContext().getRMNodes().values().iterator()).hasNext() && ((RMNode)iter.next()).getState() != NodeState.UNHEALTHY == isHealthy); ++i) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                LOG.error("Interrupted while waiting for NM->RM heartbeat.");
            }
        }
        Iterator iter2 = yarnCluster.getResourceManager().getRMContext().getRMNodes().values().iterator();
        Assert.assertEquals((String)"RM is not updated with the health status of a node", (Object)isHealthy, (Object)(((RMNode)iter2.next()).getState() != NodeState.UNHEALTHY ? 1 : 0));
    }

    private void prepareDirToFail(String dir) throws IOException {
        File file = new File(dir);
        FileUtil.fullyDelete((File)file);
        file.createNewFile();
        LOG.info("Prepared " + dir + " to fail.");
    }
}

