/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceOperations;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomain;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomains;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntityGroupId;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvents;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.timeline.EntityCacheItem;
import org.apache.hadoop.yarn.server.timeline.EntityGroupFSTimelineStore;
import org.apache.hadoop.yarn.server.timeline.EntityGroupFSTimelineStoreMetrics;
import org.apache.hadoop.yarn.server.timeline.LeveldbTimelineStore;
import org.apache.hadoop.yarn.server.timeline.NameValuePair;
import org.apache.hadoop.yarn.server.timeline.TimelineDataManager;
import org.apache.hadoop.yarn.server.timeline.TimelineEntityGroupPlugin;
import org.apache.hadoop.yarn.server.timeline.TimelineReader;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.timeline.security.TimelineACLsManager;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.MappingJsonFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class EntityGroupFSTimelineStore
extends CompositeService
implements TimelineStore {
    static final String DOMAIN_LOG_PREFIX = "domainlog-";
    static final String SUMMARY_LOG_PREFIX = "summarylog-";
    static final String ENTITY_LOG_PREFIX = "entitylog-";
    static final String ATS_V15_SERVER_DFS_CALLER_CTXT = "yarn_ats_server_v1_5";
    private static final Logger LOG = LoggerFactory.getLogger(EntityGroupFSTimelineStore.class);
    private static final FsPermission ACTIVE_DIR_PERMISSION = new FsPermission(1023);
    private static final FsPermission DONE_DIR_PERMISSION = new FsPermission(448);
    private static final EnumSet<YarnApplicationState> APP_FINAL_STATES = EnumSet.of(YarnApplicationState.FAILED, YarnApplicationState.KILLED, YarnApplicationState.FINISHED);
    private static final String APP_DONE_DIR_PREFIX_FORMAT = "%d/%04d/%03d/%s/";
    private static final int CACHE_ITEM_OVERFLOW_FACTOR = 2;
    private YarnClient yarnClient;
    private TimelineStore summaryStore;
    private TimelineACLsManager aclManager;
    private TimelineDataManager summaryTdm;
    private ConcurrentMap<ApplicationId, AppLogs> appIdLogMap = new ConcurrentHashMap();
    private ScheduledThreadPoolExecutor executor;
    private AtomicBoolean stopExecutors = new AtomicBoolean(false);
    private FileSystem fs;
    private ObjectMapper objMapper;
    private JsonFactory jsonFactory;
    private Path activeRootPath;
    private Path doneRootPath;
    private long logRetainMillis;
    private long unknownActiveMillis;
    private int appCacheMaxSize = 0;
    private List<TimelineEntityGroupPlugin> cacheIdPlugins;
    private Map<TimelineEntityGroupId, EntityCacheItem> cachedLogs;
    @InterfaceAudience.Private
    @VisibleForTesting
    EntityGroupFSTimelineStoreMetrics metrics;

    public EntityGroupFSTimelineStore() {
        super(EntityGroupFSTimelineStore.class.getSimpleName());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.metrics = EntityGroupFSTimelineStoreMetrics.create();
        this.summaryStore = this.createSummaryStore();
        this.addService((Service)this.summaryStore);
        long logRetainSecs = conf.getLong("yarn.timeline-service.entity-group-fs-store.retain-seconds", 604800L);
        this.logRetainMillis = logRetainSecs * 1000L;
        LOG.info("Cleaner set to delete logs older than {} seconds", (Object)logRetainSecs);
        long unknownActiveSecs = conf.getLong("yarn.timeline-service.entity-group-fs-store.unknown-active-seconds", 86400L);
        this.unknownActiveMillis = unknownActiveSecs * 1000L;
        LOG.info("Unknown apps will be treated as complete after {} seconds", (Object)unknownActiveSecs);
        this.appCacheMaxSize = conf.getInt("yarn.timeline-service.entity-group-fs-store.app-cache-size", 10);
        LOG.info("Application cache size is {}", (Object)this.appCacheMaxSize);
        this.cachedLogs = Collections.synchronizedMap(new /* Unavailable Anonymous Inner Class!! */);
        this.cacheIdPlugins = this.loadPlugIns(conf);
        this.yarnClient = this.createAndInitYarnClient(conf);
        this.addIfService((Object)this.yarnClient);
        this.activeRootPath = new Path(conf.get("yarn.timeline-service.entity-group-fs-store.active-dir", "/tmp/entity-file-history/active"));
        this.doneRootPath = new Path(conf.get("yarn.timeline-service.entity-group-fs-store.done-dir", "/tmp/entity-file-history/done"));
        this.fs = this.activeRootPath.getFileSystem(conf);
        CallerContext.setCurrent((CallerContext)new CallerContext.Builder("yarn_ats_server_v1_5").build());
        super.serviceInit(conf);
    }

    private List<TimelineEntityGroupPlugin> loadPlugIns(Configuration conf) throws RuntimeException {
        Collection pluginNames = conf.getTrimmedStringCollection("yarn.timeline-service.entity-group-fs-store.group-id-plugin-classes");
        String pluginClasspath = conf.getTrimmed("yarn.timeline-service.entity-group-fs-store.group-id-plugin-classpath");
        String[] systemClasses = conf.getTrimmedStrings("yarn.timeline-service.entity-group-fs-store.group-id-plugin-system-classes");
        LinkedList<TimelineEntityGroupPlugin> pluginList = new LinkedList<TimelineEntityGroupPlugin>();
        ClassLoader customClassLoader = null;
        if (pluginClasspath != null && pluginClasspath.length() > 0) {
            try {
                customClassLoader = EntityGroupFSTimelineStore.createPluginClassLoader((String)pluginClasspath, (String[])systemClasses);
            }
            catch (IOException ioe) {
                LOG.warn("Error loading classloader", (Throwable)ioe);
            }
        }
        for (String name : pluginNames) {
            LOG.debug("Trying to load plugin class {}", (Object)name);
            TimelineEntityGroupPlugin cacheIdPlugin = null;
            try {
                Class<?> clazz;
                if (customClassLoader != null) {
                    LOG.debug("Load plugin {} with classpath: {}", (Object)name, (Object)pluginClasspath);
                    clazz = Class.forName(name, true, customClassLoader);
                    Class<TimelineEntityGroupPlugin> sClass = clazz.asSubclass(TimelineEntityGroupPlugin.class);
                    cacheIdPlugin = (TimelineEntityGroupPlugin)ReflectionUtils.newInstance(sClass, (Configuration)conf);
                } else {
                    LOG.debug("Load plugin class with system classpath");
                    clazz = conf.getClassByName(name);
                    cacheIdPlugin = (TimelineEntityGroupPlugin)ReflectionUtils.newInstance(clazz, (Configuration)conf);
                }
            }
            catch (Exception e) {
                LOG.warn("Error loading plugin " + name, (Throwable)e);
                throw new RuntimeException("No class defined for " + name, e);
            }
            LOG.info("Load plugin class {}", (Object)cacheIdPlugin.getClass().getName());
            pluginList.add(cacheIdPlugin);
        }
        return pluginList;
    }

    private TimelineStore createSummaryStore() {
        return (TimelineStore)ReflectionUtils.newInstance((Class)this.getConfig().getClass("yarn.timeline-service.entity-group-fs-store.summary-store", LeveldbTimelineStore.class, TimelineStore.class), (Configuration)this.getConfig());
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
        LOG.info("Starting {}", (Object)this.getName());
        this.summaryStore.start();
        Configuration conf = this.getConfig();
        this.aclManager = new TimelineACLsManager(conf);
        this.aclManager.setTimelineStore(this.summaryStore);
        this.summaryTdm = new TimelineDataManager(this.summaryStore, this.aclManager);
        this.summaryTdm.init(conf);
        this.addService((Service)this.summaryTdm);
        super.serviceStart();
        if (!this.fs.exists(this.activeRootPath)) {
            this.fs.mkdirs(this.activeRootPath);
            this.fs.setPermission(this.activeRootPath, ACTIVE_DIR_PERMISSION);
        }
        if (!this.fs.exists(this.doneRootPath)) {
            this.fs.mkdirs(this.doneRootPath);
            this.fs.setPermission(this.doneRootPath, DONE_DIR_PERMISSION);
        }
        this.objMapper = new ObjectMapper();
        this.objMapper.setAnnotationIntrospector((AnnotationIntrospector)new JaxbAnnotationIntrospector());
        this.jsonFactory = new MappingJsonFactory(this.objMapper);
        long scanIntervalSecs = conf.getLong("yarn.timeline-service.entity-group-fs-store.scan-interval-seconds", 60L);
        long cleanerIntervalSecs = conf.getLong("yarn.timeline-service.entity-group-fs-store.cleaner-interval-seconds", 3600L);
        int numThreads = conf.getInt("yarn.timeline-service.entity-group-fs-store.threads", 16);
        LOG.info("Scanning active directory {} every {} seconds", (Object)this.activeRootPath, (Object)scanIntervalSecs);
        LOG.info("Cleaning logs every {} seconds", (Object)cleanerIntervalSecs);
        this.executor = new ScheduledThreadPoolExecutor(numThreads, new ThreadFactoryBuilder().setNameFormat("EntityLogPluginWorker #%d").build());
        this.executor.scheduleAtFixedRate((Runnable)new EntityLogScanner(this, null), 0L, scanIntervalSecs, TimeUnit.SECONDS);
        this.executor.scheduleAtFixedRate((Runnable)new EntityLogCleaner(this, null), cleanerIntervalSecs, cleanerIntervalSecs, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceStop() throws Exception {
        LOG.info("Stopping {}", (Object)this.getName());
        this.stopExecutors.set(true);
        if (this.executor != null) {
            this.executor.shutdown();
            if (this.executor.isTerminating()) {
                LOG.info("Waiting for executor to terminate");
                boolean terminated = this.executor.awaitTermination(10L, TimeUnit.SECONDS);
                if (terminated) {
                    LOG.info("Executor terminated");
                } else {
                    LOG.warn("Executor did not terminate");
                    this.executor.shutdownNow();
                }
            }
        }
        Map map = this.cachedLogs;
        synchronized (map) {
            for (EntityCacheItem cacheItem : this.cachedLogs.values()) {
                ServiceOperations.stopQuietly((Service)cacheItem.getStore());
            }
        }
        CallerContext.setCurrent(null);
        super.serviceStop();
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    int scanActiveLogs() throws IOException {
        long startTime = Time.monotonicNow();
        int logsToScanCount = this.scanActiveLogs(this.activeRootPath);
        this.metrics.addActiveLogDirScanTime(Time.monotonicNow() - startTime);
        return logsToScanCount;
    }

    int scanActiveLogs(Path dir) throws IOException {
        RemoteIterator iter = this.list(dir);
        int logsToScanCount = 0;
        while (iter.hasNext()) {
            FileStatus stat = (FileStatus)iter.next();
            String name = stat.getPath().getName();
            ApplicationId appId = EntityGroupFSTimelineStore.parseApplicationId((String)name);
            if (appId != null) {
                LOG.debug("scan logs for {} in {}", (Object)appId, (Object)stat.getPath());
                ++logsToScanCount;
                AppLogs logs = this.getAndSetActiveLog(appId, stat.getPath());
                this.executor.execute((Runnable)new ActiveLogParser(this, logs));
                continue;
            }
            logsToScanCount += this.scanActiveLogs(stat.getPath());
        }
        return logsToScanCount;
    }

    private RemoteIterator<FileStatus> list(Path path) throws IOException {
        return new StoppableRemoteIterator(this, this.fs.listStatusIterator(path));
    }

    private AppLogs createAndPutAppLogsIfAbsent(ApplicationId appId, Path appDirPath, AppState appState) {
        AppLogs appLogs = new AppLogs(this, appId, appDirPath, appState);
        AppLogs oldAppLogs = this.appIdLogMap.putIfAbsent(appId, appLogs);
        if (oldAppLogs != null) {
            appLogs = oldAppLogs;
        }
        return appLogs;
    }

    private AppLogs getAndSetActiveLog(ApplicationId appId, Path appDirPath) {
        AppLogs appLogs = (AppLogs)this.appIdLogMap.get(appId);
        if (appLogs == null) {
            appLogs = this.createAndPutAppLogsIfAbsent(appId, appDirPath, AppState.ACTIVE);
        }
        return appLogs;
    }

    private AppLogs getAndSetAppLogs(ApplicationId applicationId) throws IOException {
        LOG.debug("Looking for app logs mapped for app id {}", (Object)applicationId);
        AppLogs appLogs = (AppLogs)this.appIdLogMap.get(applicationId);
        if (appLogs == null) {
            AppState appState = AppState.UNKNOWN;
            Path appDirPath = this.getDoneAppPath(applicationId);
            if (this.fs.exists(appDirPath)) {
                appState = AppState.COMPLETED;
            } else {
                appDirPath = this.getActiveAppPath(applicationId);
                if (this.fs.exists(appDirPath)) {
                    appState = AppState.ACTIVE;
                } else {
                    RemoteIterator iter = this.list(this.activeRootPath);
                    while (iter.hasNext()) {
                        Path child = new Path(((FileStatus)iter.next()).getPath().getName(), applicationId.toString());
                        appDirPath = new Path(this.activeRootPath, child);
                        if (!this.fs.exists(appDirPath)) continue;
                        appState = AppState.ACTIVE;
                        break;
                    }
                }
            }
            if (appState != AppState.UNKNOWN) {
                LOG.debug("Create and try to add new appLogs to appIdLogMap for {}", (Object)applicationId);
                appLogs = this.createAndPutAppLogsIfAbsent(applicationId, appDirPath, appState);
            }
        }
        return appLogs;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    void cleanLogs(Path dirpath, FileSystem fs, long retainMillis) throws IOException {
        long now = Time.now();
        RemoteIterator iter = this.list(dirpath);
        while (iter.hasNext()) {
            FileStatus stat = (FileStatus)iter.next();
            if (!stat.isDirectory()) continue;
            ApplicationId appId = EntityGroupFSTimelineStore.parseApplicationId((String)dirpath.getName());
            if (appId != null) {
                if (!EntityGroupFSTimelineStore.shouldCleanAppLogDir((Path)dirpath, (long)now, (FileSystem)fs, (long)retainMillis)) continue;
                try {
                    LOG.info("Deleting {}", (Object)dirpath);
                    if (!fs.delete(dirpath, true)) {
                        LOG.error("Unable to remove " + dirpath);
                    }
                    this.metrics.incrLogsDirsCleaned();
                }
                catch (IOException e) {
                    LOG.error("Unable to remove " + dirpath, (Throwable)e);
                }
                continue;
            }
            this.cleanLogs(stat.getPath(), fs, retainMillis);
        }
    }

    private static boolean shouldCleanAppLogDir(Path appLogPath, long now, FileSystem fs, long logRetainMillis) throws IOException {
        RemoteIterator iter = fs.listStatusIterator(appLogPath);
        while (iter.hasNext()) {
            FileStatus stat = (FileStatus)iter.next();
            if (now - stat.getModificationTime() <= logRetainMillis) {
                LOG.debug("{} not being cleaned due to {}", (Object)appLogPath, (Object)stat.getPath());
                return false;
            }
            if (!stat.isDirectory() || EntityGroupFSTimelineStore.shouldCleanAppLogDir((Path)stat.getPath(), (long)now, (FileSystem)fs, (long)logRetainMillis)) continue;
            return false;
        }
        return true;
    }

    private static ApplicationId parseApplicationId(String appIdStr) {
        ApplicationId appId = null;
        if (appIdStr.startsWith("application")) {
            try {
                appId = ApplicationId.fromString((String)appIdStr);
            }
            catch (IllegalArgumentException e) {
                appId = null;
            }
        }
        return appId;
    }

    private static ClassLoader createPluginClassLoader(String appClasspath, String[] systemClasses) throws IOException {
        try {
            return (ClassLoader)AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof MalformedURLException) {
                throw (MalformedURLException)t;
            }
            throw new IOException(e);
        }
    }

    private Path getActiveAppPath(ApplicationId appId) {
        return new Path(this.activeRootPath, appId.toString());
    }

    private Path getDoneAppPath(ApplicationId appId) {
        int appNum = appId.getId();
        int bucket2 = (appNum /= 1000) % 1000;
        int bucket1 = appNum / 1000;
        return new Path(this.doneRootPath, String.format("%d/%04d/%03d/%s/", appId.getClusterTimestamp(), bucket1, bucket2, appId.toString()));
    }

    @VisibleForTesting
    protected YarnClient createAndInitYarnClient(Configuration conf) {
        YarnClient client = YarnClient.createYarnClient();
        client.init(conf);
        return client;
    }

    @VisibleForTesting
    protected AppState getAppState(ApplicationId appId) throws IOException {
        return EntityGroupFSTimelineStore.getAppState((ApplicationId)appId, (YarnClient)this.yarnClient);
    }

    @VisibleForTesting
    List<TimelineEntityGroupPlugin> getPlugins() {
        return this.cacheIdPlugins;
    }

    private static synchronized AppState getAppState(ApplicationId appId, YarnClient yarnClient) throws IOException {
        AppState appState = AppState.ACTIVE;
        try {
            ApplicationReport report = yarnClient.getApplicationReport(appId);
            YarnApplicationState yarnState = report.getYarnApplicationState();
            if (APP_FINAL_STATES.contains(yarnState)) {
                appState = AppState.COMPLETED;
            }
        }
        catch (ApplicationNotFoundException e) {
            appState = AppState.UNKNOWN;
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
        return appState;
    }

    private Throwable extract(Exception e) {
        Throwable t = e;
        if (e instanceof UndeclaredThrowableException && e.getCause() != null) {
            t = e.getCause();
        }
        return t;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    void setFs(FileSystem incomingFs) {
        this.fs = incomingFs;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    void setCachedLogs(TimelineEntityGroupId groupId, EntityCacheItem cacheItem) {
        this.cachedLogs.put(groupId, cacheItem);
    }

    private List<TimelineStore> getTimelineStoresFromCacheIds(Set<TimelineEntityGroupId> groupIds, String entityType, List<EntityCacheItem> cacheItems) throws IOException {
        LinkedList<TimelineStore> stores = new LinkedList<TimelineStore>();
        for (TimelineEntityGroupId groupId : groupIds) {
            TimelineStore storeForId = this.getCachedStore(groupId, cacheItems);
            if (storeForId == null) continue;
            LOG.debug("Adding {} as a store for the query", (Object)storeForId.getName());
            stores.add(storeForId);
            this.metrics.incrGetEntityToDetailOps();
        }
        if (stores.size() == 0) {
            LOG.debug("Using summary store for {}", (Object)entityType);
            stores.add(this.summaryStore);
            this.metrics.incrGetEntityToSummaryOps();
        }
        return stores;
    }

    protected List<TimelineStore> getTimelineStoresForRead(String entityId, String entityType, List<EntityCacheItem> cacheItems) throws IOException {
        HashSet groupIds = new HashSet();
        for (TimelineEntityGroupPlugin cacheIdPlugin : this.cacheIdPlugins) {
            LOG.debug("Trying plugin {} for id {} and type {}", new Object[]{cacheIdPlugin.getClass().getName(), entityId, entityType});
            Set idsFromPlugin = cacheIdPlugin.getTimelineEntityGroupId(entityId, entityType);
            if (idsFromPlugin == null) {
                LOG.debug("Plugin returned null " + cacheIdPlugin.getClass().getName());
            } else {
                LOG.debug("Plugin returned ids: " + idsFromPlugin);
            }
            if (idsFromPlugin == null) continue;
            groupIds.addAll(idsFromPlugin);
            LOG.debug("plugin {} returns a non-null value on query", (Object)cacheIdPlugin.getClass().getName());
        }
        return this.getTimelineStoresFromCacheIds(groupIds, entityType, cacheItems);
    }

    private List<TimelineStore> getTimelineStoresForRead(String entityType, NameValuePair primaryFilter, Collection<NameValuePair> secondaryFilters, List<EntityCacheItem> cacheItems) throws IOException {
        HashSet groupIds = new HashSet();
        for (TimelineEntityGroupPlugin cacheIdPlugin : this.cacheIdPlugins) {
            Set idsFromPlugin = cacheIdPlugin.getTimelineEntityGroupId(entityType, primaryFilter, secondaryFilters);
            if (idsFromPlugin == null) continue;
            LOG.debug("plugin {} returns a non-null value on query {}", (Object)cacheIdPlugin.getClass().getName(), (Object)idsFromPlugin);
            groupIds.addAll(idsFromPlugin);
        }
        return this.getTimelineStoresFromCacheIds(groupIds, entityType, cacheItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimelineStore getCachedStore(TimelineEntityGroupId groupId, List<EntityCacheItem> cacheItems) throws IOException {
        AppLogs appLogs;
        EntityCacheItem cacheItem;
        Map map = this.cachedLogs;
        synchronized (map) {
            cacheItem = (EntityCacheItem)this.cachedLogs.get(groupId);
            if (cacheItem == null) {
                LOG.debug("Set up new cache item for id {}", (Object)groupId);
                cacheItem = new EntityCacheItem(groupId, this.getConfig());
                appLogs = this.getAndSetAppLogs(groupId.getApplicationId());
                if (appLogs != null) {
                    LOG.debug("Set applogs {} for group id {}", (Object)appLogs, (Object)groupId);
                    cacheItem.setAppLogs(appLogs);
                    this.cachedLogs.put(groupId, cacheItem);
                } else {
                    LOG.warn("AppLogs for groupId {} is set to null!", (Object)groupId);
                }
            }
        }
        TimelineStore store = null;
        if (cacheItem.getAppLogs() != null) {
            appLogs = cacheItem.getAppLogs();
            LOG.debug("try refresh cache {} {}", (Object)groupId, (Object)appLogs.getAppId());
            cacheItems.add(cacheItem);
            store = cacheItem.refreshCache(this.aclManager, this.metrics);
        } else {
            LOG.warn("AppLogs for group id {} is null", (Object)groupId);
        }
        return store;
    }

    public TimelineEntities getEntities(String entityType, Long limit, Long windowStart, Long windowEnd, String fromId, Long fromTs, NameValuePair primaryFilter, Collection<NameValuePair> secondaryFilters, EnumSet<TimelineReader.Field> fieldsToRetrieve, TimelineDataManager.CheckAcl checkAcl) throws IOException {
        LOG.debug("getEntities type={} primary={}", (Object)entityType, (Object)primaryFilter);
        ArrayList relatedCacheItems = new ArrayList();
        List stores = this.getTimelineStoresForRead(entityType, primaryFilter, secondaryFilters, relatedCacheItems);
        TimelineEntities returnEntities = new TimelineEntities();
        for (TimelineStore store : stores) {
            LOG.debug("Try timeline store {} for the request", (Object)store.getName());
            TimelineEntities entities = store.getEntities(entityType, limit, windowStart, windowEnd, fromId, fromTs, primaryFilter, secondaryFilters, fieldsToRetrieve, checkAcl);
            if (entities == null) continue;
            returnEntities.addEntities(entities.getEntities());
        }
        return returnEntities;
    }

    public TimelineEntity getEntity(String entityId, String entityType, EnumSet<TimelineReader.Field> fieldsToRetrieve) throws IOException {
        LOG.debug("getEntity type={} id={}", (Object)entityType, (Object)entityId);
        ArrayList relatedCacheItems = new ArrayList();
        List stores = this.getTimelineStoresForRead(entityId, entityType, relatedCacheItems);
        for (TimelineStore store : stores) {
            LOG.debug("Try timeline store {}:{} for the request", (Object)store.getName(), (Object)store.toString());
            TimelineEntity e = store.getEntity(entityId, entityType, fieldsToRetrieve);
            if (e == null) continue;
            return e;
        }
        LOG.debug("getEntity: Found nothing");
        return null;
    }

    public TimelineEvents getEntityTimelines(String entityType, SortedSet<String> entityIds, Long limit, Long windowStart, Long windowEnd, Set<String> eventTypes) throws IOException {
        LOG.debug("getEntityTimelines type={} ids={}", (Object)entityType, entityIds);
        TimelineEvents returnEvents = new TimelineEvents();
        ArrayList relatedCacheItems = new ArrayList();
        for (String entityId : entityIds) {
            LOG.debug("getEntityTimeline type={} id={}", (Object)entityType, (Object)entityId);
            List stores = this.getTimelineStoresForRead(entityId, entityType, relatedCacheItems);
            for (TimelineStore store : stores) {
                LOG.debug("Try timeline store {}:{} for the request", (Object)store.getName(), (Object)store.toString());
                TreeSet<String> entityIdSet = new TreeSet<String>();
                entityIdSet.add(entityId);
                TimelineEvents events = store.getEntityTimelines(entityType, entityIdSet, limit, windowStart, windowEnd, eventTypes);
                if (events == null) continue;
                returnEvents.addEvents(events.getAllEvents());
            }
        }
        return returnEvents;
    }

    public TimelineDomain getDomain(String domainId) throws IOException {
        return this.summaryStore.getDomain(domainId);
    }

    public TimelineDomains getDomains(String owner) throws IOException {
        return this.summaryStore.getDomains(owner);
    }

    public TimelinePutResponse put(TimelineEntities data) throws IOException {
        return this.summaryStore.put(data);
    }

    public void put(TimelineDomain domain) throws IOException {
        this.summaryStore.put(domain);
    }

    static /* synthetic */ int access$000(EntityGroupFSTimelineStore x0) {
        return x0.appCacheMaxSize;
    }

    static /* synthetic */ Logger access$100() {
        return LOG;
    }

    static /* synthetic */ ConcurrentMap access$200(EntityGroupFSTimelineStore x0) {
        return x0.appIdLogMap;
    }

    static /* synthetic */ TimelineDataManager access$500(EntityGroupFSTimelineStore x0) {
        return x0.summaryTdm;
    }

    static /* synthetic */ long access$600(EntityGroupFSTimelineStore x0) {
        return x0.unknownActiveMillis;
    }

    static /* synthetic */ FileSystem access$700(EntityGroupFSTimelineStore x0) {
        return x0.fs;
    }

    static /* synthetic */ JsonFactory access$800(EntityGroupFSTimelineStore x0) {
        return x0.jsonFactory;
    }

    static /* synthetic */ ObjectMapper access$900(EntityGroupFSTimelineStore x0) {
        return x0.objMapper;
    }

    static /* synthetic */ RemoteIterator access$1000(EntityGroupFSTimelineStore x0, Path x1) throws IOException {
        return x0.list(x1);
    }

    static /* synthetic */ Path access$1100(EntityGroupFSTimelineStore x0, ApplicationId x1) {
        return x0.getDoneAppPath(x1);
    }

    static /* synthetic */ Throwable access$1200(EntityGroupFSTimelineStore x0, Exception x1) {
        return x0.extract(x1);
    }

    static /* synthetic */ Path access$1300(EntityGroupFSTimelineStore x0) {
        return x0.doneRootPath;
    }

    static /* synthetic */ long access$1400(EntityGroupFSTimelineStore x0) {
        return x0.logRetainMillis;
    }

    static /* synthetic */ AtomicBoolean access$1500(EntityGroupFSTimelineStore x0) {
        return x0.stopExecutors;
    }
}

