/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.timeline.EntityGroupFSTimelineStore;
import org.apache.hadoop.yarn.server.timeline.LogInfo;
import org.apache.hadoop.yarn.server.timeline.TimelineDataManager;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.MappingIterator;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EntityLogInfo
extends LogInfo {
    private static final Logger LOG = LoggerFactory.getLogger(EntityGroupFSTimelineStore.class);

    public EntityLogInfo(String attemptId, String file, String owner) {
        super(attemptId, file, owner);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected long doParse(TimelineDataManager tdm, JsonParser parser, ObjectMapper objMapper, UserGroupInformation ugi, boolean appCompleted) throws IOException {
        long count = 0L;
        TimelineEntities entities = new TimelineEntities();
        ArrayList<TimelineEntity> entityList = new ArrayList<TimelineEntity>(1);
        long bytesParsedLastBatch = 0L;
        boolean postError = false;
        try {
            MappingIterator iter = objMapper.readValues(parser, TimelineEntity.class);
            while (iter.hasNext()) {
                TimelineEntity entity = (TimelineEntity)iter.next();
                String etype = entity.getEntityType();
                String eid = entity.getEntityId();
                LOG.trace("Read entity {}", (Object)etype);
                ++count;
                long bytesParsed = parser.getCurrentLocation().getCharOffset() + 1L;
                LOG.trace("Parser now at offset {}", (Object)bytesParsed);
                try {
                    LOG.debug("Adding {}({}) to store", (Object)eid, (Object)etype);
                    entityList.add(entity);
                    entities.setEntities(entityList);
                    TimelinePutResponse response = tdm.postEntities(entities, ugi);
                    for (TimelinePutResponse.TimelinePutError e : response.getErrors()) {
                        LOG.warn("Error putting entity: {} ({}): {}", new Object[]{e.getEntityId(), e.getEntityType(), e.getErrorCode()});
                    }
                    this.setOffset(this.getOffset() + bytesParsed - bytesParsedLastBatch);
                    bytesParsedLastBatch = bytesParsed;
                    entityList.clear();
                }
                catch (YarnException e) {
                    postError = true;
                    throw new IOException("Error posting entities", e);
                }
                catch (IOException e) {
                    postError = true;
                    throw new IOException("Error posting entities", e);
                    return count;
                }
            }
        }
        catch (IOException e) {
            if (!appCompleted && !postError) return count;
            throw e;
        }
        catch (RuntimeException e) {
            if (!appCompleted && e.getCause() instanceof JsonParseException) return count;
            throw e;
        }
    }
}

