/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.timeline.EntityGroupFSTimelineStore;
import org.apache.hadoop.yarn.server.timeline.MemoryTimelineStore;
import org.apache.hadoop.yarn.server.timeline.TimelineDataManager;
import org.apache.hadoop.yarn.server.timeline.TimelineReader;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.timeline.security.TimelineACLsManager;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.PrettyPrinter;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.util.MinimalPrettyPrinter;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;
import org.junit.Assert;

/*
 * Exception performing whole class analysis ignored.
 */
public class PluginStoreTestUtils {
    public static FileSystem prepareFileSystemForPluginStore(FileSystem fs) throws IOException {
        Path activeDir = new Path("/tmp/entity-file-history/active");
        Path doneDir = new Path("/tmp/entity-file-history/done");
        fs.mkdirs(activeDir);
        fs.mkdirs(doneDir);
        return fs;
    }

    public static YarnConfiguration prepareConfiguration(YarnConfiguration conf, MiniDFSCluster dfsCluster) {
        conf.set("fs.defaultFS", dfsCluster.getURI().toString());
        conf.setFloat("yarn.timeline-service.version", 1.5f);
        conf.setLong("yarn.timeline-service.entity-group-fs-store.scan-interval-seconds", 1L);
        conf.set("yarn.timeline-service.store-class", EntityGroupFSTimelineStore.class.getName());
        return conf;
    }

    static FSDataOutputStream createLogFile(Path logPath, FileSystem fs) throws IOException {
        FSDataOutputStream stream = fs.create(logPath, true);
        return stream;
    }

    static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new JaxbAnnotationIntrospector());
        mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        mapper.configure(SerializationConfig.Feature.CLOSE_CLOSEABLE, false);
        return mapper;
    }

    static TimelineEntities generateTestEntities() {
        TimelineEntities entities = new TimelineEntities();
        HashMap primaryFilters = new HashMap();
        HashSet<String> l1 = new HashSet<String>();
        l1.add("username");
        HashSet<Integer> l2 = new HashSet<Integer>();
        l2.add(Integer.MAX_VALUE);
        HashSet<String> l3 = new HashSet<String>();
        l3.add("123abc");
        HashSet<Long> l4 = new HashSet<Long>();
        l4.add(0x80000000L);
        primaryFilters.put("user", l1);
        primaryFilters.put("appname", l2);
        primaryFilters.put("other", l3);
        primaryFilters.put("long", l4);
        HashMap<String, Object> secondaryFilters = new HashMap<String, Object>();
        secondaryFilters.put("startTime", 123456);
        secondaryFilters.put("status", "RUNNING");
        HashMap<String, Object> otherInfo1 = new HashMap<String, Object>();
        otherInfo1.put("info1", "val1");
        otherInfo1.putAll(secondaryFilters);
        String entityId1 = "id_1";
        String entityType1 = "type_1";
        String entityId2 = "id_2";
        String entityType2 = "type_2";
        HashMap<String, Set<String>> relatedEntities = new HashMap<String, Set<String>>();
        relatedEntities.put(entityType2, Collections.singleton(entityId2));
        TimelineEvent ev3 = PluginStoreTestUtils.createEvent((long)789L, (String)"launch_event", null);
        TimelineEvent ev4 = PluginStoreTestUtils.createEvent((long)0L, (String)"init_event", null);
        ArrayList<TimelineEvent> events = new ArrayList<TimelineEvent>();
        events.add(ev3);
        events.add(ev4);
        entities.addEntity(PluginStoreTestUtils.createEntity((String)entityId2, (String)entityType2, (Long)456L, events, null, null, null, (String)"domain_id_1"));
        TimelineEvent ev1 = PluginStoreTestUtils.createEvent((long)123L, (String)"start_event", null);
        entities.addEntity(PluginStoreTestUtils.createEntity((String)entityId1, (String)entityType1, (Long)123L, Collections.singletonList(ev1), relatedEntities, primaryFilters, otherInfo1, (String)"domain_id_1"));
        return entities;
    }

    static void verifyTestEntities(TimelineDataManager tdm) throws YarnException, IOException {
        TimelineEntity entity1 = tdm.getEntity("type_1", "id_1", EnumSet.allOf(TimelineReader.Field.class), UserGroupInformation.getLoginUser());
        TimelineEntity entity2 = tdm.getEntity("type_2", "id_2", EnumSet.allOf(TimelineReader.Field.class), UserGroupInformation.getLoginUser());
        Assert.assertNotNull((Object)entity1);
        Assert.assertNotNull((Object)entity2);
        Assert.assertEquals((String)"Failed to read out entity 1", (Object)123L, (Object)entity1.getStartTime());
        Assert.assertEquals((String)"Failed to read out entity 2", (Object)456L, (Object)entity2.getStartTime());
    }

    static TimelineEntity createEntity(String entityId, String entityType, Long startTime, List<TimelineEvent> events, Map<String, Set<String>> relatedEntities, Map<String, Set<Object>> primaryFilters, Map<String, Object> otherInfo, String domainId) {
        TimelineEntity entity = new TimelineEntity();
        entity.setEntityId(entityId);
        entity.setEntityType(entityType);
        entity.setStartTime(startTime);
        entity.setEvents(events);
        if (relatedEntities != null) {
            for (Map.Entry<String, Set<String>> e : relatedEntities.entrySet()) {
                for (String v : e.getValue()) {
                    entity.addRelatedEntity(e.getKey(), v);
                }
            }
        } else {
            entity.setRelatedEntities(null);
        }
        entity.setPrimaryFilters(primaryFilters);
        entity.setOtherInfo(otherInfo);
        entity.setDomainId(domainId);
        return entity;
    }

    static TimelineEvent createEvent(long timestamp, String type, Map<String, Object> info) {
        TimelineEvent event = new TimelineEvent();
        event.setTimestamp(timestamp);
        event.setEventType(type);
        event.setEventInfo(info);
        return event;
    }

    static void writeEntities(TimelineEntities entities, Path logPath, FileSystem fs) throws IOException {
        FSDataOutputStream outStream = PluginStoreTestUtils.createLogFile((Path)logPath, (FileSystem)fs);
        JsonGenerator jsonGenerator = new JsonFactory().createJsonGenerator((OutputStream)outStream);
        jsonGenerator.setPrettyPrinter((PrettyPrinter)new MinimalPrettyPrinter("\n"));
        ObjectMapper objMapper = PluginStoreTestUtils.createObjectMapper();
        for (TimelineEntity entity : entities.getEntities()) {
            objMapper.writeValue(jsonGenerator, (Object)entity);
        }
        outStream.close();
    }

    static TimelineDataManager getTdmWithStore(Configuration config, TimelineStore store) {
        TimelineACLsManager aclManager = new TimelineACLsManager(config);
        TimelineDataManager tdm = new TimelineDataManager(store, aclManager);
        tdm.init(config);
        return tdm;
    }

    static TimelineDataManager getTdmWithMemStore(Configuration config) {
        MemoryTimelineStore store = new MemoryTimelineStore("MemoryStore.test");
        TimelineDataManager tdm = PluginStoreTestUtils.getTdmWithStore((Configuration)config, (TimelineStore)store);
        return tdm;
    }
}

