/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader.filter;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.BinaryPrefixComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.FamilyFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineCompareFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineCompareOp;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineExistsFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilterList;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilterUtils;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineKeyValueFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineKeyValuesFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelinePrefixFilter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Column;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnPrefix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class TimelineFilterUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TimelineFilterUtils.class);

    private TimelineFilterUtils() {
    }

    private static FilterList.Operator getHBaseOperator(TimelineFilterList.Operator op) {
        switch (1.$SwitchMap$org$apache$hadoop$yarn$server$timelineservice$reader$filter$TimelineFilterList$Operator[op.ordinal()]) {
            case 1: {
                return FilterList.Operator.MUST_PASS_ALL;
            }
            case 2: {
                return FilterList.Operator.MUST_PASS_ONE;
            }
        }
        throw new IllegalArgumentException("Invalid operator");
    }

    private static CompareFilter.CompareOp getHBaseCompareOp(TimelineCompareOp op) {
        switch (1.$SwitchMap$org$apache$hadoop$yarn$server$timelineservice$reader$filter$TimelineCompareOp[op.ordinal()]) {
            case 1: {
                return CompareFilter.CompareOp.LESS;
            }
            case 2: {
                return CompareFilter.CompareOp.LESS_OR_EQUAL;
            }
            case 3: {
                return CompareFilter.CompareOp.EQUAL;
            }
            case 4: {
                return CompareFilter.CompareOp.NOT_EQUAL;
            }
            case 5: {
                return CompareFilter.CompareOp.GREATER_OR_EQUAL;
            }
            case 6: {
                return CompareFilter.CompareOp.GREATER;
            }
        }
        throw new IllegalArgumentException("Invalid compare operator");
    }

    private static <T> Filter createHBaseColQualPrefixFilter(ColumnPrefix<T> colPrefix, TimelinePrefixFilter filter) {
        return new QualifierFilter(TimelineFilterUtils.getHBaseCompareOp((TimelineCompareOp)filter.getCompareOp()), (ByteArrayComparable)new BinaryPrefixComparator(colPrefix.getColumnPrefixBytes(filter.getPrefix())));
    }

    public static <T> Filter createHBaseQualifierFilter(CompareFilter.CompareOp compareOp, ColumnPrefix<T> columnPrefix) {
        return new QualifierFilter(compareOp, (ByteArrayComparable)new BinaryPrefixComparator(columnPrefix.getColumnPrefixBytes("")));
    }

    public static <T> Filter createFilterForConfsOrMetricsToRetrieve(TimelineFilterList confsOrMetricToRetrieve, ColumnFamily<T> columnFamily, ColumnPrefix<T> columnPrefix) throws IOException {
        FamilyFilter familyFilter = new FamilyFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(columnFamily.getBytes()));
        if (confsOrMetricToRetrieve != null && !confsOrMetricToRetrieve.getFilterList().isEmpty()) {
            FilterList filter = new FilterList(new Filter[]{familyFilter});
            filter.addFilter((Filter)TimelineFilterUtils.createHBaseFilterList(columnPrefix, (TimelineFilterList)confsOrMetricToRetrieve));
            return filter;
        }
        return familyFilter;
    }

    public static <T> FilterList createSingleColValueFiltersByRange(Column<T> column, Object startValue, Object endValue) throws IOException {
        FilterList list = new FilterList(new Filter[0]);
        SingleColumnValueFilter singleColValFilterStart = TimelineFilterUtils.createHBaseSingleColValueFilter((byte[])column.getColumnFamilyBytes(), (byte[])column.getColumnQualifierBytes(), (byte[])column.getValueConverter().encodeValue(startValue), (CompareFilter.CompareOp)CompareFilter.CompareOp.GREATER_OR_EQUAL, (boolean)true);
        list.addFilter((Filter)singleColValFilterStart);
        SingleColumnValueFilter singleColValFilterEnd = TimelineFilterUtils.createHBaseSingleColValueFilter((byte[])column.getColumnFamilyBytes(), (byte[])column.getColumnQualifierBytes(), (byte[])column.getValueConverter().encodeValue(endValue), (CompareFilter.CompareOp)CompareFilter.CompareOp.LESS_OR_EQUAL, (boolean)true);
        list.addFilter((Filter)singleColValFilterEnd);
        return list;
    }

    public static <T> Filter createHBaseSingleColValueFilter(Column<T> column, Object value, CompareFilter.CompareOp op) throws IOException {
        SingleColumnValueFilter singleColValFilter = TimelineFilterUtils.createHBaseSingleColValueFilter((byte[])column.getColumnFamilyBytes(), (byte[])column.getColumnQualifierBytes(), (byte[])column.getValueConverter().encodeValue(value), (CompareFilter.CompareOp)op, (boolean)true);
        return singleColValFilter;
    }

    private static SingleColumnValueFilter createHBaseSingleColValueFilter(byte[] columnFamily, byte[] columnQualifier, byte[] value, CompareFilter.CompareOp compareOp, boolean filterIfMissing) throws IOException {
        SingleColumnValueFilter singleColValFilter = new SingleColumnValueFilter(columnFamily, columnQualifier, compareOp, (ByteArrayComparable)new BinaryComparator(value));
        singleColValFilter.setLatestVersionOnly(true);
        singleColValFilter.setFilterIfMissing(filterIfMissing);
        return singleColValFilter;
    }

    public static Set<String> fetchColumnsFromFilterList(TimelineFilterList filterList) {
        HashSet<String> strSet = new HashSet<String>();
        block5: for (TimelineFilter filter : filterList.getFilterList()) {
            switch (1.$SwitchMap$org$apache$hadoop$yarn$server$timelineservice$reader$filter$TimelineFilter$TimelineFilterType[filter.getFilterType().ordinal()]) {
                case 1: {
                    strSet.addAll(TimelineFilterUtils.fetchColumnsFromFilterList((TimelineFilterList)((TimelineFilterList)filter)));
                    continue block5;
                }
                case 2: {
                    strSet.add(((TimelineKeyValuesFilter)filter).getKey());
                    continue block5;
                }
                case 3: {
                    strSet.add(((TimelineExistsFilter)filter).getValue());
                    continue block5;
                }
            }
            LOG.info("Unexpected filter type " + filter.getFilterType());
        }
        return strSet;
    }

    public static <T> FilterList createHBaseFilterList(ColumnPrefix<T> colPrefix, TimelineFilterList filterList) throws IOException {
        FilterList list = new FilterList(TimelineFilterUtils.getHBaseOperator((TimelineFilterList.Operator)filterList.getOperator()));
        block6: for (TimelineFilter filter : filterList.getFilterList()) {
            switch (1.$SwitchMap$org$apache$hadoop$yarn$server$timelineservice$reader$filter$TimelineFilter$TimelineFilterType[filter.getFilterType().ordinal()]) {
                case 1: {
                    list.addFilter((Filter)TimelineFilterUtils.createHBaseFilterList(colPrefix, (TimelineFilterList)((TimelineFilterList)filter)));
                    continue block6;
                }
                case 4: {
                    list.addFilter(TimelineFilterUtils.createHBaseColQualPrefixFilter(colPrefix, (TimelinePrefixFilter)((TimelinePrefixFilter)filter)));
                    continue block6;
                }
                case 5: {
                    TimelineCompareFilter compareFilter = (TimelineCompareFilter)filter;
                    list.addFilter((Filter)TimelineFilterUtils.createHBaseSingleColValueFilter((byte[])colPrefix.getColumnFamilyBytes(), (byte[])colPrefix.getColumnPrefixBytes(compareFilter.getKey()), (byte[])colPrefix.getValueConverter().encodeValue(compareFilter.getValue()), (CompareFilter.CompareOp)TimelineFilterUtils.getHBaseCompareOp((TimelineCompareOp)compareFilter.getCompareOp()), (boolean)compareFilter.getKeyMustExist()));
                    continue block6;
                }
                case 6: {
                    TimelineKeyValueFilter kvFilter = (TimelineKeyValueFilter)filter;
                    list.addFilter((Filter)TimelineFilterUtils.createHBaseSingleColValueFilter((byte[])colPrefix.getColumnFamilyBytes(), (byte[])colPrefix.getColumnPrefixBytes(kvFilter.getKey()), (byte[])colPrefix.getValueConverter().encodeValue(kvFilter.getValue()), (CompareFilter.CompareOp)TimelineFilterUtils.getHBaseCompareOp((TimelineCompareOp)kvFilter.getCompareOp()), (boolean)kvFilter.getKeyMustExist()));
                    continue block6;
                }
            }
            LOG.info("Unexpected filter type " + filter.getFilterType());
        }
        return list;
    }
}

