/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.timelineservice.storage.application.ApplicationTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.apptoflow.AppToFlowTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.HBaseTimelineStorageUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowActivityTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.subapplication.SubApplicationTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class TimelineSchemaCreator {
    static final String NAME = TimelineSchemaCreator.class.getSimpleName();
    private static final Logger LOG = LoggerFactory.getLogger(TimelineSchemaCreator.class);
    private static final String SKIP_EXISTING_TABLE_OPTION_SHORT = "s";
    private static final String APP_METRICS_TTL_OPTION_SHORT = "ma";
    private static final String SUB_APP_METRICS_TTL_OPTION_SHORT = "msa";
    private static final String APP_TABLE_NAME_SHORT = "a";
    private static final String SUB_APP_TABLE_NAME_SHORT = "sa";
    private static final String APP_TO_FLOW_TABLE_NAME_SHORT = "a2f";
    private static final String ENTITY_METRICS_TTL_OPTION_SHORT = "me";
    private static final String ENTITY_TABLE_NAME_SHORT = "e";
    private static final String HELP_SHORT = "h";
    private static final String CREATE_TABLES_SHORT = "c";

    private TimelineSchemaCreator() {
    }

    public static void main(String[] args) throws Exception {
        LOG.info("Starting the schema creation");
        Configuration hbaseConf = HBaseTimelineStorageUtils.getTimelineServiceHBaseConf((Configuration)new YarnConfiguration());
        String[] otherArgs = new GenericOptionsParser(hbaseConf, args).getRemainingArgs();
        CommandLine commandLine = TimelineSchemaCreator.parseArgs((String[])otherArgs);
        if (commandLine.hasOption("h")) {
            TimelineSchemaCreator.printUsage();
        } else if (commandLine.hasOption("c")) {
            String subApplicationTableMetricsTTL;
            String subApplicationTableName;
            String applicationTableMetricsTTL;
            String applicationTableName;
            String appToflowTableName;
            String entityTableMetricsTTL;
            String entityTableName = commandLine.getOptionValue("e");
            if (StringUtils.isNotBlank((String)entityTableName)) {
                hbaseConf.set("yarn.timeline-service.entity.table.name", entityTableName);
            }
            if (StringUtils.isNotBlank((String)(entityTableMetricsTTL = commandLine.getOptionValue("me")))) {
                int entityMetricsTTL = Integer.parseInt(entityTableMetricsTTL);
                new EntityTable().setMetricsTTL(entityMetricsTTL, hbaseConf);
            }
            if (StringUtils.isNotBlank((String)(appToflowTableName = commandLine.getOptionValue("a2f")))) {
                hbaseConf.set("yarn.timeline-service.app-flow.table.name", appToflowTableName);
            }
            if (StringUtils.isNotBlank((String)(applicationTableName = commandLine.getOptionValue("a")))) {
                hbaseConf.set("yarn.timeline-service.application.table.name", applicationTableName);
            }
            if (StringUtils.isNotBlank((String)(applicationTableMetricsTTL = commandLine.getOptionValue("ma")))) {
                int appMetricsTTL = Integer.parseInt(applicationTableMetricsTTL);
                new ApplicationTable().setMetricsTTL(appMetricsTTL, hbaseConf);
            }
            if (StringUtils.isNotBlank((String)(subApplicationTableName = commandLine.getOptionValue("sa")))) {
                hbaseConf.set("yarn.timeline-service.subapplication.table.name", subApplicationTableName);
            }
            if (StringUtils.isNotBlank((String)(subApplicationTableMetricsTTL = commandLine.getOptionValue("msa")))) {
                int subAppMetricsTTL = Integer.parseInt(subApplicationTableMetricsTTL);
                new SubApplicationTable().setMetricsTTL(subAppMetricsTTL, hbaseConf);
            }
            boolean skipExisting = commandLine.hasOption("s");
            TimelineSchemaCreator.createAllSchemas((Configuration)hbaseConf, (boolean)skipExisting);
        } else {
            TimelineSchemaCreator.printUsage();
        }
    }

    private static CommandLine parseArgs(String[] args) throws ParseException {
        Options options = new Options();
        Option o = new Option("h", "help", false, "print help information");
        o.setRequired(false);
        options.addOption(o);
        o = new Option("c", "create", false, "a mandatory option to create hbase tables");
        o.setRequired(false);
        options.addOption(o);
        o = new Option("e", "entityTableName", true, "entity table name");
        o.setArgName("entityTableName");
        o.setRequired(false);
        options.addOption(o);
        o = new Option("me", "entityMetricsTTL", true, "TTL for metrics column family");
        o.setArgName("entityMetricsTTL");
        o.setRequired(false);
        options.addOption(o);
        o = new Option("a2f", "appToflowTableName", true, "app to flow table name");
        o.setArgName("appToflowTableName");
        o.setRequired(false);
        options.addOption(o);
        o = new Option("a", "applicationTableName", true, "application table name");
        o.setArgName("applicationTableName");
        o.setRequired(false);
        options.addOption(o);
        o = new Option("ma", "applicationMetricsTTL", true, "TTL for metrics column family");
        o.setArgName("applicationMetricsTTL");
        o.setRequired(false);
        options.addOption(o);
        o = new Option("sa", "subApplicationTableName", true, "subApplication table name");
        o.setArgName("subApplicationTableName");
        o.setRequired(false);
        options.addOption(o);
        o = new Option("msa", "subApplicationMetricsTTL", true, "TTL for metrics column family");
        o.setArgName("subApplicationMetricsTTL");
        o.setRequired(false);
        options.addOption(o);
        o = new Option("s", "skipExistingTable", false, "skip existing Hbase tables and continue to create new tables");
        o.setRequired(false);
        options.addOption(o);
        PosixParser parser = new PosixParser();
        CommandLine commandLine = null;
        try {
            commandLine = parser.parse(options, args);
        }
        catch (Exception e) {
            LOG.error("ERROR: " + e.getMessage() + "\n");
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(NAME + " ", options, true);
            System.exit(-1);
        }
        return commandLine;
    }

    private static void printUsage() {
        StringBuilder usage = new StringBuilder("Command Usage: \n");
        usage.append("TimelineSchemaCreator [-help] Display help info for all commands. Or\n");
        usage.append("TimelineSchemaCreator -create [OPTIONAL_OPTIONS] Create hbase tables.\n\n");
        usage.append("The Optional options for creating tables include: \n");
        usage.append("[-entityTableName <Entity Table Name>] The name of the Entity table\n");
        usage.append("[-entityMetricsTTL <Entity Table Metrics TTL>] TTL for metrics in the Entity table\n");
        usage.append("[-appToflowTableName <AppToflow Table Name>] The name of the AppToFlow table\n");
        usage.append("[-applicationTableName <Application Table Name>] The name of the Application table\n");
        usage.append("[-applicationMetricsTTL <Application Table Metrics TTL>] TTL for metrics in the Application table\n");
        usage.append("[-subApplicationTableName <SubApplication Table Name>] The name of the SubApplication table\n");
        usage.append("[-subApplicationMetricsTTL  <SubApplication Table Metrics TTL>] TTL for metrics in the SubApplication table\n");
        usage.append("[-skipExistingTable] Whether to skip existing hbase tables\n");
        System.out.println(usage.toString());
    }

    private static void createAllSchemas(Configuration hbaseConf, boolean skipExisting) {
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        try {
            if (skipExisting) {
                LOG.info("Will skip existing tables and continue on htable creation exceptions!");
            }
            TimelineSchemaCreator.createAllTables((Configuration)hbaseConf, (boolean)skipExisting);
            LOG.info("Successfully created HBase schema. ");
        }
        catch (IOException e) {
            LOG.error("Error in creating hbase tables: ", (Throwable)e);
            exceptions.add(e);
        }
        if (exceptions.size() > 0) {
            LOG.warn("Schema creation finished with the following exceptions");
            for (Exception exception : exceptions) {
                LOG.warn(exception.getMessage());
            }
            System.exit(-1);
        } else {
            LOG.info("Schema creation finished successfully");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void createAllTables(Configuration hbaseConf, boolean skipExisting) throws IOException {
        block23: {
            try (Connection conn = null;){
                conn = ConnectionFactory.createConnection((Configuration)hbaseConf);
                Admin admin = conn.getAdmin();
                if (admin == null) {
                    throw new IOException("Cannot create table since admin is null");
                }
                try {
                    new EntityTable().createTable(admin, hbaseConf);
                }
                catch (IOException e) {
                    if (skipExisting) {
                        LOG.warn("Skip and continue on: " + e.getMessage());
                    }
                    throw e;
                }
                try {
                    new AppToFlowTable().createTable(admin, hbaseConf);
                }
                catch (IOException e) {
                    if (skipExisting) {
                        LOG.warn("Skip and continue on: " + e.getMessage());
                    }
                    throw e;
                }
                try {
                    new ApplicationTable().createTable(admin, hbaseConf);
                }
                catch (IOException e) {
                    if (skipExisting) {
                        LOG.warn("Skip and continue on: " + e.getMessage());
                    }
                    throw e;
                }
                try {
                    new FlowRunTable().createTable(admin, hbaseConf);
                }
                catch (IOException e) {
                    if (skipExisting) {
                        LOG.warn("Skip and continue on: " + e.getMessage());
                    }
                    throw e;
                }
                try {
                    new FlowActivityTable().createTable(admin, hbaseConf);
                }
                catch (IOException e) {
                    if (skipExisting) {
                        LOG.warn("Skip and continue on: " + e.getMessage());
                    }
                    throw e;
                }
                try {
                    new SubApplicationTable().createTable(admin, hbaseConf);
                }
                catch (IOException e) {
                    if (skipExisting) {
                        LOG.warn("Skip and continue on: " + e.getMessage());
                        break block23;
                    }
                    throw e;
                }
            }
        }
    }
}

