/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.application;

import org.apache.hadoop.yarn.server.timelineservice.storage.application.ApplicationRowKey;

public class ApplicationRowKey {
    private final String clusterId;
    private final String userId;
    private final String flowName;
    private final Long flowRunId;
    private final String appId;
    private final ApplicationRowKeyConverter appRowKeyConverter = new ApplicationRowKeyConverter(null);

    public ApplicationRowKey(String clusterId, String userId, String flowName, Long flowRunId, String appId) {
        this.clusterId = clusterId;
        this.userId = userId;
        this.flowName = flowName;
        this.flowRunId = flowRunId;
        this.appId = appId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public Long getFlowRunId() {
        return this.flowRunId;
    }

    public String getAppId() {
        return this.appId;
    }

    public byte[] getRowKey() {
        return this.appRowKeyConverter.encode(this);
    }

    public static ApplicationRowKey parseRowKey(byte[] rowKey) {
        return new ApplicationRowKeyConverter(null).decode(rowKey);
    }

    public String getRowKeyAsString() {
        return this.appRowKeyConverter.encodeAsString(this);
    }

    public static ApplicationRowKey parseRowKeyFromString(String encodedRowKey) {
        return new ApplicationRowKeyConverter(null).decodeFromString(encodedRowKey);
    }

    static /* synthetic */ String access$100(ApplicationRowKey x0) {
        return x0.clusterId;
    }

    static /* synthetic */ String access$200(ApplicationRowKey x0) {
        return x0.userId;
    }

    static /* synthetic */ String access$300(ApplicationRowKey x0) {
        return x0.flowName;
    }

    static /* synthetic */ Long access$400(ApplicationRowKey x0) {
        return x0.flowRunId;
    }

    static /* synthetic */ String access$500(ApplicationRowKey x0) {
        return x0.appId;
    }
}

