/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.apptoflow;

import java.io.IOException;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.server.timelineservice.storage.apptoflow.AppToFlowColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.apptoflow.AppToFlowTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnHelper;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.KeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.TypedBufferedMutator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ValueConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.Attribute;

/*
 * Exception performing whole class analysis ignored.
 */
public enum AppToFlowColumnPrefix implements ColumnPrefix<AppToFlowTable>
{
    FLOW_NAME((ColumnFamily)AppToFlowColumnFamily.MAPPING, "flow_name"),
    FLOW_RUN_ID((ColumnFamily)AppToFlowColumnFamily.MAPPING, "flow_run_id"),
    USER_ID((ColumnFamily)AppToFlowColumnFamily.MAPPING, "user_id");

    private final ColumnHelper<AppToFlowTable> column;
    private final ColumnFamily<AppToFlowTable> columnFamily;
    private final String columnPrefix;
    private final byte[] columnPrefixBytes;

    private AppToFlowColumnPrefix(ColumnFamily<AppToFlowTable> columnFamily, String columnPrefix) {
        this.columnFamily = columnFamily;
        this.columnPrefix = columnPrefix;
        this.columnPrefixBytes = (byte[])(columnPrefix == null ? null : Bytes.toBytes((String)Separator.SPACE.encode(columnPrefix)));
        this.column = new ColumnHelper(columnFamily);
    }

    public byte[] getColumnPrefixBytes(String qualifierPrefix) {
        return ColumnHelper.getColumnQualifier((byte[])this.columnPrefixBytes, (String)qualifierPrefix);
    }

    public byte[] getColumnPrefixBytes(byte[] qualifierPrefix) {
        return ColumnHelper.getColumnQualifier((byte[])this.columnPrefixBytes, (byte[])qualifierPrefix);
    }

    public byte[] getColumnFamilyBytes() {
        return this.columnFamily.getBytes();
    }

    public void store(byte[] rowKey, TypedBufferedMutator<AppToFlowTable> tableMutator, byte[] qualifier, Long timestamp, Object inputValue, Attribute ... attributes) throws IOException {
        if (qualifier == null) {
            throw new IOException("Cannot store column with null qualifier in " + tableMutator.getName().getNameAsString());
        }
        byte[] columnQualifier = this.getColumnPrefixBytes(qualifier);
        this.column.store(rowKey, tableMutator, columnQualifier, timestamp, inputValue, attributes);
    }

    public void store(byte[] rowKey, TypedBufferedMutator<AppToFlowTable> tableMutator, String qualifier, Long timestamp, Object inputValue, Attribute ... attributes) throws IOException {
        if (qualifier == null) {
            throw new IOException("Cannot store column with null qualifier in " + tableMutator.getName().getNameAsString());
        }
        byte[] columnQualifier = this.getColumnPrefixBytes(qualifier);
        this.column.store(rowKey, tableMutator, columnQualifier, timestamp, inputValue, attributes);
    }

    public ValueConverter getValueConverter() {
        return this.column.getValueConverter();
    }

    public Object readResult(Result result, String qualifier) throws IOException {
        byte[] columnQualifier = ColumnHelper.getColumnQualifier((byte[])this.columnPrefixBytes, (String)qualifier);
        return this.column.readResult(result, columnQualifier);
    }

    public <K> Map<K, Object> readResults(Result result, KeyConverter<K> keyConverter) throws IOException {
        return this.column.readResults(result, this.columnPrefixBytes, keyConverter);
    }

    public <K, V> NavigableMap<K, NavigableMap<Long, V>> readResultsWithTimestamps(Result result, KeyConverter<K> keyConverter) throws IOException {
        return this.column.readResultsWithTimestamps(result, this.columnPrefixBytes, keyConverter);
    }

    public static final AppToFlowColumnPrefix columnFor(String columnPrefix) {
        for (AppToFlowColumnPrefix afcp : AppToFlowColumnPrefix.values()) {
            if (!afcp.columnPrefix.equals(columnPrefix)) continue;
            return afcp;
        }
        return null;
    }

    public static final AppToFlowColumnPrefix columnFor(AppToFlowColumnFamily columnFamily, String columnPrefix) {
        for (AppToFlowColumnPrefix afcp : AppToFlowColumnPrefix.values()) {
            if (!afcp.columnFamily.equals(columnFamily) || (columnPrefix != null || afcp.columnPrefix != null) && !afcp.columnPrefix.equals(columnPrefix)) continue;
            return afcp;
        }
        return null;
    }
}

