/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.common;

import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.server.timelineservice.storage.application.ApplicationRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.application.ApplicationRowKeyPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.apptoflow.AppToFlowRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.AppIdKeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.HBaseTimelineStorageUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.LongConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityRowKeyPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowActivityRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowActivityRowKeyPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.subapplication.SubApplicationRowKey;
import org.junit.Assert;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestRowKeys {
    private static final String QUALIFIER_SEP = Separator.QUALIFIERS.getValue();
    private static final byte[] QUALIFIER_SEP_BYTES = Bytes.toBytes((String)QUALIFIER_SEP);
    private static final String CLUSTER = "cl" + QUALIFIER_SEP + "uster";
    private static final String USER = QUALIFIER_SEP + "user";
    private static final String SUB_APP_USER = QUALIFIER_SEP + "subAppUser";
    private static final String FLOW_NAME = "dummy_" + QUALIFIER_SEP + "flow" + QUALIFIER_SEP;
    private static final Long FLOW_RUN_ID;
    private static final String APPLICATION_ID;

    private static void verifyRowPrefixBytes(byte[] byteRowKeyPrefix) {
        int sepLen = QUALIFIER_SEP_BYTES.length;
        for (int i = 0; i < sepLen; ++i) {
            Assert.assertTrue((String)"Row key prefix not encoded properly.", (byteRowKeyPrefix[byteRowKeyPrefix.length - sepLen + i] == QUALIFIER_SEP_BYTES[i] ? 1 : 0) != 0);
        }
    }

    @Test
    public void testApplicationRowKey() {
        byte[] byteRowKey = new ApplicationRowKey(CLUSTER, USER, FLOW_NAME, FLOW_RUN_ID, APPLICATION_ID).getRowKey();
        ApplicationRowKey rowKey = ApplicationRowKey.parseRowKey((byte[])byteRowKey);
        Assert.assertEquals((Object)CLUSTER, (Object)rowKey.getClusterId());
        Assert.assertEquals((Object)USER, (Object)rowKey.getUserId());
        Assert.assertEquals((Object)FLOW_NAME, (Object)rowKey.getFlowName());
        Assert.assertEquals((Object)FLOW_RUN_ID, (Object)rowKey.getFlowRunId());
        Assert.assertEquals((Object)APPLICATION_ID, (Object)rowKey.getAppId());
        byte[] byteRowKeyPrefix = new ApplicationRowKeyPrefix(CLUSTER, USER, FLOW_NAME, FLOW_RUN_ID).getRowKeyPrefix();
        byte[][] splits = Separator.QUALIFIERS.split(byteRowKeyPrefix, new int[]{0, 0, 0, 8, 0});
        Assert.assertEquals((long)5L, (long)splits.length);
        Assert.assertEquals((long)0L, (long)splits[4].length);
        Assert.assertEquals((Object)FLOW_NAME, (Object)Separator.QUALIFIERS.decode(Bytes.toString((byte[])splits[2])));
        Assert.assertEquals((Object)FLOW_RUN_ID, (Object)LongConverter.invertLong((long)Bytes.toLong((byte[])splits[3])));
        TestRowKeys.verifyRowPrefixBytes((byte[])byteRowKeyPrefix);
        byteRowKeyPrefix = new ApplicationRowKeyPrefix(CLUSTER, USER, FLOW_NAME).getRowKeyPrefix();
        splits = Separator.QUALIFIERS.split(byteRowKeyPrefix, new int[]{0, 0, 0, 0});
        Assert.assertEquals((long)4L, (long)splits.length);
        Assert.assertEquals((long)0L, (long)splits[3].length);
        Assert.assertEquals((Object)FLOW_NAME, (Object)Separator.QUALIFIERS.decode(Bytes.toString((byte[])splits[2])));
        TestRowKeys.verifyRowPrefixBytes((byte[])byteRowKeyPrefix);
    }

    @Test
    public void testAppToFlowRowKey() {
        byte[] byteRowKey = new AppToFlowRowKey(APPLICATION_ID).getRowKey();
        AppToFlowRowKey rowKey = AppToFlowRowKey.parseRowKey((byte[])byteRowKey);
        Assert.assertEquals((Object)APPLICATION_ID, (Object)rowKey.getAppId());
    }

    @Test
    public void testEntityRowKey() {
        TimelineEntity entity = new TimelineEntity();
        entity.setId("!ent!ity!!id!");
        entity.setType("entity!Type");
        entity.setIdPrefix(54321L);
        byte[] byteRowKey = new EntityRowKey(CLUSTER, USER, FLOW_NAME, FLOW_RUN_ID, APPLICATION_ID, entity.getType(), Long.valueOf(entity.getIdPrefix()), entity.getId()).getRowKey();
        EntityRowKey rowKey = EntityRowKey.parseRowKey((byte[])byteRowKey);
        Assert.assertEquals((Object)CLUSTER, (Object)rowKey.getClusterId());
        Assert.assertEquals((Object)USER, (Object)rowKey.getUserId());
        Assert.assertEquals((Object)FLOW_NAME, (Object)rowKey.getFlowName());
        Assert.assertEquals((Object)FLOW_RUN_ID, (Object)rowKey.getFlowRunId());
        Assert.assertEquals((Object)APPLICATION_ID, (Object)rowKey.getAppId());
        Assert.assertEquals((Object)entity.getType(), (Object)rowKey.getEntityType());
        Assert.assertEquals((long)entity.getIdPrefix(), (long)rowKey.getEntityIdPrefix());
        Assert.assertEquals((Object)entity.getId(), (Object)rowKey.getEntityId());
        byte[] byteRowKeyPrefix = new EntityRowKeyPrefix(CLUSTER, USER, FLOW_NAME, FLOW_RUN_ID, APPLICATION_ID, entity.getType(), null, null).getRowKeyPrefix();
        byte[][] splits = Separator.QUALIFIERS.split(byteRowKeyPrefix, new int[]{0, 0, 0, 8, AppIdKeyConverter.getKeySize(), 0, 8, 0});
        Assert.assertEquals((long)7L, (long)splits.length);
        Assert.assertEquals((Object)APPLICATION_ID, (Object)new AppIdKeyConverter().decode(splits[4]));
        Assert.assertEquals((Object)entity.getType(), (Object)Separator.QUALIFIERS.decode(Bytes.toString((byte[])splits[5])));
        TestRowKeys.verifyRowPrefixBytes((byte[])byteRowKeyPrefix);
        byteRowKeyPrefix = new EntityRowKeyPrefix(CLUSTER, USER, FLOW_NAME, FLOW_RUN_ID, APPLICATION_ID).getRowKeyPrefix();
        splits = Separator.QUALIFIERS.split(byteRowKeyPrefix, new int[]{0, 0, 0, 8, AppIdKeyConverter.getKeySize(), 0});
        Assert.assertEquals((long)6L, (long)splits.length);
        Assert.assertEquals((long)0L, (long)splits[5].length);
        AppIdKeyConverter appIdKeyConverter = new AppIdKeyConverter();
        Assert.assertEquals((Object)APPLICATION_ID, (Object)appIdKeyConverter.decode(splits[4]));
        TestRowKeys.verifyRowPrefixBytes((byte[])byteRowKeyPrefix);
    }

    @Test
    public void testFlowActivityRowKey() {
        Long ts = 1459900830000L;
        Long dayTimestamp = HBaseTimelineStorageUtils.getTopOfTheDayTimestamp((long)ts);
        byte[] byteRowKey = new FlowActivityRowKey(CLUSTER, ts, USER, FLOW_NAME).getRowKey();
        FlowActivityRowKey rowKey = FlowActivityRowKey.parseRowKey((byte[])byteRowKey);
        Assert.assertEquals((Object)CLUSTER, (Object)rowKey.getClusterId());
        Assert.assertEquals((Object)dayTimestamp, (Object)rowKey.getDayTimestamp());
        Assert.assertEquals((Object)USER, (Object)rowKey.getUserId());
        Assert.assertEquals((Object)FLOW_NAME, (Object)rowKey.getFlowName());
        byte[] byteRowKeyPrefix = new FlowActivityRowKeyPrefix(CLUSTER).getRowKeyPrefix();
        byte[][] splits = Separator.QUALIFIERS.split(byteRowKeyPrefix, new int[]{0, 0});
        Assert.assertEquals((long)2L, (long)splits.length);
        Assert.assertEquals((long)0L, (long)splits[1].length);
        Assert.assertEquals((Object)CLUSTER, (Object)Separator.QUALIFIERS.decode(Bytes.toString((byte[])splits[0])));
        TestRowKeys.verifyRowPrefixBytes((byte[])byteRowKeyPrefix);
        byteRowKeyPrefix = new FlowActivityRowKeyPrefix(CLUSTER, ts).getRowKeyPrefix();
        splits = Separator.QUALIFIERS.split(byteRowKeyPrefix, new int[]{0, 8, 0});
        Assert.assertEquals((long)3L, (long)splits.length);
        Assert.assertEquals((long)0L, (long)splits[2].length);
        Assert.assertEquals((Object)CLUSTER, (Object)Separator.QUALIFIERS.decode(Bytes.toString((byte[])splits[0])));
        Assert.assertEquals((Object)ts, (Object)LongConverter.invertLong((long)Bytes.toLong((byte[])splits[1])));
        TestRowKeys.verifyRowPrefixBytes((byte[])byteRowKeyPrefix);
    }

    @Test
    public void testFlowRunRowKey() {
        byte[] byteRowKey = new FlowRunRowKey(CLUSTER, USER, FLOW_NAME, FLOW_RUN_ID).getRowKey();
        FlowRunRowKey rowKey = FlowRunRowKey.parseRowKey((byte[])byteRowKey);
        Assert.assertEquals((Object)CLUSTER, (Object)rowKey.getClusterId());
        Assert.assertEquals((Object)USER, (Object)rowKey.getUserId());
        Assert.assertEquals((Object)FLOW_NAME, (Object)rowKey.getFlowName());
        Assert.assertEquals((Object)FLOW_RUN_ID, (Object)rowKey.getFlowRunId());
        byte[] byteRowKeyPrefix = new FlowRunRowKey(CLUSTER, USER, FLOW_NAME, null).getRowKey();
        byte[][] splits = Separator.QUALIFIERS.split(byteRowKeyPrefix, new int[]{0, 0, 0, 0});
        Assert.assertEquals((long)4L, (long)splits.length);
        Assert.assertEquals((long)0L, (long)splits[3].length);
        Assert.assertEquals((Object)FLOW_NAME, (Object)Separator.QUALIFIERS.decode(Bytes.toString((byte[])splits[2])));
        TestRowKeys.verifyRowPrefixBytes((byte[])byteRowKeyPrefix);
    }

    @Test
    public void testSubAppRowKey() {
        TimelineEntity entity = new TimelineEntity();
        entity.setId("entity1");
        entity.setType("DAG");
        entity.setIdPrefix(54321L);
        byte[] byteRowKey = new SubApplicationRowKey(SUB_APP_USER, CLUSTER, entity.getType(), Long.valueOf(entity.getIdPrefix()), entity.getId(), USER).getRowKey();
        SubApplicationRowKey rowKey = SubApplicationRowKey.parseRowKey((byte[])byteRowKey);
        Assert.assertEquals((Object)CLUSTER, (Object)rowKey.getClusterId());
        Assert.assertEquals((Object)SUB_APP_USER, (Object)rowKey.getSubAppUserId());
        Assert.assertEquals((Object)entity.getType(), (Object)rowKey.getEntityType());
        Assert.assertEquals((long)entity.getIdPrefix(), (long)rowKey.getEntityIdPrefix());
        Assert.assertEquals((Object)entity.getId(), (Object)rowKey.getEntityId());
        Assert.assertEquals((Object)USER, (Object)rowKey.getUserId());
    }

    static {
        long runid = 9223372036854774907L;
        byte[] longMaxByteArr = Bytes.toBytes((long)Long.MAX_VALUE);
        int sepByteLen = QUALIFIER_SEP_BYTES.length;
        byte[] byteArr = Bytes.toBytes((long)runid);
        if (sepByteLen <= byteArr.length) {
            for (int i = 0; i < sepByteLen; ++i) {
                byteArr[i] = (byte)(longMaxByteArr[i] - QUALIFIER_SEP_BYTES[i]);
            }
        }
        FLOW_RUN_ID = Bytes.toLong((byte[])byteArr);
        long clusterTs = System.currentTimeMillis();
        byteArr = Bytes.toBytes((long)clusterTs);
        if (sepByteLen <= byteArr.length) {
            for (int i = 0; i < sepByteLen; ++i) {
                byteArr[byteArr.length - sepByteLen + i] = (byte)(longMaxByteArr[byteArr.length - sepByteLen + i] - QUALIFIER_SEP_BYTES[i]);
            }
        }
        clusterTs = Bytes.toLong((byte[])byteArr);
        int seqId = 222;
        APPLICATION_ID = ApplicationId.newInstance((long)clusterTs, (int)seqId).toString();
    }
}

