/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.entity;

import java.io.IOException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Column;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnHelper;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.GenericConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.LongConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.TypedBufferedMutator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ValueConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.Attribute;

public enum EntityColumn implements Column<EntityTable>
{
    ID((ColumnFamily)EntityColumnFamily.INFO, "id"),
    TYPE((ColumnFamily)EntityColumnFamily.INFO, "type"),
    CREATED_TIME((ColumnFamily)EntityColumnFamily.INFO, "created_time", (ValueConverter)new LongConverter()),
    FLOW_VERSION((ColumnFamily)EntityColumnFamily.INFO, "flow_version");

    private final ColumnHelper<EntityTable> column;
    private final ColumnFamily<EntityTable> columnFamily;
    private final String columnQualifier;
    private final byte[] columnQualifierBytes;

    private EntityColumn(ColumnFamily<EntityTable> columnFamily, String columnQualifier) {
        this(string, n, columnFamily, columnQualifier, (ValueConverter)GenericConverter.getInstance());
    }

    private EntityColumn(ColumnFamily<EntityTable> columnFamily, String columnQualifier, ValueConverter converter) {
        this.columnFamily = columnFamily;
        this.columnQualifier = columnQualifier;
        this.columnQualifierBytes = Bytes.toBytes((String)Separator.SPACE.encode(columnQualifier));
        this.column = new ColumnHelper(columnFamily, converter);
    }

    private String getColumnQualifier() {
        return this.columnQualifier;
    }

    public void store(byte[] rowKey, TypedBufferedMutator<EntityTable> tableMutator, Long timestamp, Object inputValue, Attribute ... attributes) throws IOException {
        this.column.store(rowKey, tableMutator, this.columnQualifierBytes, timestamp, inputValue, attributes);
    }

    public Object readResult(Result result) throws IOException {
        return this.column.readResult(result, this.columnQualifierBytes);
    }

    public byte[] getColumnQualifierBytes() {
        return (byte[])this.columnQualifierBytes.clone();
    }

    public byte[] getColumnFamilyBytes() {
        return this.columnFamily.getBytes();
    }

    public ValueConverter getValueConverter() {
        return this.column.getValueConverter();
    }
}

