/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.entity;

import java.io.IOException;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnHelper;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.GenericConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.KeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.LongConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.TypedBufferedMutator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ValueConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.Attribute;

public enum EntityColumnPrefix implements ColumnPrefix<EntityTable>
{
    IS_RELATED_TO((ColumnFamily)EntityColumnFamily.INFO, "s"),
    RELATES_TO((ColumnFamily)EntityColumnFamily.INFO, "r"),
    INFO((ColumnFamily)EntityColumnFamily.INFO, "i"),
    EVENT((ColumnFamily)EntityColumnFamily.INFO, "e", true),
    CONFIG((ColumnFamily)EntityColumnFamily.CONFIGS, null),
    METRIC((ColumnFamily)EntityColumnFamily.METRICS, null, (ValueConverter)new LongConverter());

    private final ColumnHelper<EntityTable> column;
    private final ColumnFamily<EntityTable> columnFamily;
    private final String columnPrefix;
    private final byte[] columnPrefixBytes;

    private EntityColumnPrefix(ColumnFamily<EntityTable> columnFamily, String columnPrefix) {
        this(string, n, columnFamily, columnPrefix, false, (ValueConverter)GenericConverter.getInstance());
    }

    private EntityColumnPrefix(ColumnFamily<EntityTable> columnFamily, String columnPrefix, boolean compondColQual) {
        this(string, n, columnFamily, columnPrefix, compondColQual, (ValueConverter)GenericConverter.getInstance());
    }

    private EntityColumnPrefix(ColumnFamily<EntityTable> columnFamily, String columnPrefix, ValueConverter converter) {
        this(string, n, columnFamily, columnPrefix, false, converter);
    }

    private EntityColumnPrefix(ColumnFamily<EntityTable> columnFamily, String columnPrefix, boolean compondColQual, ValueConverter converter) {
        this.column = new ColumnHelper(columnFamily, converter);
        this.columnFamily = columnFamily;
        this.columnPrefix = columnPrefix;
        this.columnPrefixBytes = (byte[])(columnPrefix == null ? null : Bytes.toBytes((String)Separator.SPACE.encode(columnPrefix)));
    }

    public String getColumnPrefix() {
        return this.columnPrefix;
    }

    public byte[] getColumnPrefixBytes(byte[] qualifierPrefix) {
        return ColumnHelper.getColumnQualifier((byte[])this.columnPrefixBytes, (byte[])qualifierPrefix);
    }

    public byte[] getColumnPrefixBytes(String qualifierPrefix) {
        return ColumnHelper.getColumnQualifier((byte[])this.columnPrefixBytes, (String)qualifierPrefix);
    }

    public byte[] getColumnFamilyBytes() {
        return this.columnFamily.getBytes();
    }

    public ValueConverter getValueConverter() {
        return this.column.getValueConverter();
    }

    public void store(byte[] rowKey, TypedBufferedMutator<EntityTable> tableMutator, String qualifier, Long timestamp, Object inputValue, Attribute ... attributes) throws IOException {
        if (qualifier == null) {
            throw new IOException("Cannot store column with null qualifier in " + tableMutator.getName().getNameAsString());
        }
        byte[] columnQualifier = this.getColumnPrefixBytes(qualifier);
        this.column.store(rowKey, tableMutator, columnQualifier, timestamp, inputValue, attributes);
    }

    public void store(byte[] rowKey, TypedBufferedMutator<EntityTable> tableMutator, byte[] qualifier, Long timestamp, Object inputValue, Attribute ... attributes) throws IOException {
        if (qualifier == null) {
            throw new IOException("Cannot store column with null qualifier in " + tableMutator.getName().getNameAsString());
        }
        byte[] columnQualifier = this.getColumnPrefixBytes(qualifier);
        this.column.store(rowKey, tableMutator, columnQualifier, timestamp, inputValue, attributes);
    }

    public Object readResult(Result result, String qualifier) throws IOException {
        byte[] columnQualifier = ColumnHelper.getColumnQualifier((byte[])this.columnPrefixBytes, (String)qualifier);
        return this.column.readResult(result, columnQualifier);
    }

    public <K> Map<K, Object> readResults(Result result, KeyConverter<K> keyConverter) throws IOException {
        return this.column.readResults(result, this.columnPrefixBytes, keyConverter);
    }

    public <K, V> NavigableMap<K, NavigableMap<Long, V>> readResultsWithTimestamps(Result result, KeyConverter<K> keyConverter) throws IOException {
        return this.column.readResultsWithTimestamps(result, this.columnPrefixBytes, keyConverter);
    }
}

