/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.entity;

import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityRowKey;

public class EntityRowKey {
    private final String clusterId;
    private final String userId;
    private final String flowName;
    private final Long flowRunId;
    private final String appId;
    private final String entityType;
    private final Long entityIdPrefix;
    private final String entityId;
    private final EntityRowKeyConverter entityRowKeyConverter = new EntityRowKeyConverter(null);

    public EntityRowKey(String clusterId, String userId, String flowName, Long flowRunId, String appId, String entityType, Long entityIdPrefix, String entityId) {
        this.clusterId = clusterId;
        this.userId = userId;
        this.flowName = flowName;
        this.flowRunId = flowRunId;
        this.appId = appId;
        this.entityType = entityType;
        this.entityIdPrefix = entityIdPrefix;
        this.entityId = entityId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public Long getFlowRunId() {
        return this.flowRunId;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public Long getEntityIdPrefix() {
        return this.entityIdPrefix;
    }

    public byte[] getRowKey() {
        return this.entityRowKeyConverter.encode(this);
    }

    public static EntityRowKey parseRowKey(byte[] rowKey) {
        return new EntityRowKeyConverter(null).decode(rowKey);
    }

    public String getRowKeyAsString() {
        return this.entityRowKeyConverter.encodeAsString(this);
    }

    public static EntityRowKey parseRowKeyFromString(String encodedRowKey) {
        return new EntityRowKeyConverter(null).decodeFromString(encodedRowKey);
    }

    static /* synthetic */ String access$100(EntityRowKey x0) {
        return x0.clusterId;
    }

    static /* synthetic */ String access$200(EntityRowKey x0) {
        return x0.userId;
    }

    static /* synthetic */ String access$300(EntityRowKey x0) {
        return x0.flowName;
    }

    static /* synthetic */ Long access$400(EntityRowKey x0) {
        return x0.flowRunId;
    }

    static /* synthetic */ String access$500(EntityRowKey x0) {
        return x0.appId;
    }

    static /* synthetic */ String access$600(EntityRowKey x0) {
        return x0.entityType;
    }

    static /* synthetic */ Long access$700(EntityRowKey x0) {
        return x0.entityIdPrefix;
    }

    static /* synthetic */ String access$800(EntityRowKey x0) {
        return x0.entityId;
    }
}

