/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.entity;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.BaseTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.TimelineHBaseSchemaConstants;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityColumnFamily;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityTable
extends BaseTable<EntityTable> {
    private static final String PREFIX = "yarn.timeline-service.entity";
    public static final String TABLE_NAME_CONF_NAME = "yarn.timeline-service.entity.table.name";
    private static final String METRICS_TTL_CONF_NAME = "yarn.timeline-service.entity.table.metrics.ttl";
    private static final String METRICS_MAX_VERSIONS = "yarn.timeline-service.entity.table.metrics.max-versions";
    public static final String DEFAULT_TABLE_NAME = "timelineservice.entity";
    private static final int DEFAULT_METRICS_TTL = 2592000;
    private static final int DEFAULT_METRICS_MAX_VERSIONS = 10000;
    private static final Logger LOG = LoggerFactory.getLogger(EntityTable.class);

    public EntityTable() {
        super(TABLE_NAME_CONF_NAME, DEFAULT_TABLE_NAME);
    }

    public void createTable(Admin admin, Configuration hbaseConf) throws IOException {
        TableName table = this.getTableName(hbaseConf);
        if (admin.tableExists(table)) {
            throw new IOException("Table " + table.getNameAsString() + " already exists.");
        }
        HTableDescriptor entityTableDescp = new HTableDescriptor(table);
        HColumnDescriptor infoCF = new HColumnDescriptor(EntityColumnFamily.INFO.getBytes());
        infoCF.setBloomFilterType(BloomType.ROWCOL);
        entityTableDescp.addFamily(infoCF);
        HColumnDescriptor configCF = new HColumnDescriptor(EntityColumnFamily.CONFIGS.getBytes());
        configCF.setBloomFilterType(BloomType.ROWCOL);
        configCF.setBlockCacheEnabled(true);
        entityTableDescp.addFamily(configCF);
        HColumnDescriptor metricsCF = new HColumnDescriptor(EntityColumnFamily.METRICS.getBytes());
        entityTableDescp.addFamily(metricsCF);
        metricsCF.setBlockCacheEnabled(true);
        metricsCF.setMinVersions(1);
        metricsCF.setMaxVersions(hbaseConf.getInt(METRICS_MAX_VERSIONS, 10000));
        metricsCF.setTimeToLive(hbaseConf.getInt(METRICS_TTL_CONF_NAME, 2592000));
        entityTableDescp.setRegionSplitPolicyClassName("org.apache.hadoop.hbase.regionserver.KeyPrefixRegionSplitPolicy");
        entityTableDescp.setValue("KeyPrefixRegionSplitPolicy.prefix_length", "4");
        admin.createTable(entityTableDescp, TimelineHBaseSchemaConstants.getUsernameSplits());
        LOG.info("Status of table creation for " + table.getNameAsString() + "=" + admin.tableExists(table));
    }

    public void setMetricsTTL(int metricsTTL, Configuration hbaseConf) {
        hbaseConf.setInt(METRICS_TTL_CONF_NAME, metricsTTL);
    }
}

