/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.flow;

import org.apache.hadoop.yarn.server.timelineservice.storage.common.HBaseTimelineStorageUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowActivityRowKey;

public class FlowActivityRowKey {
    private final String clusterId;
    private final Long dayTs;
    private final String userId;
    private final String flowName;
    private final FlowActivityRowKeyConverter flowActivityRowKeyConverter = new FlowActivityRowKeyConverter(null);

    public FlowActivityRowKey(String clusterId, Long dayTs, String userId, String flowName) {
        this(clusterId, dayTs, userId, flowName, true);
    }

    protected FlowActivityRowKey(String clusterId, Long timestamp, String userId, String flowName, boolean convertDayTsToTopOfDay) {
        this.clusterId = clusterId;
        this.dayTs = convertDayTsToTopOfDay && timestamp != null ? Long.valueOf(HBaseTimelineStorageUtils.getTopOfTheDayTimestamp((long)timestamp)) : timestamp;
        this.userId = userId;
        this.flowName = flowName;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public Long getDayTimestamp() {
        return this.dayTs;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public byte[] getRowKey() {
        return this.flowActivityRowKeyConverter.encode(this);
    }

    public static FlowActivityRowKey parseRowKey(byte[] rowKey) {
        return new FlowActivityRowKeyConverter(null).decode(rowKey);
    }

    public String getRowKeyAsString() {
        return this.flowActivityRowKeyConverter.encodeAsString(this);
    }

    public static FlowActivityRowKey parseRowKeyFromString(String encodedRowKey) {
        return new FlowActivityRowKeyConverter(null).decodeFromString(encodedRowKey);
    }

    static /* synthetic */ String access$100(FlowActivityRowKey x0) {
        return x0.clusterId;
    }

    static /* synthetic */ Long access$200(FlowActivityRowKey x0) {
        return x0.dayTs;
    }

    static /* synthetic */ String access$300(FlowActivityRowKey x0) {
        return x0.userId;
    }

    static /* synthetic */ String access$400(FlowActivityRowKey x0) {
        return x0.flowName;
    }
}

