/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.flow;

import java.io.IOException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Column;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnHelper;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.GenericConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.HBaseTimelineStorageUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.LongConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.TypedBufferedMutator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ValueConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.AggregationOperation;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.Attribute;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunTable;

public enum FlowRunColumn implements Column<FlowRunTable>
{
    MIN_START_TIME((ColumnFamily)FlowRunColumnFamily.INFO, "min_start_time", AggregationOperation.GLOBAL_MIN, (ValueConverter)new LongConverter()),
    MAX_END_TIME((ColumnFamily)FlowRunColumnFamily.INFO, "max_end_time", AggregationOperation.GLOBAL_MAX, (ValueConverter)new LongConverter()),
    FLOW_VERSION((ColumnFamily)FlowRunColumnFamily.INFO, "flow_version", null);

    private final ColumnHelper<FlowRunTable> column;
    private final ColumnFamily<FlowRunTable> columnFamily;
    private final String columnQualifier;
    private final byte[] columnQualifierBytes;
    private final AggregationOperation aggOp;

    private FlowRunColumn(ColumnFamily<FlowRunTable> columnFamily, String columnQualifier, AggregationOperation aggOp) {
        this(string, n, columnFamily, columnQualifier, aggOp, (ValueConverter)GenericConverter.getInstance());
    }

    private FlowRunColumn(ColumnFamily<FlowRunTable> columnFamily, String columnQualifier, AggregationOperation aggOp, ValueConverter converter) {
        this.columnFamily = columnFamily;
        this.columnQualifier = columnQualifier;
        this.aggOp = aggOp;
        this.columnQualifierBytes = Bytes.toBytes((String)Separator.SPACE.encode(columnQualifier));
        this.column = new ColumnHelper(columnFamily, converter, true);
    }

    private String getColumnQualifier() {
        return this.columnQualifier;
    }

    public byte[] getColumnQualifierBytes() {
        return (byte[])this.columnQualifierBytes.clone();
    }

    public byte[] getColumnFamilyBytes() {
        return this.columnFamily.getBytes();
    }

    public AggregationOperation getAggregationOperation() {
        return this.aggOp;
    }

    public void store(byte[] rowKey, TypedBufferedMutator<FlowRunTable> tableMutator, Long timestamp, Object inputValue, Attribute ... attributes) throws IOException {
        Attribute[] combinedAttributes = HBaseTimelineStorageUtils.combineAttributes((Attribute[])attributes, (AggregationOperation)this.aggOp);
        this.column.store(rowKey, tableMutator, this.columnQualifierBytes, timestamp, inputValue, combinedAttributes);
    }

    public Object readResult(Result result) throws IOException {
        return this.column.readResult(result, this.columnQualifierBytes);
    }

    public ValueConverter getValueConverter() {
        return this.column.getValueConverter();
    }
}

