/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.flow;

import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunRowKey;

public class FlowRunRowKey {
    private final String clusterId;
    private final String userId;
    private final String flowName;
    private final Long flowRunId;
    private final FlowRunRowKeyConverter flowRunRowKeyConverter = new FlowRunRowKeyConverter(null);

    public FlowRunRowKey(String clusterId, String userId, String flowName, Long flowRunId) {
        this.clusterId = clusterId;
        this.userId = userId;
        this.flowName = flowName;
        this.flowRunId = flowRunId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public Long getFlowRunId() {
        return this.flowRunId;
    }

    public byte[] getRowKey() {
        return this.flowRunRowKeyConverter.encode(this);
    }

    public static FlowRunRowKey parseRowKey(byte[] rowKey) {
        return new FlowRunRowKeyConverter(null).decode(rowKey);
    }

    public String getRowKeyAsString() {
        return this.flowRunRowKeyConverter.encodeAsString(this);
    }

    public static FlowRunRowKey parseRowKeyFromString(String encodedRowKey) {
        return new FlowRunRowKeyConverter(null).decodeFromString(encodedRowKey);
    }

    public String toString() {
        StringBuilder flowKeyStr = new StringBuilder();
        flowKeyStr.append("{clusterId=" + this.clusterId);
        flowKeyStr.append(" userId=" + this.userId);
        flowKeyStr.append(" flowName=" + this.flowName);
        flowKeyStr.append(" flowRunId=");
        flowKeyStr.append(this.flowRunId);
        flowKeyStr.append("}");
        return flowKeyStr.toString();
    }

    static /* synthetic */ String access$100(FlowRunRowKey x0) {
        return x0.clusterId;
    }

    static /* synthetic */ String access$200(FlowRunRowKey x0) {
        return x0.userId;
    }

    static /* synthetic */ String access$300(FlowRunRowKey x0) {
        return x0.flowName;
    }

    static /* synthetic */ Long access$400(FlowRunRowKey x0) {
        return x0.flowRunId;
    }
}

