/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage;

import java.io.IOException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineDataToRetrieve;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineEntityFilters;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderContext;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineReader;
import org.apache.hadoop.yarn.server.timelineservice.storage.reader.TimelineEntityReader;
import org.apache.hadoop.yarn.server.timelineservice.storage.reader.TimelineEntityReaderFactory;

public class HBaseTimelineReaderImpl
extends AbstractService
implements TimelineReader {
    private static final Log LOG = LogFactory.getLog(HBaseTimelineReaderImpl.class);
    private Configuration hbaseConf = null;
    private Connection conn;

    public HBaseTimelineReaderImpl() {
        super(HBaseTimelineReaderImpl.class.getName());
    }

    public void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        this.hbaseConf = HBaseConfiguration.create((Configuration)conf);
        this.conn = ConnectionFactory.createConnection((Configuration)this.hbaseConf);
    }

    protected void serviceStop() throws Exception {
        if (this.conn != null) {
            LOG.info((Object)"closing the hbase Connection");
            this.conn.close();
        }
        super.serviceStop();
    }

    public TimelineEntity getEntity(TimelineReaderContext context, TimelineDataToRetrieve dataToRetrieve) throws IOException {
        TimelineEntityReader reader = TimelineEntityReaderFactory.createSingleEntityReader(context, dataToRetrieve);
        return reader.readEntity(this.hbaseConf, this.conn);
    }

    public Set<TimelineEntity> getEntities(TimelineReaderContext context, TimelineEntityFilters filters, TimelineDataToRetrieve dataToRetrieve) throws IOException {
        TimelineEntityReader reader = TimelineEntityReaderFactory.createMultipleEntitiesReader(context, filters, dataToRetrieve);
        return reader.readEntities(this.hbaseConf, this.conn);
    }
}

