/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineWriteResponse;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineAggregationTrack;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineWriter;
import org.apache.hadoop.yarn.server.timelineservice.storage.application.ApplicationColumn;
import org.apache.hadoop.yarn.server.timelineservice.storage.application.ApplicationColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.application.ApplicationRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.application.ApplicationTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.apptoflow.AppToFlowColumn;
import org.apache.hadoop.yarn.server.timelineservice.storage.apptoflow.AppToFlowRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.apptoflow.AppToFlowTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.EventColumnName;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.KeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.LongKeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.StringKeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.TypedBufferedMutator;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityColumn;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.AggregationCompactionDimension;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.AggregationOperation;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.Attribute;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowActivityColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowActivityRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowActivityTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunColumn;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunTable;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class HBaseTimelineWriterImpl
extends AbstractService
implements TimelineWriter {
    private static final Log LOG = LogFactory.getLog(HBaseTimelineWriterImpl.class);
    private Connection conn;
    private TypedBufferedMutator<EntityTable> entityTable;
    private TypedBufferedMutator<AppToFlowTable> appToFlowTable;
    private TypedBufferedMutator<ApplicationTable> applicationTable;
    private TypedBufferedMutator<FlowActivityTable> flowActivityTable;
    private TypedBufferedMutator<FlowRunTable> flowRunTable;
    private final KeyConverter<String> stringKeyConverter = new StringKeyConverter();
    private final KeyConverter<Long> longKeyConverter = new LongKeyConverter();

    public HBaseTimelineWriterImpl() {
        super(HBaseTimelineWriterImpl.class.getName());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        Configuration hbaseConf = HBaseConfiguration.create((Configuration)conf);
        this.conn = ConnectionFactory.createConnection((Configuration)hbaseConf);
        this.entityTable = new EntityTable().getTableMutator(hbaseConf, this.conn);
        this.appToFlowTable = new AppToFlowTable().getTableMutator(hbaseConf, this.conn);
        this.applicationTable = new ApplicationTable().getTableMutator(hbaseConf, this.conn);
        this.flowRunTable = new FlowRunTable().getTableMutator(hbaseConf, this.conn);
        this.flowActivityTable = new FlowActivityTable().getTableMutator(hbaseConf, this.conn);
    }

    public TimelineWriteResponse write(String clusterId, String userId, String flowName, String flowVersion, long flowRunId, String appId, TimelineEntities data) throws IOException {
        TimelineWriteResponse putStatus = new TimelineWriteResponse();
        if (flowName == null || appId == null || clusterId == null || userId == null) {
            LOG.warn((Object)("Found null for one of: flowName=" + flowName + " appId=" + appId + " userId=" + userId + " clusterId=" + clusterId + " . Not proceeding with writing to hbase"));
            return putStatus;
        }
        for (TimelineEntity te : data.getEntities()) {
            byte[] rowKey;
            if (te == null) continue;
            boolean isApplication = HBaseTimelineWriterImpl.isApplicationEntity(te);
            if (isApplication) {
                ApplicationRowKey applicationRowKey = new ApplicationRowKey(clusterId, userId, flowName, flowRunId, appId);
                rowKey = applicationRowKey.getRowKey();
            } else {
                EntityRowKey entityRowKey = new EntityRowKey(clusterId, userId, flowName, flowRunId, appId, te.getType(), te.getId());
                rowKey = entityRowKey.getRowKey();
            }
            this.storeInfo(rowKey, te, flowVersion, isApplication);
            this.storeEvents(rowKey, te.getEvents(), isApplication);
            this.storeConfig(rowKey, te.getConfigs(), isApplication);
            this.storeMetrics(rowKey, te.getMetrics(), isApplication);
            this.storeRelations(rowKey, te, isApplication);
            if (!isApplication) continue;
            TimelineEvent event = HBaseTimelineWriterImpl.getApplicationEvent(te, "YARN_APPLICATION_CREATED");
            FlowRunRowKey flowRunRowKey = new FlowRunRowKey(clusterId, userId, flowName, flowRunId);
            if (event != null) {
                AppToFlowRowKey appToFlowRowKey = new AppToFlowRowKey(clusterId, appId);
                this.onApplicationCreated(flowRunRowKey, appToFlowRowKey, appId, userId, flowVersion, te, event.getTimestamp());
            }
            this.storeFlowMetricsAppRunning(flowRunRowKey, appId, te);
            event = HBaseTimelineWriterImpl.getApplicationEvent(te, "YARN_APPLICATION_FINISHED");
            if (event == null) continue;
            this.onApplicationFinished(flowRunRowKey, flowVersion, appId, te, event.getTimestamp());
        }
        return putStatus;
    }

    private void onApplicationCreated(FlowRunRowKey flowRunRowKey, AppToFlowRowKey appToFlowRowKey, String appId, String userId, String flowVersion, TimelineEntity te, long appCreatedTimeStamp) throws IOException {
        String flowName = flowRunRowKey.getFlowName();
        Long flowRunId = flowRunRowKey.getFlowRunId();
        byte[] rowKey = appToFlowRowKey.getRowKey();
        AppToFlowColumn.FLOW_ID.store(rowKey, this.appToFlowTable, (Long)null, (Object)flowName, new Attribute[0]);
        AppToFlowColumn.FLOW_RUN_ID.store(rowKey, this.appToFlowTable, (Long)null, (Object)flowRunId, new Attribute[0]);
        AppToFlowColumn.USER_ID.store(rowKey, this.appToFlowTable, (Long)null, (Object)userId, new Attribute[0]);
        this.storeAppCreatedInFlowRunTable(flowRunRowKey, appId, te);
        byte[] flowActivityRowKeyBytes = new FlowActivityRowKey(flowRunRowKey.getClusterId(), appCreatedTimeStamp, flowRunRowKey.getUserId(), flowName).getRowKey();
        byte[] qualifier = this.longKeyConverter.encode(flowRunRowKey.getFlowRunId());
        FlowActivityColumnPrefix.RUN_ID.store(flowActivityRowKeyBytes, this.flowActivityTable, qualifier, (Long)null, (Object)flowVersion, new Attribute[]{AggregationCompactionDimension.APPLICATION_ID.getAttribute(appId)});
    }

    private void storeAppCreatedInFlowRunTable(FlowRunRowKey flowRunRowKey, String appId, TimelineEntity te) throws IOException {
        byte[] rowKey = flowRunRowKey.getRowKey();
        FlowRunColumn.MIN_START_TIME.store(rowKey, this.flowRunTable, (Long)null, (Object)te.getCreatedTime(), new Attribute[]{AggregationCompactionDimension.APPLICATION_ID.getAttribute(appId)});
    }

    private void onApplicationFinished(FlowRunRowKey flowRunRowKey, String flowVersion, String appId, TimelineEntity te, long appFinishedTimeStamp) throws IOException {
        this.storeAppFinishedInFlowRunTable(flowRunRowKey, appId, te, appFinishedTimeStamp);
        byte[] rowKey = new FlowActivityRowKey(flowRunRowKey.getClusterId(), appFinishedTimeStamp, flowRunRowKey.getUserId(), flowRunRowKey.getFlowName()).getRowKey();
        byte[] qualifier = this.longKeyConverter.encode(flowRunRowKey.getFlowRunId());
        FlowActivityColumnPrefix.RUN_ID.store(rowKey, this.flowActivityTable, qualifier, (Long)null, (Object)flowVersion, new Attribute[]{AggregationCompactionDimension.APPLICATION_ID.getAttribute(appId)});
    }

    private void storeAppFinishedInFlowRunTable(FlowRunRowKey flowRunRowKey, String appId, TimelineEntity te, long appFinishedTimeStamp) throws IOException {
        byte[] rowKey = flowRunRowKey.getRowKey();
        Attribute attributeAppId = AggregationCompactionDimension.APPLICATION_ID.getAttribute(appId);
        FlowRunColumn.MAX_END_TIME.store(rowKey, this.flowRunTable, (Long)null, (Object)appFinishedTimeStamp, new Attribute[]{attributeAppId});
        Set metrics = te.getMetrics();
        if (metrics != null) {
            this.storeFlowMetrics(rowKey, metrics, attributeAppId, AggregationOperation.SUM_FINAL.getAttribute());
        }
    }

    private void storeFlowMetricsAppRunning(FlowRunRowKey flowRunRowKey, String appId, TimelineEntity te) throws IOException {
        Set metrics = te.getMetrics();
        if (metrics != null) {
            byte[] rowKey = flowRunRowKey.getRowKey();
            this.storeFlowMetrics(rowKey, metrics, AggregationCompactionDimension.APPLICATION_ID.getAttribute(appId), AggregationOperation.SUM.getAttribute());
        }
    }

    private void storeFlowMetrics(byte[] rowKey, Set<TimelineMetric> metrics, Attribute ... attributes) throws IOException {
        for (TimelineMetric metric : metrics) {
            byte[] metricColumnQualifier = this.stringKeyConverter.encode(metric.getId());
            Map timeseries = metric.getValues();
            for (Map.Entry timeseriesEntry : timeseries.entrySet()) {
                Long timestamp = (Long)timeseriesEntry.getKey();
                FlowRunColumnPrefix.METRIC.store(rowKey, this.flowRunTable, metricColumnQualifier, timestamp, timeseriesEntry.getValue(), attributes);
            }
        }
    }

    private void storeRelations(byte[] rowKey, TimelineEntity te, boolean isApplication) throws IOException {
        if (isApplication) {
            this.storeRelations(rowKey, te.getIsRelatedToEntities(), ApplicationColumnPrefix.IS_RELATED_TO, this.applicationTable);
            this.storeRelations(rowKey, te.getRelatesToEntities(), ApplicationColumnPrefix.RELATES_TO, this.applicationTable);
        } else {
            this.storeRelations(rowKey, te.getIsRelatedToEntities(), EntityColumnPrefix.IS_RELATED_TO, this.entityTable);
            this.storeRelations(rowKey, te.getRelatesToEntities(), EntityColumnPrefix.RELATES_TO, this.entityTable);
        }
    }

    private <T> void storeRelations(byte[] rowKey, Map<String, Set<String>> connectedEntities, ColumnPrefix<T> columnPrefix, TypedBufferedMutator<T> table) throws IOException {
        for (Map.Entry<String, Set<String>> connectedEntity : connectedEntities.entrySet()) {
            String compoundValue = Separator.VALUES.joinEncoded((Iterable)connectedEntity.getValue());
            columnPrefix.store(rowKey, table, this.stringKeyConverter.encode(connectedEntity.getKey()), null, (Object)compoundValue, new Attribute[0]);
        }
    }

    private void storeInfo(byte[] rowKey, TimelineEntity te, String flowVersion, boolean isApplication) throws IOException {
        block4: {
            block3: {
                if (!isApplication) break block3;
                ApplicationColumn.ID.store(rowKey, this.applicationTable, (Long)null, (Object)te.getId(), new Attribute[0]);
                ApplicationColumn.CREATED_TIME.store(rowKey, this.applicationTable, (Long)null, (Object)te.getCreatedTime(), new Attribute[0]);
                ApplicationColumn.FLOW_VERSION.store(rowKey, this.applicationTable, (Long)null, (Object)flowVersion, new Attribute[0]);
                Map info = te.getInfo();
                if (info == null) break block4;
                for (Map.Entry entry : info.entrySet()) {
                    ApplicationColumnPrefix.INFO.store(rowKey, this.applicationTable, this.stringKeyConverter.encode((String)entry.getKey()), (Long)null, entry.getValue(), new Attribute[0]);
                }
                break block4;
            }
            EntityColumn.ID.store(rowKey, this.entityTable, (Long)null, (Object)te.getId(), new Attribute[0]);
            EntityColumn.TYPE.store(rowKey, this.entityTable, (Long)null, (Object)te.getType(), new Attribute[0]);
            EntityColumn.CREATED_TIME.store(rowKey, this.entityTable, (Long)null, (Object)te.getCreatedTime(), new Attribute[0]);
            EntityColumn.FLOW_VERSION.store(rowKey, this.entityTable, (Long)null, (Object)flowVersion, new Attribute[0]);
            Map info = te.getInfo();
            if (info != null) {
                for (Map.Entry entry : info.entrySet()) {
                    EntityColumnPrefix.INFO.store(rowKey, this.entityTable, this.stringKeyConverter.encode((String)entry.getKey()), (Long)null, entry.getValue(), new Attribute[0]);
                }
            }
        }
    }

    private void storeConfig(byte[] rowKey, Map<String, String> config, boolean isApplication) throws IOException {
        if (config == null) {
            return;
        }
        for (Map.Entry<String, String> entry : config.entrySet()) {
            byte[] configKey = this.stringKeyConverter.encode(entry.getKey());
            if (isApplication) {
                ApplicationColumnPrefix.CONFIG.store(rowKey, this.applicationTable, configKey, (Long)null, (Object)entry.getValue(), new Attribute[0]);
                continue;
            }
            EntityColumnPrefix.CONFIG.store(rowKey, this.entityTable, configKey, (Long)null, (Object)entry.getValue(), new Attribute[0]);
        }
    }

    private void storeMetrics(byte[] rowKey, Set<TimelineMetric> metrics, boolean isApplication) throws IOException {
        if (metrics != null) {
            for (TimelineMetric metric : metrics) {
                byte[] metricColumnQualifier = this.stringKeyConverter.encode(metric.getId());
                Map timeseries = metric.getValues();
                for (Map.Entry timeseriesEntry : timeseries.entrySet()) {
                    Long timestamp = (Long)timeseriesEntry.getKey();
                    if (isApplication) {
                        ApplicationColumnPrefix.METRIC.store(rowKey, this.applicationTable, metricColumnQualifier, timestamp, timeseriesEntry.getValue(), new Attribute[0]);
                        continue;
                    }
                    EntityColumnPrefix.METRIC.store(rowKey, this.entityTable, metricColumnQualifier, timestamp, timeseriesEntry.getValue(), new Attribute[0]);
                }
            }
        }
    }

    private void storeEvents(byte[] rowKey, Set<TimelineEvent> events, boolean isApplication) throws IOException {
        if (events != null) {
            for (TimelineEvent event : events) {
                Map eventInfo;
                String eventId;
                if (event == null || (eventId = event.getId()) == null) continue;
                long eventTimestamp = event.getTimestamp();
                if (eventTimestamp == 0L) {
                    LOG.warn((Object)("timestamp is not set for event " + eventId + "! Using the current timestamp"));
                    eventTimestamp = System.currentTimeMillis();
                }
                if ((eventInfo = event.getInfo()) == null || eventInfo.size() == 0) {
                    byte[] columnQualifierBytes = new EventColumnName(eventId, eventTimestamp, null).getColumnQualifier();
                    if (isApplication) {
                        ApplicationColumnPrefix.EVENT.store(rowKey, this.applicationTable, columnQualifierBytes, (Long)null, (Object)Separator.EMPTY_BYTES, new Attribute[0]);
                        continue;
                    }
                    EntityColumnPrefix.EVENT.store(rowKey, this.entityTable, columnQualifierBytes, (Long)null, (Object)Separator.EMPTY_BYTES, new Attribute[0]);
                    continue;
                }
                for (Map.Entry info : eventInfo.entrySet()) {
                    byte[] columnQualifierBytes = new EventColumnName(eventId, eventTimestamp, (String)info.getKey()).getColumnQualifier();
                    if (isApplication) {
                        ApplicationColumnPrefix.EVENT.store(rowKey, this.applicationTable, columnQualifierBytes, (Long)null, info.getValue(), new Attribute[0]);
                        continue;
                    }
                    EntityColumnPrefix.EVENT.store(rowKey, this.entityTable, columnQualifierBytes, (Long)null, info.getValue(), new Attribute[0]);
                }
            }
        }
    }

    static boolean isApplicationEntity(TimelineEntity te) {
        return te.getType().equals(TimelineEntityType.YARN_APPLICATION.toString());
    }

    private static TimelineEvent getApplicationEvent(TimelineEntity te, String eventId) {
        if (HBaseTimelineWriterImpl.isApplicationEntity(te)) {
            for (TimelineEvent event : te.getEvents()) {
                if (!event.getId().equals(eventId)) continue;
                return event;
            }
        }
        return null;
    }

    public TimelineWriteResponse aggregate(TimelineEntity data, TimelineAggregationTrack track) throws IOException {
        return null;
    }

    public void flush() throws IOException {
        this.entityTable.flush();
        this.appToFlowTable.flush();
        this.applicationTable.flush();
        this.flowRunTable.flush();
        this.flowActivityTable.flush();
    }

    protected void serviceStop() throws Exception {
        if (this.entityTable != null) {
            LOG.info((Object)"closing the entity table");
            this.entityTable.close();
        }
        if (this.appToFlowTable != null) {
            LOG.info((Object)"closing the app_flow table");
            this.appToFlowTable.close();
        }
        if (this.applicationTable != null) {
            LOG.info((Object)"closing the application table");
            this.applicationTable.close();
        }
        if (this.flowRunTable != null) {
            LOG.info((Object)"closing the flow run table");
            this.flowRunTable.close();
        }
        if (this.flowActivityTable != null) {
            LOG.info((Object)"closing the flowActivityTable table");
            this.flowActivityTable.close();
        }
        if (this.conn != null) {
            LOG.info((Object)"closing the hbase Connection");
            this.conn.close();
        }
        super.serviceStop();
    }
}

