/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.yarn.server.timelineservice.storage.application.ApplicationTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.apptoflow.AppToFlowTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowActivityTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunTable;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class TimelineSchemaCreator {
    static final String NAME = TimelineSchemaCreator.class.getSimpleName();
    private static final Log LOG = LogFactory.getLog(TimelineSchemaCreator.class);
    private static final String SKIP_EXISTING_TABLE_OPTION_SHORT = "s";
    private static final String APP_TABLE_NAME_SHORT = "a";
    private static final String APP_TO_FLOW_TABLE_NAME_SHORT = "a2f";
    private static final String TTL_OPTION_SHORT = "m";
    private static final String ENTITY_TABLE_NAME_SHORT = "e";

    private TimelineSchemaCreator() {
    }

    public static void main(String[] args) throws Exception {
        String applicationTableName;
        String appToflowTableName;
        String entityTableTTLMetrics;
        Configuration hbaseConf = HBaseConfiguration.create();
        String[] otherArgs = new GenericOptionsParser(hbaseConf, args).getRemainingArgs();
        CommandLine commandLine = TimelineSchemaCreator.parseArgs(otherArgs);
        String entityTableName = commandLine.getOptionValue(ENTITY_TABLE_NAME_SHORT);
        if (StringUtils.isNotBlank((String)entityTableName)) {
            hbaseConf.set("yarn.timeline-service.entity.table.name", entityTableName);
        }
        if (StringUtils.isNotBlank((String)(entityTableTTLMetrics = commandLine.getOptionValue(TTL_OPTION_SHORT)))) {
            int metricsTTL = Integer.parseInt(entityTableTTLMetrics);
            new EntityTable().setMetricsTTL(metricsTTL, hbaseConf);
        }
        if (StringUtils.isNotBlank((String)(appToflowTableName = commandLine.getOptionValue(APP_TO_FLOW_TABLE_NAME_SHORT)))) {
            hbaseConf.set("yarn.timeline-service.app-flow.table.name", appToflowTableName);
        }
        if (StringUtils.isNotBlank((String)(applicationTableName = commandLine.getOptionValue(APP_TABLE_NAME_SHORT)))) {
            hbaseConf.set("yarn.timeline-service..application.table.name", applicationTableName);
        }
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        try {
            boolean skipExisting = commandLine.hasOption(SKIP_EXISTING_TABLE_OPTION_SHORT);
            if (skipExisting) {
                LOG.info((Object)"Will skip existing tables and continue on htable creation exceptions!");
            }
            TimelineSchemaCreator.createAllTables(hbaseConf, skipExisting);
            LOG.info((Object)"Successfully created HBase schema. ");
        }
        catch (IOException e) {
            LOG.error((Object)("Error in creating hbase tables: " + e.getMessage()));
            exceptions.add(e);
        }
        if (exceptions.size() > 0) {
            LOG.warn((Object)"Schema creation finished with the following exceptions");
            for (Exception exception : exceptions) {
                LOG.warn((Object)exception.getMessage());
            }
            System.exit(-1);
        } else {
            LOG.info((Object)"Schema creation finished successfully");
        }
    }

    private static CommandLine parseArgs(String[] args) throws ParseException {
        Options options = new Options();
        Option o = new Option(ENTITY_TABLE_NAME_SHORT, "entityTableName", true, "entity table name");
        o.setArgName("entityTableName");
        o.setRequired(false);
        options.addOption(o);
        o = new Option(TTL_OPTION_SHORT, "metricsTTL", true, "TTL for metrics column family");
        o.setArgName("metricsTTL");
        o.setRequired(false);
        options.addOption(o);
        o = new Option(APP_TO_FLOW_TABLE_NAME_SHORT, "appToflowTableName", true, "app to flow table name");
        o.setArgName("appToflowTableName");
        o.setRequired(false);
        options.addOption(o);
        o = new Option(APP_TABLE_NAME_SHORT, "applicationTableName", true, "application table name");
        o.setArgName("applicationTableName");
        o.setRequired(false);
        options.addOption(o);
        o = new Option(SKIP_EXISTING_TABLE_OPTION_SHORT, "skipExistingTable", false, "skip existing Hbase tables and continue to create new tables");
        o.setRequired(false);
        options.addOption(o);
        PosixParser parser = new PosixParser();
        CommandLine commandLine = null;
        try {
            commandLine = parser.parse(options, args);
        }
        catch (Exception e) {
            LOG.error((Object)("ERROR: " + e.getMessage() + "\n"));
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(NAME + " ", options, true);
            System.exit(-1);
        }
        return commandLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void createAllTables(Configuration hbaseConf, boolean skipExisting) throws IOException {
        block20: {
            try (Connection conn = null;){
                conn = ConnectionFactory.createConnection((Configuration)hbaseConf);
                Admin admin = conn.getAdmin();
                if (admin == null) {
                    throw new IOException("Cannot create table since admin is null");
                }
                try {
                    new EntityTable().createTable(admin, hbaseConf);
                }
                catch (IOException e) {
                    if (skipExisting) {
                        LOG.warn((Object)("Skip and continue on: " + e.getMessage()));
                    }
                    throw e;
                }
                try {
                    new AppToFlowTable().createTable(admin, hbaseConf);
                }
                catch (IOException e) {
                    if (skipExisting) {
                        LOG.warn((Object)("Skip and continue on: " + e.getMessage()));
                    }
                    throw e;
                }
                try {
                    new ApplicationTable().createTable(admin, hbaseConf);
                }
                catch (IOException e) {
                    if (skipExisting) {
                        LOG.warn((Object)("Skip and continue on: " + e.getMessage()));
                    }
                    throw e;
                }
                try {
                    new FlowRunTable().createTable(admin, hbaseConf);
                }
                catch (IOException e) {
                    if (skipExisting) {
                        LOG.warn((Object)("Skip and continue on: " + e.getMessage()));
                    }
                    throw e;
                }
                try {
                    new FlowActivityTable().createTable(admin, hbaseConf);
                }
                catch (IOException e) {
                    if (skipExisting) {
                        LOG.warn((Object)("Skip and continue on: " + e.getMessage()));
                        break block20;
                    }
                    throw e;
                }
            }
        }
    }
}

