/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.application;

import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.AppIdKeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.KeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.LongConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;

public class ApplicationRowKey {
    private final String clusterId;
    private final String userId;
    private final String flowName;
    private final Long flowRunId;
    private final String appId;
    private final KeyConverter<ApplicationRowKey> appRowKeyConverter = new ApplicationRowKeyConverter();

    public ApplicationRowKey(String clusterId, String userId, String flowName, Long flowRunId, String appId) {
        this.clusterId = clusterId;
        this.userId = userId;
        this.flowName = flowName;
        this.flowRunId = flowRunId;
        this.appId = appId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public Long getFlowRunId() {
        return this.flowRunId;
    }

    public String getAppId() {
        return this.appId;
    }

    public byte[] getRowKey() {
        return this.appRowKeyConverter.encode(this);
    }

    public static ApplicationRowKey parseRowKey(byte[] rowKey) {
        return new ApplicationRowKeyConverter().decode(rowKey);
    }

    private static final class ApplicationRowKeyConverter
    implements KeyConverter<ApplicationRowKey> {
        private final KeyConverter<String> appIDKeyConverter = new AppIdKeyConverter();
        private static final int[] SEGMENT_SIZES = new int[]{0, 0, 0, 8, AppIdKeyConverter.getKeySize()};

        private ApplicationRowKeyConverter() {
        }

        @Override
        public byte[] encode(ApplicationRowKey rowKey) {
            byte[] cluster = Separator.encode(rowKey.getClusterId(), Separator.SPACE, Separator.TAB, Separator.QUALIFIERS);
            byte[] user = Separator.encode(rowKey.getUserId(), Separator.SPACE, Separator.TAB, Separator.QUALIFIERS);
            byte[] flow = Separator.encode(rowKey.getFlowName(), Separator.SPACE, Separator.TAB, Separator.QUALIFIERS);
            byte[] first = Separator.QUALIFIERS.join(cluster, user, flow);
            if (rowKey.getFlowRunId() == null) {
                return Separator.QUALIFIERS.join(first, Separator.EMPTY_BYTES);
            }
            byte[] second = Bytes.toBytes((long)LongConverter.invertLong(rowKey.getFlowRunId()));
            if (rowKey.getAppId() == null || rowKey.getAppId().isEmpty()) {
                return Separator.QUALIFIERS.join(first, second, Separator.EMPTY_BYTES);
            }
            byte[] third = this.appIDKeyConverter.encode(rowKey.getAppId());
            return Separator.QUALIFIERS.join(first, second, third);
        }

        @Override
        public ApplicationRowKey decode(byte[] rowKey) {
            byte[][] rowKeyComponents = Separator.QUALIFIERS.split(rowKey, SEGMENT_SIZES);
            if (rowKeyComponents.length != 5) {
                throw new IllegalArgumentException("the row key is not valid for an application");
            }
            String clusterId = Separator.decode(Bytes.toString((byte[])rowKeyComponents[0]), Separator.QUALIFIERS, Separator.TAB, Separator.SPACE);
            String userId = Separator.decode(Bytes.toString((byte[])rowKeyComponents[1]), Separator.QUALIFIERS, Separator.TAB, Separator.SPACE);
            String flowName = Separator.decode(Bytes.toString((byte[])rowKeyComponents[2]), Separator.QUALIFIERS, Separator.TAB, Separator.SPACE);
            Long flowRunId = LongConverter.invertLong(Bytes.toLong((byte[])rowKeyComponents[3]));
            String appId = this.appIDKeyConverter.decode(rowKeyComponents[4]);
            return new ApplicationRowKey(clusterId, userId, flowName, flowRunId, appId);
        }
    }
}

