/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.flow;

import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.HBaseTimelineStorageUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.KeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.LongConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;

public class FlowActivityRowKey {
    private final String clusterId;
    private final Long dayTs;
    private final String userId;
    private final String flowName;
    private final KeyConverter<FlowActivityRowKey> flowActivityRowKeyConverter = new FlowActivityRowKeyConverter();

    public FlowActivityRowKey(String clusterId, Long dayTs, String userId, String flowName) {
        this(clusterId, dayTs, userId, flowName, true);
    }

    protected FlowActivityRowKey(String clusterId, Long timestamp, String userId, String flowName, boolean convertDayTsToTopOfDay) {
        this.clusterId = clusterId;
        this.dayTs = convertDayTsToTopOfDay && timestamp != null ? Long.valueOf(HBaseTimelineStorageUtils.getTopOfTheDayTimestamp(timestamp)) : timestamp;
        this.userId = userId;
        this.flowName = flowName;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public Long getDayTimestamp() {
        return this.dayTs;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public byte[] getRowKey() {
        return this.flowActivityRowKeyConverter.encode(this);
    }

    public static FlowActivityRowKey parseRowKey(byte[] rowKey) {
        return new FlowActivityRowKeyConverter().decode(rowKey);
    }

    private static final class FlowActivityRowKeyConverter
    implements KeyConverter<FlowActivityRowKey> {
        private static final int[] SEGMENT_SIZES = new int[]{0, 8, 0, 0};

        private FlowActivityRowKeyConverter() {
        }

        @Override
        public byte[] encode(FlowActivityRowKey rowKey) {
            if (rowKey.getDayTimestamp() == null) {
                return Separator.QUALIFIERS.join(Separator.encode(rowKey.getClusterId(), Separator.SPACE, Separator.TAB, Separator.QUALIFIERS), Separator.EMPTY_BYTES);
            }
            if (rowKey.getUserId() == null) {
                return Separator.QUALIFIERS.join(Separator.encode(rowKey.getClusterId(), Separator.SPACE, Separator.TAB, Separator.QUALIFIERS), Bytes.toBytes((long)LongConverter.invertLong(rowKey.getDayTimestamp())), Separator.EMPTY_BYTES);
            }
            return Separator.QUALIFIERS.join(Separator.encode(rowKey.getClusterId(), Separator.SPACE, Separator.TAB, Separator.QUALIFIERS), Bytes.toBytes((long)LongConverter.invertLong(rowKey.getDayTimestamp())), Separator.encode(rowKey.getUserId(), Separator.SPACE, Separator.TAB, Separator.QUALIFIERS), Separator.encode(rowKey.getFlowName(), Separator.SPACE, Separator.TAB, Separator.QUALIFIERS));
        }

        @Override
        public FlowActivityRowKey decode(byte[] rowKey) {
            byte[][] rowKeyComponents = Separator.QUALIFIERS.split(rowKey, SEGMENT_SIZES);
            if (rowKeyComponents.length != 4) {
                throw new IllegalArgumentException("the row key is not valid for a flow activity");
            }
            String clusterId = Separator.decode(Bytes.toString((byte[])rowKeyComponents[0]), Separator.QUALIFIERS, Separator.TAB, Separator.SPACE);
            Long dayTs = LongConverter.invertLong(Bytes.toLong((byte[])rowKeyComponents[1]));
            String userId = Separator.decode(Bytes.toString((byte[])rowKeyComponents[2]), Separator.QUALIFIERS, Separator.TAB, Separator.SPACE);
            String flowName = Separator.decode(Bytes.toString((byte[])rowKeyComponents[3]), Separator.QUALIFIERS, Separator.TAB, Separator.SPACE);
            return new FlowActivityRowKey(clusterId, dayTs, userId, flowName);
        }
    }
}

