/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.flow;

import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.KeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.LongConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;

public class FlowRunRowKey {
    private final String clusterId;
    private final String userId;
    private final String flowName;
    private final Long flowRunId;
    private final FlowRunRowKeyConverter flowRunRowKeyConverter = new FlowRunRowKeyConverter();

    public FlowRunRowKey(String clusterId, String userId, String flowName, Long flowRunId) {
        this.clusterId = clusterId;
        this.userId = userId;
        this.flowName = flowName;
        this.flowRunId = flowRunId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public Long getFlowRunId() {
        return this.flowRunId;
    }

    public byte[] getRowKey() {
        return this.flowRunRowKeyConverter.encode(this);
    }

    public static FlowRunRowKey parseRowKey(byte[] rowKey) {
        return new FlowRunRowKeyConverter().decode(rowKey);
    }

    public String toString() {
        StringBuilder flowKeyStr = new StringBuilder();
        flowKeyStr.append("{clusterId=" + this.clusterId);
        flowKeyStr.append(" userId=" + this.userId);
        flowKeyStr.append(" flowName=" + this.flowName);
        flowKeyStr.append(" flowRunId=");
        flowKeyStr.append(this.flowRunId);
        flowKeyStr.append("}");
        return flowKeyStr.toString();
    }

    private static final class FlowRunRowKeyConverter
    implements KeyConverter<FlowRunRowKey> {
        private static final int[] SEGMENT_SIZES = new int[]{0, 0, 0, 8};

        private FlowRunRowKeyConverter() {
        }

        @Override
        public byte[] encode(FlowRunRowKey rowKey) {
            byte[] first = Separator.QUALIFIERS.join(Separator.encode(rowKey.getClusterId(), Separator.SPACE, Separator.TAB, Separator.QUALIFIERS), Separator.encode(rowKey.getUserId(), Separator.SPACE, Separator.TAB, Separator.QUALIFIERS), Separator.encode(rowKey.getFlowName(), Separator.SPACE, Separator.TAB, Separator.QUALIFIERS));
            if (rowKey.getFlowRunId() == null) {
                return Separator.QUALIFIERS.join(first, Separator.EMPTY_BYTES);
            }
            byte[] second = Bytes.toBytes((long)LongConverter.invertLong(rowKey.getFlowRunId()));
            return Separator.QUALIFIERS.join(first, second);
        }

        @Override
        public FlowRunRowKey decode(byte[] rowKey) {
            byte[][] rowKeyComponents = Separator.QUALIFIERS.split(rowKey, SEGMENT_SIZES);
            if (rowKeyComponents.length != 4) {
                throw new IllegalArgumentException("the row key is not valid for a flow run");
            }
            String clusterId = Separator.decode(Bytes.toString((byte[])rowKeyComponents[0]), Separator.QUALIFIERS, Separator.TAB, Separator.SPACE);
            String userId = Separator.decode(Bytes.toString((byte[])rowKeyComponents[1]), Separator.QUALIFIERS, Separator.TAB, Separator.SPACE);
            String flowName = Separator.decode(Bytes.toString((byte[])rowKeyComponents[2]), Separator.QUALIFIERS, Separator.TAB, Separator.SPACE);
            Long flowRunId = LongConverter.invertLong(Bytes.toLong((byte[])rowKeyComponents[3]));
            return new FlowRunRowKey(clusterId, userId, flowName, flowRunId);
        }
    }
}

