/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.flow;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.BaseTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunCoprocessor;

public class FlowRunTable
extends BaseTable<FlowRunTable> {
    private static final String PREFIX = "yarn.timeline-service..flowrun";
    public static final String TABLE_NAME_CONF_NAME = "yarn.timeline-service..flowrun.table.name";
    public static final String DEFAULT_TABLE_NAME = "timelineservice.flowrun";
    private static final Log LOG = LogFactory.getLog(FlowRunTable.class);
    public static final int DEFAULT_METRICS_MAX_VERSIONS = Integer.MAX_VALUE;

    public FlowRunTable() {
        super(TABLE_NAME_CONF_NAME, DEFAULT_TABLE_NAME);
    }

    @Override
    public void createTable(Admin admin, Configuration hbaseConf) throws IOException {
        TableName table = this.getTableName(hbaseConf);
        if (admin.tableExists(table)) {
            throw new IOException("Table " + table.getNameAsString() + " already exists.");
        }
        HTableDescriptor flowRunTableDescp = new HTableDescriptor(table);
        HColumnDescriptor infoCF = new HColumnDescriptor(FlowRunColumnFamily.INFO.getBytes());
        infoCF.setBloomFilterType(BloomType.ROWCOL);
        flowRunTableDescp.addFamily(infoCF);
        infoCF.setMinVersions(1);
        infoCF.setMaxVersions(Integer.MAX_VALUE);
        flowRunTableDescp.addCoprocessor(FlowRunCoprocessor.class.getCanonicalName());
        admin.createTable(flowRunTableDescp);
        LOG.info((Object)("Status of table creation for " + table.getNameAsString() + "=" + admin.tableExists(table)));
    }
}

