/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.application;

import java.io.IOException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.server.timelineservice.storage.application.ApplicationColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.application.ApplicationTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Column;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnHelper;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.GenericConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.LongConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.TypedBufferedMutator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ValueConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.Attribute;

public enum ApplicationColumn implements Column<ApplicationTable>
{
    ID(ApplicationColumnFamily.INFO, "id"),
    CREATED_TIME(ApplicationColumnFamily.INFO, "created_time", new LongConverter()),
    FLOW_VERSION(ApplicationColumnFamily.INFO, "flow_version");

    private final ColumnHelper<ApplicationTable> column;
    private final ColumnFamily<ApplicationTable> columnFamily;
    private final String columnQualifier;
    private final byte[] columnQualifierBytes;

    private ApplicationColumn(ColumnFamily<ApplicationTable> columnFamily, String columnQualifier) {
        this(columnFamily, columnQualifier, GenericConverter.getInstance());
    }

    private ApplicationColumn(ColumnFamily<ApplicationTable> columnFamily, String columnQualifier, ValueConverter converter) {
        this.columnFamily = columnFamily;
        this.columnQualifier = columnQualifier;
        this.columnQualifierBytes = Bytes.toBytes((String)Separator.SPACE.encode(columnQualifier));
        this.column = new ColumnHelper<ApplicationTable>(columnFamily, converter);
    }

    private String getColumnQualifier() {
        return this.columnQualifier;
    }

    @Override
    public void store(byte[] rowKey, TypedBufferedMutator<ApplicationTable> tableMutator, Long timestamp, Object inputValue, Attribute ... attributes) throws IOException {
        this.column.store(rowKey, tableMutator, this.columnQualifierBytes, timestamp, inputValue, attributes);
    }

    @Override
    public Object readResult(Result result) throws IOException {
        return this.column.readResult(result, this.columnQualifierBytes);
    }

    @Override
    public byte[] getColumnQualifierBytes() {
        return (byte[])this.columnQualifierBytes.clone();
    }

    @Override
    public byte[] getColumnFamilyBytes() {
        return this.columnFamily.getBytes();
    }

    @Override
    public ValueConverter getValueConverter() {
        return this.column.getValueConverter();
    }

    public static final ApplicationColumn columnFor(String columnQualifier) {
        for (ApplicationColumn ac : ApplicationColumn.values()) {
            if (!ac.getColumnQualifier().equals(columnQualifier)) continue;
            return ac;
        }
        return null;
    }

    public static final ApplicationColumn columnFor(ApplicationColumnFamily columnFamily, String name) {
        for (ApplicationColumn ac : ApplicationColumn.values()) {
            if (!ac.columnFamily.equals(columnFamily) || !ac.getColumnQualifier().equals(name)) continue;
            return ac;
        }
        return null;
    }
}

