/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.apptoflow;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.yarn.server.timelineservice.storage.apptoflow.AppToFlowColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.BaseTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.TimelineHBaseSchemaConstants;

public class AppToFlowTable
extends BaseTable<AppToFlowTable> {
    private static final String PREFIX = "yarn.timeline-service.app-flow";
    public static final String TABLE_NAME_CONF_NAME = "yarn.timeline-service.app-flow.table.name";
    private static final String DEFAULT_TABLE_NAME = "timelineservice.app_flow";
    private static final Log LOG = LogFactory.getLog(AppToFlowTable.class);

    public AppToFlowTable() {
        super(TABLE_NAME_CONF_NAME, DEFAULT_TABLE_NAME);
    }

    @Override
    public void createTable(Admin admin, Configuration hbaseConf) throws IOException {
        TableName table = this.getTableName(hbaseConf);
        if (admin.tableExists(table)) {
            throw new IOException("Table " + table.getNameAsString() + " already exists.");
        }
        HTableDescriptor appToFlowTableDescp = new HTableDescriptor(table);
        HColumnDescriptor mappCF = new HColumnDescriptor(AppToFlowColumnFamily.MAPPING.getBytes());
        mappCF.setBloomFilterType(BloomType.ROWCOL);
        appToFlowTableDescp.addFamily(mappCF);
        appToFlowTableDescp.setRegionSplitPolicyClassName("org.apache.hadoop.hbase.regionserver.KeyPrefixRegionSplitPolicy");
        appToFlowTableDescp.setValue("KeyPrefixRegionSplitPolicy.prefix_length", "4");
        admin.createTable(appToFlowTableDescp, TimelineHBaseSchemaConstants.getUsernameSplits());
        LOG.info((Object)("Status of table creation for " + table.getNameAsString() + "=" + admin.tableExists(table)));
    }
}

