/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.common;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.BufferedMutatorDelegator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.TypedBufferedMutator;

public abstract class BaseTable<T> {
    private final String tableNameConfName;
    private final String defaultTableName;

    protected BaseTable(String tableNameConfName, String defaultTableName) {
        this.tableNameConfName = tableNameConfName;
        this.defaultTableName = defaultTableName;
    }

    public TypedBufferedMutator<T> getTableMutator(Configuration hbaseConf, Connection conn) throws IOException {
        TableName tableName = this.getTableName(hbaseConf);
        BufferedMutator bufferedMutator = conn.getBufferedMutator(tableName);
        BufferedMutatorDelegator table = new BufferedMutatorDelegator(bufferedMutator);
        return table;
    }

    public ResultScanner getResultScanner(Configuration hbaseConf, Connection conn, Scan scan) throws IOException {
        Table table = conn.getTable(this.getTableName(hbaseConf));
        return table.getScanner(scan);
    }

    public Result getResult(Configuration hbaseConf, Connection conn, Get get) throws IOException {
        Table table = conn.getTable(this.getTableName(hbaseConf));
        return table.get(get);
    }

    public TableName getTableName(Configuration hbaseConf) {
        TableName table = TableName.valueOf((String)hbaseConf.get(this.tableNameConfName, this.defaultTableName));
        return table;
    }

    public abstract void createTable(Admin var1, Configuration var2) throws IOException;
}

