/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.common;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.AggregationCompactionDimension;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.AggregationOperation;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.Attribute;

public final class HBaseTimelineStorageUtils {
    public static final long MILLIS_ONE_DAY = 86400000L;
    private static final Log LOG = LogFactory.getLog(HBaseTimelineStorageUtils.class);

    private HBaseTimelineStorageUtils() {
    }

    public static Attribute[] combineAttributes(Attribute[] attributes, AggregationOperation aggOp) {
        int newLength = HBaseTimelineStorageUtils.getNewLengthCombinedAttributes(attributes, aggOp);
        Attribute[] combinedAttributes = new Attribute[newLength];
        if (attributes != null) {
            System.arraycopy(attributes, 0, combinedAttributes, 0, attributes.length);
        }
        if (aggOp != null) {
            Attribute a2;
            combinedAttributes[newLength - 1] = a2 = aggOp.getAttribute();
        }
        return combinedAttributes;
    }

    private static int getNewLengthCombinedAttributes(Attribute[] attributes, AggregationOperation aggOp) {
        int oldLength = HBaseTimelineStorageUtils.getAttributesLength(attributes);
        int aggLength = HBaseTimelineStorageUtils.getAppOpLength(aggOp);
        return oldLength + aggLength;
    }

    private static int getAppOpLength(AggregationOperation aggOp) {
        if (aggOp != null) {
            return 1;
        }
        return 0;
    }

    private static int getAttributesLength(Attribute[] attributes) {
        if (attributes != null) {
            return attributes.length;
        }
        return 0;
    }

    public static AggregationOperation getAggregationOperationFromTagsList(List<Tag> tags) {
        for (AggregationOperation aggOp : AggregationOperation.values()) {
            for (Tag tag : tags) {
                if (tag.getType() != aggOp.getTagType()) continue;
                return aggOp;
            }
        }
        return null;
    }

    public static Tag getTagFromAttribute(Map.Entry<String, byte[]> attribute) {
        AggregationOperation aggOp = AggregationOperation.getAggregationOperation(attribute.getKey());
        if (aggOp != null) {
            Tag t = new Tag(aggOp.getTagType(), attribute.getValue());
            return t;
        }
        AggregationCompactionDimension aggCompactDim = AggregationCompactionDimension.getAggregationCompactionDimension(attribute.getKey());
        if (aggCompactDim != null) {
            Tag t = new Tag(aggCompactDim.getTagType(), attribute.getValue());
            return t;
        }
        return null;
    }

    public static Cell createNewCell(Cell origCell, byte[] newValue) throws IOException {
        return CellUtil.createCell((byte[])CellUtil.cloneRow((Cell)origCell), (byte[])CellUtil.cloneFamily((Cell)origCell), (byte[])CellUtil.cloneQualifier((Cell)origCell), (long)origCell.getTimestamp(), (byte)KeyValue.Type.Put.getCode(), (byte[])newValue);
    }

    public static Cell createNewCell(byte[] row, byte[] family, byte[] qualifier, long ts, byte[] newValue, byte[] tags) throws IOException {
        return CellUtil.createCell((byte[])row, (byte[])family, (byte[])qualifier, (long)ts, (KeyValue.Type)KeyValue.Type.Put, (byte[])newValue, (byte[])tags);
    }

    public static String getAggregationCompactionDimension(List<Tag> tags) {
        String appId = null;
        for (Tag t : tags) {
            if (AggregationCompactionDimension.APPLICATION_ID.getTagType() != t.getType()) continue;
            appId = Bytes.toString((byte[])t.getValue());
            return appId;
        }
        return appId;
    }

    public static boolean isFlowRunTable(HRegionInfo hRegionInfo, Configuration conf) {
        String regionTableName = hRegionInfo.getTable().getNameAsString();
        String flowRunTableName = conf.get("yarn.timeline-service..flowrun.table.name", "timelineservice.flowrun");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("regionTableName=" + regionTableName));
        }
        if (flowRunTableName.equalsIgnoreCase(regionTableName)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("table is the flow run table!! " + flowRunTableName));
            }
            return true;
        }
        return false;
    }

    public static int invertInt(int key) {
        return Integer.MAX_VALUE - key;
    }

    public static long getTopOfTheDayTimestamp(long ts) {
        long dayTimestamp = ts - ts % 86400000L;
        return dayTimestamp;
    }
}

