/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.reader;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.BinaryPrefixComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.FamilyFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.yarn.api.records.timelineservice.FlowRunEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineDataToRetrieve;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineEntityFilters;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderContext;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilterList;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilterUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineReader;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.BaseTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunColumn;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunRowKeyPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.reader.TimelineEntityReader;
import org.apache.hadoop.yarn.webapp.BadRequestException;

class FlowRunEntityReader
extends TimelineEntityReader {
    private static final FlowRunTable FLOW_RUN_TABLE = new FlowRunTable();

    public FlowRunEntityReader(TimelineReaderContext ctxt, TimelineEntityFilters entityFilters, TimelineDataToRetrieve toRetrieve) {
        super(ctxt, entityFilters, toRetrieve, true);
    }

    public FlowRunEntityReader(TimelineReaderContext ctxt, TimelineDataToRetrieve toRetrieve) {
        super(ctxt, toRetrieve);
    }

    @Override
    protected BaseTable<?> getTable() {
        return FLOW_RUN_TABLE;
    }

    @Override
    protected void validateParams() {
        Preconditions.checkNotNull((Object)this.getContext(), (Object)"context shouldn't be null");
        Preconditions.checkNotNull((Object)this.getDataToRetrieve(), (Object)"data to retrieve shouldn't be null");
        Preconditions.checkNotNull((Object)this.getContext().getClusterId(), (Object)"clusterId shouldn't be null");
        Preconditions.checkNotNull((Object)this.getContext().getUserId(), (Object)"userId shouldn't be null");
        Preconditions.checkNotNull((Object)this.getContext().getFlowName(), (Object)"flowName shouldn't be null");
        if (this.isSingleEntityRead()) {
            Preconditions.checkNotNull((Object)this.getContext().getFlowRunId(), (Object)"flowRunId shouldn't be null");
        }
        EnumSet fieldsToRetrieve = this.getDataToRetrieve().getFieldsToRetrieve();
        if (!this.isSingleEntityRead() && fieldsToRetrieve != null) {
            for (TimelineReader.Field field : fieldsToRetrieve) {
                if (field == TimelineReader.Field.ALL || field == TimelineReader.Field.METRICS) continue;
                throw new BadRequestException("Invalid field " + field + " specified while querying flow runs.");
            }
        }
    }

    @Override
    protected void augmentParams(Configuration hbaseConf, Connection conn) {
        this.getDataToRetrieve().addFieldsBasedOnConfsAndMetricsToRetrieve();
        if (!this.isSingleEntityRead()) {
            this.createFiltersIfNull();
        }
    }

    @Override
    protected FilterList constructFilterListBasedOnFilters() throws IOException {
        TimelineFilterList metricFilters;
        FilterList listBasedOnFilters = new FilterList(new Filter[0]);
        Long createdTimeBegin = this.getFilters().getCreatedTimeBegin();
        Long createdTimeEnd = this.getFilters().getCreatedTimeEnd();
        if (createdTimeBegin != 0L || createdTimeEnd != Long.MAX_VALUE) {
            listBasedOnFilters.addFilter((Filter)TimelineFilterUtils.createSingleColValueFiltersByRange(FlowRunColumn.MIN_START_TIME, createdTimeBegin, createdTimeEnd));
        }
        if ((metricFilters = this.getFilters().getMetricFilters()) != null && !metricFilters.getFilterList().isEmpty()) {
            listBasedOnFilters.addFilter((Filter)TimelineFilterUtils.createHBaseFilterList(FlowRunColumnPrefix.METRIC, metricFilters));
        }
        return listBasedOnFilters;
    }

    private FilterList updateFixedColumns() {
        FilterList columnsList = new FilterList(FilterList.Operator.MUST_PASS_ONE);
        for (FlowRunColumn column : FlowRunColumn.values()) {
            columnsList.addFilter((Filter)new QualifierFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(column.getColumnQualifierBytes())));
        }
        return columnsList;
    }

    @Override
    protected FilterList constructFilterListBasedOnFields() throws IOException {
        FilterList list = new FilterList(FilterList.Operator.MUST_PASS_ONE);
        FamilyFilter infoColumnFamily = new FamilyFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(FlowRunColumnFamily.INFO.getBytes()));
        TimelineDataToRetrieve dataToRetrieve = this.getDataToRetrieve();
        if (!this.isSingleEntityRead() && !this.hasField(dataToRetrieve.getFieldsToRetrieve(), TimelineReader.Field.METRICS)) {
            FilterList infoColFamilyList = new FilterList(FilterList.Operator.MUST_PASS_ONE);
            infoColFamilyList.addFilter((Filter)infoColumnFamily);
            infoColFamilyList.addFilter((Filter)new QualifierFilter(CompareFilter.CompareOp.NOT_EQUAL, (ByteArrayComparable)new BinaryPrefixComparator(FlowRunColumnPrefix.METRIC.getColumnPrefixBytes(""))));
            list.addFilter((Filter)infoColFamilyList);
        } else {
            TimelineFilterList metricsToRetrieve = dataToRetrieve.getMetricsToRetrieve();
            if (metricsToRetrieve != null && !metricsToRetrieve.getFilterList().isEmpty()) {
                FilterList infoColFamilyList = new FilterList(new Filter[0]);
                infoColFamilyList.addFilter((Filter)infoColumnFamily);
                FilterList columnsList = this.updateFixedColumns();
                columnsList.addFilter((Filter)TimelineFilterUtils.createHBaseFilterList(FlowRunColumnPrefix.METRIC, metricsToRetrieve));
                infoColFamilyList.addFilter((Filter)columnsList);
                list.addFilter((Filter)infoColFamilyList);
            }
        }
        return list;
    }

    @Override
    protected Result getResult(Configuration hbaseConf, Connection conn, FilterList filterList) throws IOException {
        TimelineReaderContext context = this.getContext();
        FlowRunRowKey flowRunRowKey = new FlowRunRowKey(context.getClusterId(), context.getUserId(), context.getFlowName(), context.getFlowRunId());
        byte[] rowKey = flowRunRowKey.getRowKey();
        Get get = new Get(rowKey);
        get.setMaxVersions(Integer.MAX_VALUE);
        if (filterList != null && !filterList.getFilters().isEmpty()) {
            get.setFilter((Filter)filterList);
        }
        return this.getTable().getResult(hbaseConf, conn, get);
    }

    @Override
    protected ResultScanner getResults(Configuration hbaseConf, Connection conn, FilterList filterList) throws IOException {
        Scan scan = new Scan();
        TimelineReaderContext context = this.getContext();
        FlowRunRowKeyPrefix flowRunRowKeyPrefix = new FlowRunRowKeyPrefix(context.getClusterId(), context.getUserId(), context.getFlowName());
        scan.setRowPrefixFilter(flowRunRowKeyPrefix.getRowKeyPrefix());
        FilterList newList = new FilterList(new Filter[0]);
        newList.addFilter((Filter)new PageFilter(this.getFilters().getLimit()));
        if (filterList != null && !filterList.getFilters().isEmpty()) {
            newList.addFilter((Filter)filterList);
        }
        scan.setFilter((Filter)newList);
        scan.setMaxVersions(Integer.MAX_VALUE);
        return this.getTable().getResultScanner(hbaseConf, conn, scan);
    }

    @Override
    protected TimelineEntity parseEntity(Result result) throws IOException {
        String version;
        Long endTime;
        TimelineReaderContext context = this.getContext();
        FlowRunEntity flowRun = new FlowRunEntity();
        flowRun.setUser(context.getUserId());
        flowRun.setName(context.getFlowName());
        if (this.isSingleEntityRead()) {
            flowRun.setRunId(context.getFlowRunId().longValue());
        } else {
            FlowRunRowKey rowKey = FlowRunRowKey.parseRowKey(result.getRow());
            flowRun.setRunId(rowKey.getFlowRunId().longValue());
        }
        Long startTime = (Long)FlowRunColumn.MIN_START_TIME.readResult(result);
        if (startTime != null) {
            flowRun.setStartTime(startTime.longValue());
        }
        if ((endTime = (Long)FlowRunColumn.MAX_END_TIME.readResult(result)) != null) {
            flowRun.setMaxEndTime(endTime.longValue());
        }
        if ((version = (String)FlowRunColumn.FLOW_VERSION.readResult(result)) != null) {
            flowRun.setVersion(version);
        }
        if (this.isSingleEntityRead() || this.hasField(this.getDataToRetrieve().getFieldsToRetrieve(), TimelineReader.Field.METRICS)) {
            this.readMetrics((TimelineEntity)flowRun, result, FlowRunColumnPrefix.METRIC);
        }
        flowRun.setId(flowRun.getId());
        return flowRun;
    }
}

