/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.reader;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.FamilyFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineDataToRetrieve;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineEntityFilters;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderContext;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilterList;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilterUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineReader;
import org.apache.hadoop.yarn.server.timelineservice.storage.apptoflow.AppToFlowColumn;
import org.apache.hadoop.yarn.server.timelineservice.storage.apptoflow.AppToFlowRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.apptoflow.AppToFlowTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.BaseTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.KeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.StringKeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.TimelineStorageUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityColumn;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityRowKeyPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.reader.TimelineEntityReader;
import org.apache.hadoop.yarn.webapp.NotFoundException;

class GenericEntityReader
extends TimelineEntityReader {
    private static final EntityTable ENTITY_TABLE = new EntityTable();
    private final AppToFlowTable appToFlowTable = new AppToFlowTable();
    private final KeyConverter<String> stringKeyConverter = new StringKeyConverter();

    public GenericEntityReader(TimelineReaderContext ctxt, TimelineEntityFilters entityFilters, TimelineDataToRetrieve toRetrieve, boolean sortedKeys) {
        super(ctxt, entityFilters, toRetrieve, sortedKeys);
    }

    public GenericEntityReader(TimelineReaderContext ctxt, TimelineDataToRetrieve toRetrieve) {
        super(ctxt, toRetrieve);
    }

    @Override
    protected BaseTable<?> getTable() {
        return ENTITY_TABLE;
    }

    @Override
    protected FilterList constructFilterListBasedOnFilters() throws IOException {
        TimelineFilterList infoFilters;
        TimelineFilterList configFilters;
        TimelineFilterList metricFilters;
        FilterList listBasedOnFilters = new FilterList(new Filter[0]);
        TimelineEntityFilters filters = this.getFilters();
        long createdTimeBegin = filters.getCreatedTimeBegin();
        long createdTimeEnd = filters.getCreatedTimeEnd();
        if (createdTimeBegin != 0L || createdTimeEnd != Long.MAX_VALUE) {
            listBasedOnFilters.addFilter((Filter)TimelineFilterUtils.createSingleColValueFiltersByRange(EntityColumn.CREATED_TIME, createdTimeBegin, createdTimeEnd));
        }
        if ((metricFilters = filters.getMetricFilters()) != null && !metricFilters.getFilterList().isEmpty()) {
            listBasedOnFilters.addFilter((Filter)TimelineFilterUtils.createHBaseFilterList(EntityColumnPrefix.METRIC, metricFilters));
        }
        if ((configFilters = filters.getConfigFilters()) != null && !configFilters.getFilterList().isEmpty()) {
            listBasedOnFilters.addFilter((Filter)TimelineFilterUtils.createHBaseFilterList(EntityColumnPrefix.CONFIG, configFilters));
        }
        if ((infoFilters = filters.getInfoFilters()) != null && !infoFilters.getFilterList().isEmpty()) {
            listBasedOnFilters.addFilter((Filter)TimelineFilterUtils.createHBaseFilterList(EntityColumnPrefix.INFO, infoFilters));
        }
        return listBasedOnFilters;
    }

    private boolean fetchPartialEventCols(TimelineFilterList eventFilters, EnumSet<TimelineReader.Field> fieldsToRetrieve) {
        return eventFilters != null && !eventFilters.getFilterList().isEmpty() && !this.hasField(fieldsToRetrieve, TimelineReader.Field.EVENTS);
    }

    private boolean fetchPartialRelatesToCols(TimelineFilterList relatesTo, EnumSet<TimelineReader.Field> fieldsToRetrieve) {
        return relatesTo != null && !relatesTo.getFilterList().isEmpty() && !this.hasField(fieldsToRetrieve, TimelineReader.Field.RELATES_TO);
    }

    private boolean fetchPartialIsRelatedToCols(TimelineFilterList isRelatedTo, EnumSet<TimelineReader.Field> fieldsToRetrieve) {
        return isRelatedTo != null && !isRelatedTo.getFilterList().isEmpty() && !this.hasField(fieldsToRetrieve, TimelineReader.Field.IS_RELATED_TO);
    }

    protected boolean fetchPartialColsFromInfoFamily() {
        EnumSet fieldsToRetrieve = this.getDataToRetrieve().getFieldsToRetrieve();
        TimelineEntityFilters filters = this.getFilters();
        return this.fetchPartialEventCols(filters.getEventFilters(), fieldsToRetrieve) || this.fetchPartialRelatesToCols(filters.getRelatesTo(), fieldsToRetrieve) || this.fetchPartialIsRelatedToCols(filters.getIsRelatedTo(), fieldsToRetrieve);
    }

    protected boolean needCreateFilterListBasedOnFields() {
        boolean flag;
        TimelineDataToRetrieve dataToRetrieve = this.getDataToRetrieve();
        boolean bl = flag = !dataToRetrieve.getFieldsToRetrieve().contains(TimelineReader.Field.ALL) || dataToRetrieve.getConfsToRetrieve() != null && !dataToRetrieve.getConfsToRetrieve().getFilterList().isEmpty() || dataToRetrieve.getMetricsToRetrieve() != null && !dataToRetrieve.getMetricsToRetrieve().getFilterList().isEmpty();
        if (!flag && !this.isSingleEntityRead()) {
            TimelineEntityFilters filters = this.getFilters();
            flag = filters.getEventFilters() != null && !filters.getEventFilters().getFilterList().isEmpty() || filters.getIsRelatedTo() != null && !filters.getIsRelatedTo().getFilterList().isEmpty() || filters.getRelatesTo() != null && !filters.getRelatesTo().getFilterList().isEmpty();
        }
        return flag;
    }

    protected void updateFixedColumns(FilterList list) {
        for (EntityColumn column : EntityColumn.values()) {
            list.addFilter((Filter)new QualifierFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(column.getColumnQualifierBytes())));
        }
    }

    private FilterList createFilterListForColsOfInfoFamily() throws IOException {
        FilterList infoFamilyColsFilter = new FilterList(FilterList.Operator.MUST_PASS_ONE);
        this.updateFixedColumns(infoFamilyColsFilter);
        EnumSet fieldsToRetrieve = this.getDataToRetrieve().getFieldsToRetrieve();
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.INFO)) {
            infoFamilyColsFilter.addFilter(TimelineFilterUtils.createHBaseQualifierFilter(CompareFilter.CompareOp.EQUAL, EntityColumnPrefix.INFO));
        }
        TimelineFilterList relatesTo = this.getFilters().getRelatesTo();
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.RELATES_TO)) {
            infoFamilyColsFilter.addFilter(TimelineFilterUtils.createHBaseQualifierFilter(CompareFilter.CompareOp.EQUAL, EntityColumnPrefix.RELATES_TO));
        } else if (relatesTo != null && !relatesTo.getFilterList().isEmpty()) {
            Set<String> relatesToCols = TimelineFilterUtils.fetchColumnsFromFilterList(relatesTo);
            infoFamilyColsFilter.addFilter((Filter)this.createFiltersFromColumnQualifiers(EntityColumnPrefix.RELATES_TO, relatesToCols));
        }
        TimelineFilterList isRelatedTo = this.getFilters().getIsRelatedTo();
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.IS_RELATED_TO)) {
            infoFamilyColsFilter.addFilter(TimelineFilterUtils.createHBaseQualifierFilter(CompareFilter.CompareOp.EQUAL, EntityColumnPrefix.IS_RELATED_TO));
        } else if (isRelatedTo != null && !isRelatedTo.getFilterList().isEmpty()) {
            Set<String> isRelatedToCols = TimelineFilterUtils.fetchColumnsFromFilterList(isRelatedTo);
            infoFamilyColsFilter.addFilter((Filter)this.createFiltersFromColumnQualifiers(EntityColumnPrefix.IS_RELATED_TO, isRelatedToCols));
        }
        TimelineFilterList eventFilters = this.getFilters().getEventFilters();
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.EVENTS)) {
            infoFamilyColsFilter.addFilter(TimelineFilterUtils.createHBaseQualifierFilter(CompareFilter.CompareOp.EQUAL, EntityColumnPrefix.EVENT));
        } else if (eventFilters != null && !eventFilters.getFilterList().isEmpty()) {
            Set<String> eventCols = TimelineFilterUtils.fetchColumnsFromFilterList(eventFilters);
            infoFamilyColsFilter.addFilter((Filter)this.createFiltersFromColumnQualifiers(EntityColumnPrefix.EVENT, eventCols));
        }
        return infoFamilyColsFilter;
    }

    private void excludeFieldsFromInfoColFamily(FilterList infoColFamilyList) {
        EnumSet fieldsToRetrieve = this.getDataToRetrieve().getFieldsToRetrieve();
        if (!this.hasField(fieldsToRetrieve, TimelineReader.Field.EVENTS)) {
            infoColFamilyList.addFilter(TimelineFilterUtils.createHBaseQualifierFilter(CompareFilter.CompareOp.NOT_EQUAL, EntityColumnPrefix.EVENT));
        }
        if (!this.hasField(fieldsToRetrieve, TimelineReader.Field.INFO)) {
            infoColFamilyList.addFilter(TimelineFilterUtils.createHBaseQualifierFilter(CompareFilter.CompareOp.NOT_EQUAL, EntityColumnPrefix.INFO));
        }
        if (!this.hasField(fieldsToRetrieve, TimelineReader.Field.IS_RELATED_TO)) {
            infoColFamilyList.addFilter(TimelineFilterUtils.createHBaseQualifierFilter(CompareFilter.CompareOp.NOT_EQUAL, EntityColumnPrefix.IS_RELATED_TO));
        }
        if (!this.hasField(fieldsToRetrieve, TimelineReader.Field.RELATES_TO)) {
            infoColFamilyList.addFilter(TimelineFilterUtils.createHBaseQualifierFilter(CompareFilter.CompareOp.NOT_EQUAL, EntityColumnPrefix.RELATES_TO));
        }
    }

    private void updateFilterForConfsAndMetricsToRetrieve(FilterList listBasedOnFields) throws IOException {
        TimelineDataToRetrieve dataToRetrieve = this.getDataToRetrieve();
        if (dataToRetrieve.getFieldsToRetrieve().contains(TimelineReader.Field.CONFIGS)) {
            listBasedOnFields.addFilter(TimelineFilterUtils.createFilterForConfsOrMetricsToRetrieve(dataToRetrieve.getConfsToRetrieve(), EntityColumnFamily.CONFIGS, EntityColumnPrefix.CONFIG));
        }
        if (dataToRetrieve.getFieldsToRetrieve().contains(TimelineReader.Field.METRICS)) {
            listBasedOnFields.addFilter(TimelineFilterUtils.createFilterForConfsOrMetricsToRetrieve(dataToRetrieve.getMetricsToRetrieve(), EntityColumnFamily.METRICS, EntityColumnPrefix.METRIC));
        }
    }

    @Override
    protected FilterList constructFilterListBasedOnFields() throws IOException {
        if (!this.needCreateFilterListBasedOnFields()) {
            return null;
        }
        FilterList listBasedOnFields = new FilterList(FilterList.Operator.MUST_PASS_ONE);
        FilterList infoColFamilyList = new FilterList(new Filter[0]);
        FamilyFilter infoColumnFamily = new FamilyFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(EntityColumnFamily.INFO.getBytes()));
        infoColFamilyList.addFilter((Filter)infoColumnFamily);
        if (!this.isSingleEntityRead() && this.fetchPartialColsFromInfoFamily()) {
            infoColFamilyList.addFilter((Filter)this.createFilterListForColsOfInfoFamily());
        } else {
            this.excludeFieldsFromInfoColFamily(infoColFamilyList);
        }
        listBasedOnFields.addFilter((Filter)infoColFamilyList);
        this.updateFilterForConfsAndMetricsToRetrieve(listBasedOnFields);
        return listBasedOnFields;
    }

    protected FlowContext lookupFlowContext(AppToFlowRowKey appToFlowRowKey, Configuration hbaseConf, Connection conn) throws IOException {
        byte[] rowKey = appToFlowRowKey.getRowKey();
        Get get = new Get(rowKey);
        Result result = this.appToFlowTable.getResult(hbaseConf, conn, get);
        if (result != null && !result.isEmpty()) {
            return new FlowContext(AppToFlowColumn.USER_ID.readResult(result).toString(), AppToFlowColumn.FLOW_ID.readResult(result).toString(), ((Number)AppToFlowColumn.FLOW_RUN_ID.readResult(result)).longValue());
        }
        throw new NotFoundException("Unable to find the context flow ID and flow run ID for clusterId=" + appToFlowRowKey.getClusterId() + ", appId=" + appToFlowRowKey.getAppId());
    }

    @Override
    protected void validateParams() {
        Preconditions.checkNotNull((Object)this.getContext(), (Object)"context shouldn't be null");
        Preconditions.checkNotNull((Object)this.getDataToRetrieve(), (Object)"data to retrieve shouldn't be null");
        Preconditions.checkNotNull((Object)this.getContext().getClusterId(), (Object)"clusterId shouldn't be null");
        Preconditions.checkNotNull((Object)this.getContext().getAppId(), (Object)"appId shouldn't be null");
        Preconditions.checkNotNull((Object)this.getContext().getEntityType(), (Object)"entityType shouldn't be null");
        if (this.isSingleEntityRead()) {
            Preconditions.checkNotNull((Object)this.getContext().getEntityId(), (Object)"entityId shouldn't be null");
        }
    }

    @Override
    protected void augmentParams(Configuration hbaseConf, Connection conn) throws IOException {
        TimelineReaderContext context = this.getContext();
        if (context.getFlowName() == null || context.getFlowRunId() == null || context.getUserId() == null) {
            AppToFlowRowKey appToFlowRowKey = new AppToFlowRowKey(context.getClusterId(), context.getAppId());
            FlowContext flowContext = this.lookupFlowContext(appToFlowRowKey, hbaseConf, conn);
            context.setFlowName(flowContext.flowName);
            context.setFlowRunId(flowContext.flowRunId.longValue());
            context.setUserId(flowContext.userId);
        }
        this.getDataToRetrieve().addFieldsBasedOnConfsAndMetricsToRetrieve();
        if (!this.isSingleEntityRead()) {
            this.createFiltersIfNull();
        }
    }

    @Override
    protected Result getResult(Configuration hbaseConf, Connection conn, FilterList filterList) throws IOException {
        TimelineReaderContext context = this.getContext();
        byte[] rowKey = new EntityRowKey(context.getClusterId(), context.getUserId(), context.getFlowName(), context.getFlowRunId(), context.getAppId(), context.getEntityType(), context.getEntityId()).getRowKey();
        Get get = new Get(rowKey);
        get.setMaxVersions(this.getDataToRetrieve().getMetricsLimit().intValue());
        if (filterList != null && !filterList.getFilters().isEmpty()) {
            get.setFilter((Filter)filterList);
        }
        return this.getTable().getResult(hbaseConf, conn, get);
    }

    @Override
    protected ResultScanner getResults(Configuration hbaseConf, Connection conn, FilterList filterList) throws IOException {
        Scan scan = new Scan();
        TimelineReaderContext context = this.getContext();
        EntityRowKeyPrefix entityRowKeyPrefix = new EntityRowKeyPrefix(context.getClusterId(), context.getUserId(), context.getFlowName(), context.getFlowRunId(), context.getAppId(), context.getEntityType());
        scan.setRowPrefixFilter(entityRowKeyPrefix.getRowKeyPrefix());
        scan.setMaxVersions(this.getDataToRetrieve().getMetricsLimit().intValue());
        if (filterList != null && !filterList.getFilters().isEmpty()) {
            scan.setFilter((Filter)filterList);
        }
        return this.getTable().getResultScanner(hbaseConf, conn, scan);
    }

    @Override
    protected TimelineEntity parseEntity(Result result) throws IOException {
        boolean checkEvents;
        boolean checkRelatesTo;
        boolean checkIsRelatedTo;
        if (result == null || result.isEmpty()) {
            return null;
        }
        TimelineEntity entity = new TimelineEntity();
        String entityType = EntityColumn.TYPE.readResult(result).toString();
        entity.setType(entityType);
        String entityId = EntityColumn.ID.readResult(result).toString();
        entity.setId(entityId);
        TimelineEntityFilters filters = this.getFilters();
        Long createdTime = (Long)EntityColumn.CREATED_TIME.readResult(result);
        entity.setCreatedTime(createdTime);
        EnumSet fieldsToRetrieve = this.getDataToRetrieve().getFieldsToRetrieve();
        boolean bl = checkIsRelatedTo = !this.isSingleEntityRead() && filters.getIsRelatedTo() != null && filters.getIsRelatedTo().getFilterList().size() > 0;
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.IS_RELATED_TO) || checkIsRelatedTo) {
            this.readRelationship(entity, result, EntityColumnPrefix.IS_RELATED_TO, true);
            if (checkIsRelatedTo && !TimelineStorageUtils.matchIsRelatedTo((TimelineEntity)entity, (TimelineFilterList)filters.getIsRelatedTo())) {
                return null;
            }
            if (!this.hasField(fieldsToRetrieve, TimelineReader.Field.IS_RELATED_TO)) {
                entity.getIsRelatedToEntities().clear();
            }
        }
        boolean bl2 = checkRelatesTo = !this.isSingleEntityRead() && filters.getRelatesTo() != null && filters.getRelatesTo().getFilterList().size() > 0;
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.RELATES_TO) || checkRelatesTo) {
            this.readRelationship(entity, result, EntityColumnPrefix.RELATES_TO, false);
            if (checkRelatesTo && !TimelineStorageUtils.matchRelatesTo((TimelineEntity)entity, (TimelineFilterList)filters.getRelatesTo())) {
                return null;
            }
            if (!this.hasField(fieldsToRetrieve, TimelineReader.Field.RELATES_TO)) {
                entity.getRelatesToEntities().clear();
            }
        }
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.INFO)) {
            this.readKeyValuePairs(entity, result, EntityColumnPrefix.INFO, false);
        }
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.CONFIGS)) {
            this.readKeyValuePairs(entity, result, EntityColumnPrefix.CONFIG, true);
        }
        boolean bl3 = checkEvents = !this.isSingleEntityRead() && filters.getEventFilters() != null && filters.getEventFilters().getFilterList().size() > 0;
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.EVENTS) || checkEvents) {
            GenericEntityReader.readEvents(entity, result, EntityColumnPrefix.EVENT);
            if (checkEvents && !TimelineStorageUtils.matchEventFilters((TimelineEntity)entity, (TimelineFilterList)filters.getEventFilters())) {
                return null;
            }
            if (!this.hasField(fieldsToRetrieve, TimelineReader.Field.EVENTS)) {
                entity.getEvents().clear();
            }
        }
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.METRICS)) {
            this.readMetrics(entity, result, EntityColumnPrefix.METRIC);
        }
        return entity;
    }

    protected <T> void readKeyValuePairs(TimelineEntity entity, Result result, ColumnPrefix<T> prefix, boolean isConfig) throws IOException {
        Map<String, Object> columns = prefix.readResults(result, this.stringKeyConverter);
        if (isConfig) {
            for (Map.Entry<String, Object> column : columns.entrySet()) {
                entity.addConfig(column.getKey(), column.getValue().toString());
            }
        } else {
            entity.addInfo(columns);
        }
    }

    protected static class FlowContext {
        private final String userId;
        private final String flowName;
        private final Long flowRunId;

        public FlowContext(String user, String flowName, Long flowRunId) {
            this.userId = user;
            this.flowName = flowName;
            this.flowRunId = flowRunId;
        }

        protected String getUserId() {
            return this.userId;
        }

        protected String getFlowName() {
            return this.flowName;
        }

        protected Long getFlowRunId() {
            return this.flowRunId;
        }
    }
}

