/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.application;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.yarn.server.timelineservice.storage.application.ApplicationColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.BaseTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.TimelineHBaseSchemaConstants;

public class ApplicationTable
extends BaseTable<ApplicationTable> {
    private static final String PREFIX = "yarn.timeline-service..application";
    public static final String TABLE_NAME_CONF_NAME = "yarn.timeline-service..application.table.name";
    private static final String METRICS_TTL_CONF_NAME = "yarn.timeline-service..application.table.metrics.ttl";
    private static final String METRICS_MAX_VERSIONS = "yarn.timeline-service..application.table.metrics.max-versions";
    private static final String DEFAULT_TABLE_NAME = "timelineservice.application";
    private static final int DEFAULT_METRICS_TTL = 2592000;
    private static final int DEFAULT_METRICS_MAX_VERSIONS = 10000;
    private static final Log LOG = LogFactory.getLog(ApplicationTable.class);

    public ApplicationTable() {
        super(TABLE_NAME_CONF_NAME, DEFAULT_TABLE_NAME);
    }

    @Override
    public void createTable(Admin admin, Configuration hbaseConf) throws IOException {
        TableName table = this.getTableName(hbaseConf);
        if (admin.tableExists(table)) {
            throw new IOException("Table " + table.getNameAsString() + " already exists.");
        }
        HTableDescriptor applicationTableDescp = new HTableDescriptor(table);
        HColumnDescriptor infoCF = new HColumnDescriptor(ApplicationColumnFamily.INFO.getBytes());
        infoCF.setBloomFilterType(BloomType.ROWCOL);
        applicationTableDescp.addFamily(infoCF);
        HColumnDescriptor configCF = new HColumnDescriptor(ApplicationColumnFamily.CONFIGS.getBytes());
        configCF.setBloomFilterType(BloomType.ROWCOL);
        configCF.setBlockCacheEnabled(true);
        applicationTableDescp.addFamily(configCF);
        HColumnDescriptor metricsCF = new HColumnDescriptor(ApplicationColumnFamily.METRICS.getBytes());
        applicationTableDescp.addFamily(metricsCF);
        metricsCF.setBlockCacheEnabled(true);
        metricsCF.setMinVersions(1);
        metricsCF.setMaxVersions(hbaseConf.getInt(METRICS_MAX_VERSIONS, 10000));
        metricsCF.setTimeToLive(hbaseConf.getInt(METRICS_TTL_CONF_NAME, 2592000));
        applicationTableDescp.setRegionSplitPolicyClassName("org.apache.hadoop.hbase.regionserver.KeyPrefixRegionSplitPolicy");
        applicationTableDescp.setValue("KeyPrefixRegionSplitPolicy.prefix_length", "4");
        admin.createTable(applicationTableDescp, TimelineHBaseSchemaConstants.getUsernameSplits());
        LOG.info((Object)("Status of table creation for " + table.getNameAsString() + "=" + admin.tableExists(table)));
    }

    public void setMetricsTTL(int metricsTTL, Configuration hbaseConf) {
        hbaseConf.setInt(METRICS_TTL_CONF_NAME, metricsTTL);
    }
}

