/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.apptoflow;

import java.io.IOException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.server.timelineservice.storage.apptoflow.AppToFlowColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.apptoflow.AppToFlowTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Column;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnHelper;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.TypedBufferedMutator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ValueConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.Attribute;

public enum AppToFlowColumn implements Column<AppToFlowTable>
{
    FLOW_ID(AppToFlowColumnFamily.MAPPING, "flow_id"),
    FLOW_RUN_ID(AppToFlowColumnFamily.MAPPING, "flow_run_id"),
    USER_ID(AppToFlowColumnFamily.MAPPING, "user_id");

    private final ColumnHelper<AppToFlowTable> column;
    private final ColumnFamily<AppToFlowTable> columnFamily;
    private final String columnQualifier;
    private final byte[] columnQualifierBytes;

    private AppToFlowColumn(ColumnFamily<AppToFlowTable> columnFamily, String columnQualifier) {
        this.columnFamily = columnFamily;
        this.columnQualifier = columnQualifier;
        this.columnQualifierBytes = Bytes.toBytes((String)Separator.SPACE.encode(columnQualifier));
        this.column = new ColumnHelper<AppToFlowTable>(columnFamily);
    }

    private String getColumnQualifier() {
        return this.columnQualifier;
    }

    @Override
    public byte[] getColumnQualifierBytes() {
        return (byte[])this.columnQualifierBytes.clone();
    }

    @Override
    public void store(byte[] rowKey, TypedBufferedMutator<AppToFlowTable> tableMutator, Long timestamp, Object inputValue, Attribute ... attributes) throws IOException {
        this.column.store(rowKey, tableMutator, this.columnQualifierBytes, timestamp, inputValue, attributes);
    }

    @Override
    public byte[] getColumnFamilyBytes() {
        return this.columnFamily.getBytes();
    }

    @Override
    public ValueConverter getValueConverter() {
        return this.column.getValueConverter();
    }

    @Override
    public Object readResult(Result result) throws IOException {
        return this.column.readResult(result, this.columnQualifierBytes);
    }

    public static final AppToFlowColumn columnFor(String columnQualifier) {
        for (AppToFlowColumn ec : AppToFlowColumn.values()) {
            if (!ec.getColumnQualifier().equals(columnQualifier)) continue;
            return ec;
        }
        return null;
    }

    public static final AppToFlowColumn columnFor(AppToFlowColumnFamily columnFamily, String name) {
        for (AppToFlowColumn ec : AppToFlowColumn.values()) {
            if (!ec.columnFamily.equals(columnFamily) || !ec.getColumnQualifier().equals(name)) continue;
            return ec;
        }
        return null;
    }
}

