/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.apptoflow;

import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.AppIdKeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.KeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;

public class AppToFlowRowKey {
    private final String clusterId;
    private final String appId;
    private final KeyConverter<AppToFlowRowKey> appToFlowRowKeyConverter = new AppToFlowRowKeyConverter();

    public AppToFlowRowKey(String clusterId, String appId) {
        this.clusterId = clusterId;
        this.appId = appId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getAppId() {
        return this.appId;
    }

    public byte[] getRowKey() {
        return this.appToFlowRowKeyConverter.encode(this);
    }

    public static AppToFlowRowKey parseRowKey(byte[] rowKey) {
        return new AppToFlowRowKeyConverter().decode(rowKey);
    }

    private static final class AppToFlowRowKeyConverter
    implements KeyConverter<AppToFlowRowKey> {
        private final KeyConverter<String> appIDKeyConverter = new AppIdKeyConverter();
        private static final int[] SEGMENT_SIZES = new int[]{0, 12};

        private AppToFlowRowKeyConverter() {
        }

        @Override
        public byte[] encode(AppToFlowRowKey rowKey) {
            byte[] first = Separator.encode(rowKey.getClusterId(), Separator.SPACE, Separator.TAB, Separator.QUALIFIERS);
            byte[] second = this.appIDKeyConverter.encode(rowKey.getAppId());
            return Separator.QUALIFIERS.join(first, second);
        }

        @Override
        public AppToFlowRowKey decode(byte[] rowKey) {
            byte[][] rowKeyComponents = Separator.QUALIFIERS.split(rowKey, SEGMENT_SIZES);
            if (rowKeyComponents.length != 2) {
                throw new IllegalArgumentException("the row key is not valid for the app-to-flow table");
            }
            String clusterId = Separator.decode(Bytes.toString((byte[])rowKeyComponents[0]), Separator.QUALIFIERS, Separator.TAB, Separator.SPACE);
            String appId = this.appIDKeyConverter.decode(rowKeyComponents[1]);
            return new AppToFlowRowKey(clusterId, appId);
        }
    }
}

