/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.common;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.NumericValueConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.TimelineStorageUtils;

public final class LongConverter
implements NumericValueConverter,
Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public byte[] encodeValue(Object value) throws IOException {
        if (!TimelineStorageUtils.isIntegralValue((Object)value)) {
            throw new IOException("Expected integral value");
        }
        return Bytes.toBytes((long)((Number)value).longValue());
    }

    @Override
    public Object decodeValue(byte[] bytes) throws IOException {
        if (bytes == null) {
            return null;
        }
        return Bytes.toLong((byte[])bytes);
    }

    @Override
    public int compare(Number num1, Number num2) {
        return Long.compare(num1 == null ? 0L : num1.longValue(), num2 == null ? 0L : num2.longValue());
    }

    @Override
    public Number add(Number num1, Number num2, Number ... numbers) {
        long sum = (num1 == null ? 0L : num1.longValue()) + (num2 == null ? 0L : num2.longValue());
        for (Number num : numbers) {
            sum += num == null ? 0L : num.longValue();
        }
        return sum;
    }

    public static long invertLong(long key) {
        return Long.MAX_VALUE - key;
    }
}

