/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.entity;

import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.AppIdKeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.KeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.LongConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;

public class EntityRowKey {
    private final String clusterId;
    private final String userId;
    private final String flowName;
    private final Long flowRunId;
    private final String appId;
    private final String entityType;
    private final String entityId;
    private final KeyConverter<EntityRowKey> entityRowKeyConverter = new EntityRowKeyConverter();

    public EntityRowKey(String clusterId, String userId, String flowName, Long flowRunId, String appId, String entityType, String entityId) {
        this.clusterId = clusterId;
        this.userId = userId;
        this.flowName = flowName;
        this.flowRunId = flowRunId;
        this.appId = appId;
        this.entityType = entityType;
        this.entityId = entityId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public Long getFlowRunId() {
        return this.flowRunId;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public byte[] getRowKey() {
        return this.entityRowKeyConverter.encode(this);
    }

    public static EntityRowKey parseRowKey(byte[] rowKey) {
        return new EntityRowKeyConverter().decode(rowKey);
    }

    private static final class EntityRowKeyConverter
    implements KeyConverter<EntityRowKey> {
        private final AppIdKeyConverter appIDKeyConverter = new AppIdKeyConverter();
        private static final int[] SEGMENT_SIZES = new int[]{0, 0, 0, 8, AppIdKeyConverter.getKeySize(), 0, 0};

        private EntityRowKeyConverter() {
        }

        @Override
        public byte[] encode(EntityRowKey rowKey) {
            byte[] user = Separator.encode(rowKey.getUserId(), Separator.SPACE, Separator.TAB, Separator.QUALIFIERS);
            byte[] cluster = Separator.encode(rowKey.getClusterId(), Separator.SPACE, Separator.TAB, Separator.QUALIFIERS);
            byte[] flow = Separator.encode(rowKey.getFlowName(), Separator.SPACE, Separator.TAB, Separator.QUALIFIERS);
            byte[] first = Separator.QUALIFIERS.join(user, cluster, flow);
            byte[] second = Bytes.toBytes((long)LongConverter.invertLong(rowKey.getFlowRunId()));
            byte[] third = this.appIDKeyConverter.encode(rowKey.getAppId());
            if (rowKey.getEntityType() == null) {
                return Separator.QUALIFIERS.join(first, second, third, Separator.EMPTY_BYTES);
            }
            byte[] entityType = Separator.encode(rowKey.getEntityType(), Separator.SPACE, Separator.TAB, Separator.QUALIFIERS);
            byte[] entityId = rowKey.getEntityId() == null ? Separator.EMPTY_BYTES : Separator.encode(rowKey.getEntityId(), Separator.SPACE, Separator.TAB, Separator.QUALIFIERS);
            byte[] fourth = Separator.QUALIFIERS.join(entityType, entityId);
            return Separator.QUALIFIERS.join(first, second, third, fourth);
        }

        @Override
        public EntityRowKey decode(byte[] rowKey) {
            byte[][] rowKeyComponents = Separator.QUALIFIERS.split(rowKey, SEGMENT_SIZES);
            if (rowKeyComponents.length != 7) {
                throw new IllegalArgumentException("the row key is not valid for an entity");
            }
            String userId = Separator.decode(Bytes.toString((byte[])rowKeyComponents[0]), Separator.QUALIFIERS, Separator.TAB, Separator.SPACE);
            String clusterId = Separator.decode(Bytes.toString((byte[])rowKeyComponents[1]), Separator.QUALIFIERS, Separator.TAB, Separator.SPACE);
            String flowName = Separator.decode(Bytes.toString((byte[])rowKeyComponents[2]), Separator.QUALIFIERS, Separator.TAB, Separator.SPACE);
            Long flowRunId = LongConverter.invertLong(Bytes.toLong((byte[])rowKeyComponents[3]));
            String appId = this.appIDKeyConverter.decode(rowKeyComponents[4]);
            String entityType = Separator.decode(Bytes.toString((byte[])rowKeyComponents[5]), Separator.QUALIFIERS, Separator.TAB, Separator.SPACE);
            String entityId = Separator.decode(Bytes.toString((byte[])rowKeyComponents[6]), Separator.QUALIFIERS, Separator.TAB, Separator.SPACE);
            return new EntityRowKey(clusterId, userId, flowName, flowRunId, appId, entityType, entityId);
        }
    }
}

