/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.common;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.Query;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.AggregationCompactionDimension;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.AggregationOperation;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.Attribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HBaseTimelineStorageUtils {
    public static final long MILLIS_ONE_DAY = 86400000L;
    private static final Logger LOG = LoggerFactory.getLogger(HBaseTimelineStorageUtils.class);
    private static final ThreadLocal<NumberFormat> APP_ID_FORMAT = new ThreadLocal<NumberFormat>(){

        @Override
        public NumberFormat initialValue() {
            NumberFormat fmt = NumberFormat.getInstance();
            fmt.setGroupingUsed(false);
            fmt.setMinimumIntegerDigits(4);
            return fmt;
        }
    };

    private HBaseTimelineStorageUtils() {
    }

    public static Attribute[] combineAttributes(Attribute[] attributes, AggregationOperation aggOp) {
        int newLength = HBaseTimelineStorageUtils.getNewLengthCombinedAttributes(attributes, aggOp);
        Attribute[] combinedAttributes = new Attribute[newLength];
        if (attributes != null) {
            System.arraycopy(attributes, 0, combinedAttributes, 0, attributes.length);
        }
        if (aggOp != null) {
            Attribute a2;
            combinedAttributes[newLength - 1] = a2 = aggOp.getAttribute();
        }
        return combinedAttributes;
    }

    private static int getNewLengthCombinedAttributes(Attribute[] attributes, AggregationOperation aggOp) {
        int oldLength = HBaseTimelineStorageUtils.getAttributesLength(attributes);
        int aggLength = HBaseTimelineStorageUtils.getAppOpLength(aggOp);
        return oldLength + aggLength;
    }

    private static int getAppOpLength(AggregationOperation aggOp) {
        if (aggOp != null) {
            return 1;
        }
        return 0;
    }

    private static int getAttributesLength(Attribute[] attributes) {
        if (attributes != null) {
            return attributes.length;
        }
        return 0;
    }

    public static AggregationOperation getAggregationOperationFromTagsList(List<Tag> tags) {
        for (AggregationOperation aggOp : AggregationOperation.values()) {
            for (Tag tag : tags) {
                if (tag.getType() != aggOp.getTagType()) continue;
                return aggOp;
            }
        }
        return null;
    }

    public static Tag getTagFromAttribute(Map.Entry<String, byte[]> attribute) {
        AggregationOperation aggOp = AggregationOperation.getAggregationOperation(attribute.getKey());
        if (aggOp != null) {
            Tag t = new Tag(aggOp.getTagType(), attribute.getValue());
            return t;
        }
        AggregationCompactionDimension aggCompactDim = AggregationCompactionDimension.getAggregationCompactionDimension(attribute.getKey());
        if (aggCompactDim != null) {
            Tag t = new Tag(aggCompactDim.getTagType(), attribute.getValue());
            return t;
        }
        return null;
    }

    public static Cell createNewCell(Cell origCell, byte[] newValue) throws IOException {
        return CellUtil.createCell((byte[])CellUtil.cloneRow((Cell)origCell), (byte[])CellUtil.cloneFamily((Cell)origCell), (byte[])CellUtil.cloneQualifier((Cell)origCell), (long)origCell.getTimestamp(), (byte)KeyValue.Type.Put.getCode(), (byte[])newValue);
    }

    public static Cell createNewCell(byte[] row, byte[] family, byte[] qualifier, long ts, byte[] newValue, byte[] tags) throws IOException {
        return CellUtil.createCell((byte[])row, (byte[])family, (byte[])qualifier, (long)ts, (KeyValue.Type)KeyValue.Type.Put, (byte[])newValue, (byte[])tags);
    }

    public static String getAggregationCompactionDimension(List<Tag> tags) {
        String appId = null;
        for (Tag t : tags) {
            if (AggregationCompactionDimension.APPLICATION_ID.getTagType() != t.getType()) continue;
            appId = Bytes.toString((byte[])t.getValue());
            return appId;
        }
        return appId;
    }

    public static int invertInt(int key) {
        return Integer.MAX_VALUE - key;
    }

    public static long getTopOfTheDayTimestamp(long ts) {
        long dayTimestamp = ts - ts % 86400000L;
        return dayTimestamp;
    }

    public static String convertApplicationIdToString(ApplicationId appId) {
        StringBuilder sb = new StringBuilder(64);
        sb.append("application");
        sb.append("_");
        sb.append(appId.getClusterTimestamp());
        sb.append('_');
        sb.append(APP_ID_FORMAT.get().format(appId.getId()));
        return sb.toString();
    }

    public static Configuration getTimelineServiceHBaseConf(Configuration conf) throws MalformedURLException {
        Configuration hbaseConf;
        if (conf == null) {
            throw new NullPointerException();
        }
        String timelineServiceHBaseConfFileURL = conf.get("yarn.timeline-service.hbase.configuration.file");
        if (timelineServiceHBaseConfFileURL != null && timelineServiceHBaseConfFileURL.length() > 0) {
            LOG.info("Using hbase configuration at " + timelineServiceHBaseConfFileURL);
            hbaseConf = new Configuration(conf);
            Configuration plainHBaseConf = new Configuration(false);
            URL hbaseSiteXML = new URL(timelineServiceHBaseConfFileURL);
            plainHBaseConf.addResource(hbaseSiteXML);
            HBaseConfiguration.merge((Configuration)hbaseConf, (Configuration)plainHBaseConf);
        } else {
            hbaseConf = HBaseConfiguration.create((Configuration)conf);
        }
        return hbaseConf;
    }

    public static byte[] calculateTheClosestNextRowKeyForPrefix(byte[] rowKeyPrefix) {
        int offset;
        for (offset = rowKeyPrefix.length; offset > 0 && rowKeyPrefix[offset - 1] == -1; --offset) {
        }
        if (offset == 0) {
            return HConstants.EMPTY_END_ROW;
        }
        byte[] newStopRow = Arrays.copyOfRange(rowKeyPrefix, 0, offset);
        int n = newStopRow.length - 1;
        newStopRow[n] = (byte)(newStopRow[n] + 1);
        return newStopRow;
    }

    public static boolean isIntegralValue(Object obj) {
        return obj instanceof Short || obj instanceof Integer || obj instanceof Long;
    }

    public static void setMetricsTimeRange(Query query, byte[] metricsCf, long tsBegin, long tsEnd) {
        if (tsBegin != 0L || tsEnd != Long.MAX_VALUE) {
            query.setColumnFamilyTimeRange(metricsCf, tsBegin, tsEnd == Long.MAX_VALUE ? Long.MAX_VALUE : tsEnd + 1L);
        }
    }
}

