/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader.filter;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.BinaryPrefixComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.FamilyFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineCompareFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineCompareOp;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineExistsFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilterList;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineKeyValueFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineKeyValuesFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelinePrefixFilter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Column;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnPrefix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimelineFilterUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TimelineFilterUtils.class);

    private TimelineFilterUtils() {
    }

    private static FilterList.Operator getHBaseOperator(TimelineFilterList.Operator op) {
        switch (op) {
            case AND: {
                return FilterList.Operator.MUST_PASS_ALL;
            }
            case OR: {
                return FilterList.Operator.MUST_PASS_ONE;
            }
        }
        throw new IllegalArgumentException("Invalid operator");
    }

    private static CompareFilter.CompareOp getHBaseCompareOp(TimelineCompareOp op) {
        switch (op) {
            case LESS_THAN: {
                return CompareFilter.CompareOp.LESS;
            }
            case LESS_OR_EQUAL: {
                return CompareFilter.CompareOp.LESS_OR_EQUAL;
            }
            case EQUAL: {
                return CompareFilter.CompareOp.EQUAL;
            }
            case NOT_EQUAL: {
                return CompareFilter.CompareOp.NOT_EQUAL;
            }
            case GREATER_OR_EQUAL: {
                return CompareFilter.CompareOp.GREATER_OR_EQUAL;
            }
            case GREATER_THAN: {
                return CompareFilter.CompareOp.GREATER;
            }
        }
        throw new IllegalArgumentException("Invalid compare operator");
    }

    private static <T> Filter createHBaseColQualPrefixFilter(ColumnPrefix<T> colPrefix, TimelinePrefixFilter filter) {
        return new QualifierFilter(TimelineFilterUtils.getHBaseCompareOp(filter.getCompareOp()), (ByteArrayComparable)new BinaryPrefixComparator(colPrefix.getColumnPrefixBytes(filter.getPrefix())));
    }

    public static <T> Filter createHBaseQualifierFilter(CompareFilter.CompareOp compareOp, ColumnPrefix<T> columnPrefix) {
        return new QualifierFilter(compareOp, (ByteArrayComparable)new BinaryPrefixComparator(columnPrefix.getColumnPrefixBytes("")));
    }

    public static <T> Filter createFilterForConfsOrMetricsToRetrieve(TimelineFilterList confsOrMetricToRetrieve, ColumnFamily<T> columnFamily, ColumnPrefix<T> columnPrefix) throws IOException {
        FamilyFilter familyFilter = new FamilyFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(columnFamily.getBytes()));
        if (confsOrMetricToRetrieve != null && !confsOrMetricToRetrieve.getFilterList().isEmpty()) {
            FilterList filter = new FilterList(new Filter[]{familyFilter});
            filter.addFilter((Filter)TimelineFilterUtils.createHBaseFilterList(columnPrefix, confsOrMetricToRetrieve));
            return filter;
        }
        return familyFilter;
    }

    public static <T> FilterList createSingleColValueFiltersByRange(Column<T> column, Object startValue, Object endValue) throws IOException {
        FilterList list = new FilterList(new Filter[0]);
        SingleColumnValueFilter singleColValFilterStart = TimelineFilterUtils.createHBaseSingleColValueFilter(column.getColumnFamilyBytes(), column.getColumnQualifierBytes(), column.getValueConverter().encodeValue(startValue), CompareFilter.CompareOp.GREATER_OR_EQUAL, true);
        list.addFilter((Filter)singleColValFilterStart);
        SingleColumnValueFilter singleColValFilterEnd = TimelineFilterUtils.createHBaseSingleColValueFilter(column.getColumnFamilyBytes(), column.getColumnQualifierBytes(), column.getValueConverter().encodeValue(endValue), CompareFilter.CompareOp.LESS_OR_EQUAL, true);
        list.addFilter((Filter)singleColValFilterEnd);
        return list;
    }

    public static <T> Filter createHBaseSingleColValueFilter(Column<T> column, Object value, CompareFilter.CompareOp op) throws IOException {
        SingleColumnValueFilter singleColValFilter = TimelineFilterUtils.createHBaseSingleColValueFilter(column.getColumnFamilyBytes(), column.getColumnQualifierBytes(), column.getValueConverter().encodeValue(value), op, true);
        return singleColValFilter;
    }

    private static SingleColumnValueFilter createHBaseSingleColValueFilter(byte[] columnFamily, byte[] columnQualifier, byte[] value, CompareFilter.CompareOp compareOp, boolean filterIfMissing) throws IOException {
        SingleColumnValueFilter singleColValFilter = new SingleColumnValueFilter(columnFamily, columnQualifier, compareOp, (ByteArrayComparable)new BinaryComparator(value));
        singleColValFilter.setLatestVersionOnly(true);
        singleColValFilter.setFilterIfMissing(filterIfMissing);
        return singleColValFilter;
    }

    public static Set<String> fetchColumnsFromFilterList(TimelineFilterList filterList) {
        HashSet<String> strSet = new HashSet<String>();
        block5: for (TimelineFilter filter : filterList.getFilterList()) {
            switch (filter.getFilterType()) {
                case LIST: {
                    strSet.addAll(TimelineFilterUtils.fetchColumnsFromFilterList((TimelineFilterList)filter));
                    continue block5;
                }
                case KEY_VALUES: {
                    strSet.add(((TimelineKeyValuesFilter)filter).getKey());
                    continue block5;
                }
                case EXISTS: {
                    strSet.add(((TimelineExistsFilter)filter).getValue());
                    continue block5;
                }
            }
            LOG.info("Unexpected filter type " + filter.getFilterType());
        }
        return strSet;
    }

    public static <T> FilterList createHBaseFilterList(ColumnPrefix<T> colPrefix, TimelineFilterList filterList) throws IOException {
        FilterList list = new FilterList(TimelineFilterUtils.getHBaseOperator(filterList.getOperator()));
        block6: for (TimelineFilter filter : filterList.getFilterList()) {
            switch (filter.getFilterType()) {
                case LIST: {
                    list.addFilter((Filter)TimelineFilterUtils.createHBaseFilterList(colPrefix, (TimelineFilterList)filter));
                    continue block6;
                }
                case PREFIX: {
                    list.addFilter(TimelineFilterUtils.createHBaseColQualPrefixFilter(colPrefix, (TimelinePrefixFilter)filter));
                    continue block6;
                }
                case COMPARE: {
                    TimelineCompareFilter compareFilter = (TimelineCompareFilter)filter;
                    list.addFilter((Filter)TimelineFilterUtils.createHBaseSingleColValueFilter(colPrefix.getColumnFamilyBytes(), colPrefix.getColumnPrefixBytes(compareFilter.getKey()), colPrefix.getValueConverter().encodeValue(compareFilter.getValue()), TimelineFilterUtils.getHBaseCompareOp(compareFilter.getCompareOp()), compareFilter.getKeyMustExist()));
                    continue block6;
                }
                case KEY_VALUE: {
                    TimelineKeyValueFilter kvFilter = (TimelineKeyValueFilter)filter;
                    list.addFilter((Filter)TimelineFilterUtils.createHBaseSingleColValueFilter(colPrefix.getColumnFamilyBytes(), colPrefix.getColumnPrefixBytes(kvFilter.getKey()), colPrefix.getValueConverter().encodeValue(kvFilter.getValue()), TimelineFilterUtils.getHBaseCompareOp(kvFilter.getCompareOp()), kvFilter.getKeyMustExist()));
                    continue block6;
                }
            }
            LOG.info("Unexpected filter type " + filter.getFilterType());
        }
        return list;
    }
}

