/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.collector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.api.CollectorNodemanagerProtocol;
import org.apache.hadoop.yarn.server.api.protocolrecords.GetTimelineCollectorContextRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.GetTimelineCollectorContextResponse;
import org.apache.hadoop.yarn.server.timelineservice.collector.AppLevelTimelineCollectorWithAgg;
import org.apache.hadoop.yarn.server.timelineservice.collector.NodeTimelineCollectorManager;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollector;
import org.apache.hadoop.yarn.server.timelineservice.storage.FileSystemTimelineWriterImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineWriter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestNMTimelineCollectorManager {
    private NodeTimelineCollectorManager collectorManager;

    @Before
    public void setup() throws Exception {
        this.collectorManager = this.createCollectorManager();
        YarnConfiguration conf = new YarnConfiguration();
        conf.setClass("yarn.timeline-service.writer.class", FileSystemTimelineWriterImpl.class, TimelineWriter.class);
        this.collectorManager.init((Configuration)conf);
        this.collectorManager.start();
    }

    @After
    public void tearDown() throws Exception {
        if (this.collectorManager != null) {
            this.collectorManager.stop();
        }
    }

    @Test
    public void testStartingWriterFlusher() throws Exception {
        Assert.assertTrue((boolean)this.collectorManager.writerFlusherRunning());
    }

    @Test
    public void testStartWebApp() throws Exception {
        Assert.assertNotNull((Object)this.collectorManager.getRestServerBindAddress());
        String address = this.collectorManager.getRestServerBindAddress();
        String[] parts = address.split(":");
        Assert.assertEquals((long)2L, (long)parts.length);
        Assert.assertNotNull((Object)parts[0]);
        Assert.assertTrue((Integer.valueOf(parts[1]) > 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testMultithreadedAdd() throws Exception {
        int numApps = 5;
        ArrayList<Object> tasks = new ArrayList<Object>();
        for (int i = 0; i < 5; ++i) {
            final ApplicationId appId = ApplicationId.newInstance((long)0L, (int)i);
            Callable<Boolean> task = new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    AppLevelTimelineCollectorWithAgg collector = new AppLevelTimelineCollectorWithAgg(appId, "user");
                    return TestNMTimelineCollectorManager.this.collectorManager.putIfAbsent(appId, (TimelineCollector)collector) == collector;
                }
            };
            tasks.add(task);
        }
        ExecutorService executor = Executors.newFixedThreadPool(5);
        try {
            List futures = executor.invokeAll(tasks);
            for (Future future : futures) {
                Assert.assertTrue((boolean)((Boolean)future.get()));
            }
        }
        finally {
            executor.shutdownNow();
        }
        for (int i = 0; i < 5; ++i) {
            ApplicationId appId = ApplicationId.newInstance((long)0L, (int)i);
            Assert.assertTrue((boolean)this.collectorManager.containsTimelineCollector(appId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultithreadedAddAndRemove() throws Exception {
        int numApps = 5;
        ArrayList<Object> tasks = new ArrayList<Object>();
        for (int i = 0; i < 5; ++i) {
            final ApplicationId appId = ApplicationId.newInstance((long)0L, (int)i);
            Callable<Boolean> task = new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    AppLevelTimelineCollectorWithAgg collector = new AppLevelTimelineCollectorWithAgg(appId, "user");
                    boolean successPut = TestNMTimelineCollectorManager.this.collectorManager.putIfAbsent(appId, (TimelineCollector)collector) == collector;
                    return successPut && TestNMTimelineCollectorManager.this.collectorManager.remove(appId);
                }
            };
            tasks.add(task);
        }
        ExecutorService executor = Executors.newFixedThreadPool(5);
        try {
            List futures = executor.invokeAll(tasks);
            for (Future future : futures) {
                Assert.assertTrue((boolean)((Boolean)future.get()));
            }
        }
        finally {
            executor.shutdownNow();
        }
        for (int i = 0; i < 5; ++i) {
            ApplicationId appId = ApplicationId.newInstance((long)0L, (int)i);
            Assert.assertFalse((boolean)this.collectorManager.containsTimelineCollector(appId));
        }
    }

    private NodeTimelineCollectorManager createCollectorManager() {
        NodeTimelineCollectorManager cm = (NodeTimelineCollectorManager)Mockito.spy((Object)new NodeTimelineCollectorManager());
        ((NodeTimelineCollectorManager)Mockito.doReturn((Object)new Configuration()).when((Object)cm)).getConfig();
        CollectorNodemanagerProtocol nmCollectorService = (CollectorNodemanagerProtocol)Mockito.mock(CollectorNodemanagerProtocol.class);
        GetTimelineCollectorContextResponse response = GetTimelineCollectorContextResponse.newInstance(null, null, null, (long)0L);
        try {
            Mockito.when((Object)nmCollectorService.getTimelineCollectorContext((GetTimelineCollectorContextRequest)Matchers.any(GetTimelineCollectorContextRequest.class))).thenReturn((Object)response);
        }
        catch (IOException | YarnException e) {
            Assert.fail();
        }
        ((NodeTimelineCollectorManager)Mockito.doReturn((Object)nmCollectorService).when((Object)cm)).getNMCollectorService();
        return cm;
    }
}

