/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineParseException;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderWebServicesUtils;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineCompareFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineCompareOp;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineExistsFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilterList;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineKeyValueFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineKeyValuesFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelinePrefixFilter;
import org.junit.Assert;
import org.junit.Test;

public class TestTimelineReaderWebServicesUtils {
    private static void verifyFilterList(String expr, TimelineFilterList list, TimelineFilterList expectedList) throws Exception {
        Assert.assertNotNull((Object)list);
        Assert.assertTrue((String)("Unexpected List received after parsing expression " + expr + ". Expected=" + expectedList + " but Actual=" + list), (boolean)list.equals((Object)expectedList));
    }

    @Test
    public void testMetricFiltersParsing() throws Exception {
        String expr = "(((key11 ne 234 AND key12 gt 23) AND (key13 lt 34 OR key14 ge 567)) OR (key21 lt 24 OR key22 le 45))";
        TimelineFilterList expectedList = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelineFilterList(TimelineFilterList.Operator.AND, new TimelineFilter[]{new TimelineFilterList(TimelineFilterList.Operator.AND, new TimelineFilter[]{new TimelineCompareFilter(TimelineCompareOp.NOT_EQUAL, "key11", (Object)234, false), new TimelineCompareFilter(TimelineCompareOp.GREATER_THAN, "key12", (Object)23, true)}), new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelineCompareFilter(TimelineCompareOp.LESS_THAN, "key13", (Object)34, true), new TimelineCompareFilter(TimelineCompareOp.GREATER_OR_EQUAL, "key14", (Object)567, true)})}), new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelineCompareFilter(TimelineCompareOp.LESS_THAN, "key21", (Object)24, true), new TimelineCompareFilter(TimelineCompareOp.LESS_OR_EQUAL, "key22", (Object)45, true)})});
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseMetricFilters((String)expr), expectedList);
        expr = "abc ene 234";
        expectedList = new TimelineFilterList(new TimelineFilter[]{new TimelineCompareFilter(TimelineCompareOp.NOT_EQUAL, "abc", (Object)234, true)});
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseMetricFilters((String)expr), expectedList);
        expr = "abc ne 234";
        expectedList = new TimelineFilterList(new TimelineFilter[]{new TimelineCompareFilter(TimelineCompareOp.NOT_EQUAL, "abc", (Object)234, false)});
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseMetricFilters((String)expr), expectedList);
        expr = "abc ne 234 AND def gt 23";
        expectedList = new TimelineFilterList(new TimelineFilter[]{new TimelineCompareFilter(TimelineCompareOp.NOT_EQUAL, "abc", (Object)234, false), new TimelineCompareFilter(TimelineCompareOp.GREATER_THAN, "def", (Object)23, true)});
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseMetricFilters((String)expr), expectedList);
        expr = "(abc ne 234 AND def gt 23)";
        expectedList = new TimelineFilterList(new TimelineFilter[]{new TimelineCompareFilter(TimelineCompareOp.NOT_EQUAL, "abc", (Object)234, false), new TimelineCompareFilter(TimelineCompareOp.GREATER_THAN, "def", (Object)23, true)});
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseMetricFilters((String)expr), expectedList);
        expr = "abc ne 234 AND def gt 23 OR rst lt 24";
        expectedList = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelineFilterList(new TimelineFilter[]{new TimelineCompareFilter(TimelineCompareOp.NOT_EQUAL, "abc", (Object)234, false), new TimelineCompareFilter(TimelineCompareOp.GREATER_THAN, "def", (Object)23, true)}), new TimelineCompareFilter(TimelineCompareOp.LESS_THAN, "rst", (Object)24, true)});
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseMetricFilters((String)expr), expectedList);
        expr = "abc ne 234 AND def gt 23 OR rst lt 24 OR xyz le 456";
        expectedList = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelineFilterList(new TimelineFilter[]{new TimelineCompareFilter(TimelineCompareOp.NOT_EQUAL, "abc", (Object)234, false), new TimelineCompareFilter(TimelineCompareOp.GREATER_THAN, "def", (Object)23, true)}), new TimelineCompareFilter(TimelineCompareOp.LESS_THAN, "rst", (Object)24, true), new TimelineCompareFilter(TimelineCompareOp.LESS_OR_EQUAL, "xyz", (Object)456, true)});
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseMetricFilters((String)expr), expectedList);
        expr = "abc ne 234 AND def gt 23 OR rst lt 24 OR xyz le 456 AND pqr ge 2";
        expectedList = new TimelineFilterList(new TimelineFilter[]{new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelineFilterList(new TimelineFilter[]{new TimelineCompareFilter(TimelineCompareOp.NOT_EQUAL, "abc", (Object)234, false), new TimelineCompareFilter(TimelineCompareOp.GREATER_THAN, "def", (Object)23, true)}), new TimelineCompareFilter(TimelineCompareOp.LESS_THAN, "rst", (Object)24, true), new TimelineCompareFilter(TimelineCompareOp.LESS_OR_EQUAL, "xyz", (Object)456, true)}), new TimelineCompareFilter(TimelineCompareOp.GREATER_OR_EQUAL, "pqr", (Object)2, true)});
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseMetricFilters((String)expr), expectedList);
        expr = "  abc ne   234       AND       def           gt 23 OR     rst lt            24     OR xyz     le     456    AND pqr ge 2        ";
        expectedList = new TimelineFilterList(new TimelineFilter[]{new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelineFilterList(new TimelineFilter[]{new TimelineCompareFilter(TimelineCompareOp.NOT_EQUAL, "abc", (Object)234, false), new TimelineCompareFilter(TimelineCompareOp.GREATER_THAN, "def", (Object)23, true)}), new TimelineCompareFilter(TimelineCompareOp.LESS_THAN, "rst", (Object)24, true), new TimelineCompareFilter(TimelineCompareOp.LESS_OR_EQUAL, "xyz", (Object)456, true)}), new TimelineCompareFilter(TimelineCompareOp.GREATER_OR_EQUAL, "pqr", (Object)2, true)});
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseMetricFilters((String)expr), expectedList);
        expr = "(((key11 ne 234 AND key12 gt 23 OR key13 lt 24 OR key14 le 456 AND key15 ge 2) AND (key16 lt 34 OR key17 ge 567)) OR (key21 lt 24 OR key22 le 45))";
        expectedList = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelineFilterList(TimelineFilterList.Operator.AND, new TimelineFilter[]{new TimelineFilterList(new TimelineFilter[]{new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelineFilterList(new TimelineFilter[]{new TimelineCompareFilter(TimelineCompareOp.NOT_EQUAL, "key11", (Object)234, false), new TimelineCompareFilter(TimelineCompareOp.GREATER_THAN, "key12", (Object)23, true)}), new TimelineCompareFilter(TimelineCompareOp.LESS_THAN, "key13", (Object)24, true), new TimelineCompareFilter(TimelineCompareOp.LESS_OR_EQUAL, "key14", (Object)456, true)}), new TimelineCompareFilter(TimelineCompareOp.GREATER_OR_EQUAL, "key15", (Object)2, true)}), new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelineCompareFilter(TimelineCompareOp.LESS_THAN, "key16", (Object)34, true), new TimelineCompareFilter(TimelineCompareOp.GREATER_OR_EQUAL, "key17", (Object)567, true)})}), new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelineCompareFilter(TimelineCompareOp.LESS_THAN, "key21", (Object)24, true), new TimelineCompareFilter(TimelineCompareOp.LESS_OR_EQUAL, "key22", (Object)45, true)})});
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseMetricFilters((String)expr), expectedList);
        expr = "   (  (     (        key11      ne     234    AND key12    gt   23    OR    key13    lt    24 OR key14 le 456   AND   key15   ge   2   )   AND ( key16 lt 34 OR key17 ge 567 )    )     OR (   key21 lt 24 OR key22 le 45 )   )    ";
        expectedList = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelineFilterList(TimelineFilterList.Operator.AND, new TimelineFilter[]{new TimelineFilterList(new TimelineFilter[]{new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelineFilterList(new TimelineFilter[]{new TimelineCompareFilter(TimelineCompareOp.NOT_EQUAL, "key11", (Object)234, false), new TimelineCompareFilter(TimelineCompareOp.GREATER_THAN, "key12", (Object)23, true)}), new TimelineCompareFilter(TimelineCompareOp.LESS_THAN, "key13", (Object)24, true), new TimelineCompareFilter(TimelineCompareOp.LESS_OR_EQUAL, "key14", (Object)456, true)}), new TimelineCompareFilter(TimelineCompareOp.GREATER_OR_EQUAL, "key15", (Object)2, true)}), new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelineCompareFilter(TimelineCompareOp.LESS_THAN, "key16", (Object)34, true), new TimelineCompareFilter(TimelineCompareOp.GREATER_OR_EQUAL, "key17", (Object)567, true)})}), new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelineCompareFilter(TimelineCompareOp.LESS_THAN, "key21", (Object)24, true), new TimelineCompareFilter(TimelineCompareOp.LESS_OR_EQUAL, "key22", (Object)45, true)})});
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseMetricFilters((String)expr), expectedList);
        expr = "(((key11 ne 234 AND key12 gt 23 OR key13 lt 24 OR key14 le 456 AND key15 ge 2) AND (key16 lt 34 OR key17 ge 567)) OR (key21 lt 24 OR key22 le 45)";
        try {
            TimelineReaderWebServicesUtils.parseMetricFilters((String)expr);
            Assert.fail((String)"Improper brackers. Exception should have been thrown.");
        }
        catch (TimelineParseException timelineParseException) {
            // empty catch block
        }
        expr = "(((key11 ne 234 AND key12 gt v3 OR key13 lt 24 OR key14 le 456 AND key15 ge 2) AND (key16 lt 34 OR key17 ge 567)) OR (key21 lt 24 OR key22 le 45))";
        try {
            TimelineReaderWebServicesUtils.parseMetricFilters((String)expr);
            Assert.fail((String)"Non Numeric value. Exception should have been thrown.");
        }
        catch (TimelineParseException timelineParseException) {
            // empty catch block
        }
        expr = "(((key11 ne (234 AND key12 gt 3 OR key13 lt 24 OR key14 le 456 AND key15 ge 2) AND (key16 lt 34 OR key17 ge 567)) OR (key21 lt 24 OR key22 le 45))";
        try {
            TimelineReaderWebServicesUtils.parseMetricFilters((String)expr);
            Assert.fail((String)"Unexpected opening bracket. Exception should have been thrown.");
        }
        catch (TimelineParseException timelineParseException) {
            // empty catch block
        }
        expr = "(((k)ey11 ne 234 AND key12 gt 3 OR key13 lt 24 OR key14 le 456 AND key15 ge 2) AND (key16 lt 34 OR key17 ge 567)) OR (key21 lt 24 OR key22 le 45))";
        try {
            TimelineReaderWebServicesUtils.parseMetricFilters((String)expr);
            Assert.fail((String)"Unexpected closing bracket. Exception should have been thrown.");
        }
        catch (TimelineParseException timelineParseException) {
            // empty catch block
        }
        expr = "(((key11 rs 234 AND key12 gt 3 OR key13 lt 24 OR key14 le 456 AND key15 ge 2) AND (key16 lt 34 OR key17 ge 567)) OR (key21 lt 24 OR key22 le 45))";
        try {
            TimelineReaderWebServicesUtils.parseMetricFilters((String)expr);
            Assert.fail((String)"Improper compare op. Exception should have been thrown.");
        }
        catch (TimelineParseException timelineParseException) {
            // empty catch block
        }
        expr = "(((key11 ne 234 PI key12 gt 3 OR key13 lt 24 OR key14 le 456 AND key15 ge 2) AND (key16 lt 34 OR key17 ge 567)) OR (key21 lt 24 OR key22 le 45))";
        try {
            TimelineReaderWebServicesUtils.parseMetricFilters((String)expr);
            Assert.fail((String)"Improper op. Exception should have been thrown.");
        }
        catch (TimelineParseException timelineParseException) {
            // empty catch block
        }
        expr = "(((key11 ne 234 PI key12 gt 3 OR key13 lt 24 OR key14 le 456 AND key15 ge 2) AND (key16 lt 34 OR key17 ge 567)) OR (key21 lt 24 OR key22 le 45))";
        try {
            TimelineReaderWebServicesUtils.parseMetricFilters((String)expr);
            Assert.fail((String)"Improper op. Exception should have been thrown.");
        }
        catch (TimelineParseException timelineParseException) {
            // empty catch block
        }
        expr = "(key11 ne 234 AND key12 gt 3)) OR (key13 lt 24 OR key14 le 456)";
        try {
            TimelineReaderWebServicesUtils.parseMetricFilters((String)expr);
            Assert.fail((String)"Unbalanced brackets. Exception should have been thrown.");
        }
        catch (TimelineParseException timelineParseException) {
            // empty catch block
        }
        expr = "(key11 rne 234 AND key12 gt 3) OR (key13 lt 24 OR key14 le 456)";
        try {
            TimelineReaderWebServicesUtils.parseMetricFilters((String)expr);
            Assert.fail((String)"Invalid compareop. Exception should have been thrown.");
        }
        catch (TimelineParseException timelineParseException) {
            // empty catch block
        }
        expr = "(key11 ne 234 AND key12 gt 3) OR (key13 lt 24 OR key14 le";
        try {
            TimelineReaderWebServicesUtils.parseMetricFilters((String)expr);
            Assert.fail((String)"Compareop cant be parsed. Exception should have been thrown.");
        }
        catch (TimelineParseException timelineParseException) {
            // empty catch block
        }
        Assert.assertNull((Object)TimelineReaderWebServicesUtils.parseMetricFilters(null));
        Assert.assertNull((Object)TimelineReaderWebServicesUtils.parseMetricFilters((String)"   "));
    }

    @Test
    public void testConfigFiltersParsing() throws Exception {
        String expr = "(((key11 ne 234 AND key12 eq val12) AND (key13 ene val13 OR key14 eq 567)) OR (key21 eq val_21 OR key22 eq val.22))";
        TimelineFilterList expectedList = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelineFilterList(TimelineFilterList.Operator.AND, new TimelineFilter[]{new TimelineFilterList(TimelineFilterList.Operator.AND, new TimelineFilter[]{new TimelineKeyValueFilter(TimelineCompareOp.NOT_EQUAL, "key11", (Object)"234", false), new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "key12", (Object)"val12", true)}), new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelineKeyValueFilter(TimelineCompareOp.NOT_EQUAL, "key13", (Object)"val13", true), new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "key14", (Object)"567", true)})}), new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "key21", (Object)"val_21", true), new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "key22", (Object)"val.22", true)})});
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseKVFilters((String)expr, (boolean)true), expectedList);
        expr = "abc ne 234 AND def eq 23 OR rst ene 24 OR xyz eq 456 AND pqr eq 2";
        expectedList = new TimelineFilterList(new TimelineFilter[]{new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelineFilterList(new TimelineFilter[]{new TimelineKeyValueFilter(TimelineCompareOp.NOT_EQUAL, "abc", (Object)"234", false), new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "def", (Object)"23", true)}), new TimelineKeyValueFilter(TimelineCompareOp.NOT_EQUAL, "rst", (Object)"24", true), new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "xyz", (Object)"456", true)}), new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "pqr", (Object)"2", true)});
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseKVFilters((String)expr, (boolean)true), expectedList);
        expr = "  abc ne   234       AND       def           eq 23 OR     rst ene            24     OR xyz     eq     456    AND pqr eq 2        ";
        expectedList = new TimelineFilterList(new TimelineFilter[]{new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelineFilterList(new TimelineFilter[]{new TimelineKeyValueFilter(TimelineCompareOp.NOT_EQUAL, "abc", (Object)"234", false), new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "def", (Object)"23", true)}), new TimelineKeyValueFilter(TimelineCompareOp.NOT_EQUAL, "rst", (Object)"24", true), new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "xyz", (Object)"456", true)}), new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "pqr", (Object)"2", true)});
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseKVFilters((String)expr, (boolean)true), expectedList);
        expr = "abc gt 234 AND def eq 23 OR rst ene 24 OR xyz eq 456 AND pqr eq 2";
        try {
            TimelineReaderWebServicesUtils.parseKVFilters((String)expr, (boolean)true);
            Assert.fail((String)"Invalid compareop specified for config filters. Should be either eq,ne or ene and exception should have been thrown.");
        }
        catch (TimelineParseException timelineParseException) {
            // empty catch block
        }
    }

    @Test
    public void testInfoFiltersParsing() throws Exception {
        String expr = "(((key11 ne 234 AND key12 eq val12) AND (key13 ene val13 OR key14 eq 567)) OR (key21 eq val_21 OR key22 eq 5.0))";
        TimelineFilterList expectedList = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelineFilterList(TimelineFilterList.Operator.AND, new TimelineFilter[]{new TimelineFilterList(TimelineFilterList.Operator.AND, new TimelineFilter[]{new TimelineKeyValueFilter(TimelineCompareOp.NOT_EQUAL, "key11", (Object)234, false), new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "key12", (Object)"val12", true)}), new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelineKeyValueFilter(TimelineCompareOp.NOT_EQUAL, "key13", (Object)"val13", true), new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "key14", (Object)567, true)})}), new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "key21", (Object)"val_21", true), new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "key22", (Object)5.0, true)})});
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseKVFilters((String)expr, (boolean)false), expectedList);
        expr = "abc ne 234 AND def eq 23 OR rst ene 24 OR xyz eq 456 AND pqr eq val.1234";
        expectedList = new TimelineFilterList(new TimelineFilter[]{new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelineFilterList(new TimelineFilter[]{new TimelineKeyValueFilter(TimelineCompareOp.NOT_EQUAL, "abc", (Object)234, false), new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "def", (Object)23, true)}), new TimelineKeyValueFilter(TimelineCompareOp.NOT_EQUAL, "rst", (Object)24, true), new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "xyz", (Object)456, true)}), new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "pqr", (Object)"val.1234", true)});
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseKVFilters((String)expr, (boolean)false), expectedList);
        expr = "  abc ne   234       AND       def           eq 23 OR     rst ene            24     OR xyz     eq     456    AND pqr eq 2        ";
        expectedList = new TimelineFilterList(new TimelineFilter[]{new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelineFilterList(new TimelineFilter[]{new TimelineKeyValueFilter(TimelineCompareOp.NOT_EQUAL, "abc", (Object)234, false), new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "def", (Object)23, true)}), new TimelineKeyValueFilter(TimelineCompareOp.NOT_EQUAL, "rst", (Object)24, true), new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "xyz", (Object)456, true)}), new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "pqr", (Object)2, true)});
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseKVFilters((String)expr, (boolean)false), expectedList);
        expr = "abdeq";
        try {
            TimelineReaderWebServicesUtils.parseKVFilters((String)expr, (boolean)false);
            Assert.fail((String)"Expression valuation should throw exception.");
        }
        catch (TimelineParseException timelineParseException) {
            // empty catch block
        }
        expr = "abc gt 234 AND defeq";
        try {
            TimelineReaderWebServicesUtils.parseKVFilters((String)expr, (boolean)false);
            Assert.fail((String)"Expression valuation should throw exception.");
        }
        catch (TimelineParseException timelineParseException) {
            // empty catch block
        }
        expr = "((key11 ne 234 AND key12 eq val12) AND (key13eq OR key14 eq va14))";
        try {
            TimelineReaderWebServicesUtils.parseKVFilters((String)expr, (boolean)false);
            Assert.fail((String)"Expression valuation should throw exception.");
        }
        catch (TimelineParseException timelineParseException) {
            // empty catch block
        }
    }

    @Test
    public void testEventFiltersParsing() throws Exception {
        String expr = "abc,def";
        TimelineFilterList expectedList = new TimelineFilterList(new TimelineFilter[]{new TimelineExistsFilter(TimelineCompareOp.EQUAL, "abc"), new TimelineExistsFilter(TimelineCompareOp.EQUAL, "def")});
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseEventFilters((String)expr), expectedList);
        expr = "(abc,def)";
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseEventFilters((String)expr), expectedList);
        expr = "(abc,def) OR (rst, uvx)";
        expectedList = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelineFilterList(new TimelineFilter[]{new TimelineExistsFilter(TimelineCompareOp.EQUAL, "abc"), new TimelineExistsFilter(TimelineCompareOp.EQUAL, "def")}), new TimelineFilterList(new TimelineFilter[]{new TimelineExistsFilter(TimelineCompareOp.EQUAL, "rst"), new TimelineExistsFilter(TimelineCompareOp.EQUAL, "uvx")})});
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseEventFilters((String)expr), expectedList);
        expr = "!(abc,def,uvc) OR (rst, uvx)";
        expectedList = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelineFilterList(new TimelineFilter[]{new TimelineExistsFilter(TimelineCompareOp.NOT_EQUAL, "abc"), new TimelineExistsFilter(TimelineCompareOp.NOT_EQUAL, "def"), new TimelineExistsFilter(TimelineCompareOp.NOT_EQUAL, "uvc")}), new TimelineFilterList(new TimelineFilter[]{new TimelineExistsFilter(TimelineCompareOp.EQUAL, "rst"), new TimelineExistsFilter(TimelineCompareOp.EQUAL, "uvx")})});
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseEventFilters((String)expr), expectedList);
        expr = "(((!(abc,def,uvc) OR (rst, uvx)) AND (!(abcdefg) OR !(ghj,tyu))) OR ((bcd,tyu) AND uvb))";
        expectedList = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelineFilterList(new TimelineFilter[]{new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelineFilterList(new TimelineFilter[]{new TimelineExistsFilter(TimelineCompareOp.NOT_EQUAL, "abc"), new TimelineExistsFilter(TimelineCompareOp.NOT_EQUAL, "def"), new TimelineExistsFilter(TimelineCompareOp.NOT_EQUAL, "uvc")}), new TimelineFilterList(new TimelineFilter[]{new TimelineExistsFilter(TimelineCompareOp.EQUAL, "rst"), new TimelineExistsFilter(TimelineCompareOp.EQUAL, "uvx")})}), new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelineFilterList(new TimelineFilter[]{new TimelineExistsFilter(TimelineCompareOp.NOT_EQUAL, "abcdefg")}), new TimelineFilterList(new TimelineFilter[]{new TimelineExistsFilter(TimelineCompareOp.NOT_EQUAL, "ghj"), new TimelineExistsFilter(TimelineCompareOp.NOT_EQUAL, "tyu")})})}), new TimelineFilterList(new TimelineFilter[]{new TimelineFilterList(new TimelineFilter[]{new TimelineExistsFilter(TimelineCompareOp.EQUAL, "bcd"), new TimelineExistsFilter(TimelineCompareOp.EQUAL, "tyu")}), new TimelineExistsFilter(TimelineCompareOp.EQUAL, "uvb")})});
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseEventFilters((String)expr), expectedList);
        expr = "  (  (  (  !  (  abc , def  ,   uvc)   OR   (   rst  ,   uvx )  )  AND   (  !  (  abcdefg ) OR  !   (  ghj,  tyu)  ) )  OR   (   (   bcd   ,   tyu  )   AND   uvb  )   )";
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseEventFilters((String)expr), expectedList);
        expr = "(((!(abc,def,uvc) OR (rst, uvx)) AND (!(abcdefg) OR !(ghj,tyu))) OR ((bcd,tyu) AND uvb)";
        try {
            TimelineReaderWebServicesUtils.parseEventFilters((String)expr);
            Assert.fail((String)"Improper brackets. Exception should have been thrown");
        }
        catch (TimelineParseException timelineParseException) {
            // empty catch block
        }
        expr = "(((!(abc,def,uvc) (OR (rst, uvx)) AND (!(abcdefg) OR !(ghj,tyu))) OR ((bcd,tyu) AND uvb))";
        try {
            TimelineReaderWebServicesUtils.parseEventFilters((String)expr);
            Assert.fail((String)"Unexpected opening bracket. Exception should have been thrown");
        }
        catch (TimelineParseException timelineParseException) {
            // empty catch block
        }
        expr = "(((!(abc,def,uvc) OR) (rst, uvx)) AND (!(abcdefg) OR !(ghj,tyu))) OR ((bcd,tyu) AND uvb))";
        try {
            TimelineReaderWebServicesUtils.parseEventFilters((String)expr);
            Assert.fail((String)"Unexpected closing bracket. Exception should have been thrown");
        }
        catch (TimelineParseException timelineParseException) {
            // empty catch block
        }
        expr = "(((!(abc,def,uvc) PI (rst, uvx)) AND (!(abcdefg) OR !(ghj,tyu))) OR ((bcd,tyu) AND uvb))";
        try {
            TimelineReaderWebServicesUtils.parseEventFilters((String)expr);
            Assert.fail((String)"Invalid op. Exception should have been thrown");
        }
        catch (TimelineParseException timelineParseException) {
            // empty catch block
        }
        expr = "(((!(abc,def,uvc) !OR (rst, uvx)) AND (!(abcdefg) OR !(ghj,tyu))) OR ((bcd,tyu) AND uvb))";
        try {
            TimelineReaderWebServicesUtils.parseEventFilters((String)expr);
            Assert.fail((String)"Unexpected ! char. Exception should have been thrown");
        }
        catch (TimelineParseException timelineParseException) {
            // empty catch block
        }
        expr = "abc,def,uvc) OR (rst, uvx)";
        try {
            TimelineReaderWebServicesUtils.parseEventFilters((String)expr);
            Assert.fail((String)"Unexpected closing bracket. Exception should have been thrown");
        }
        catch (TimelineParseException timelineParseException) {
            // empty catch block
        }
        expr = "abc,def,uvc OR )rst, uvx)";
        try {
            TimelineReaderWebServicesUtils.parseEventFilters((String)expr);
            Assert.fail((String)"Unexpected closing bracket. Exception should have been thrown");
        }
        catch (TimelineParseException timelineParseException) {
            // empty catch block
        }
        expr = "abc,def,uvc OR ,rst, uvx)";
        try {
            TimelineReaderWebServicesUtils.parseEventFilters((String)expr);
            Assert.fail((String)"Unexpected delimiter. Exception should have been thrown");
        }
        catch (TimelineParseException timelineParseException) {
            // empty catch block
        }
        expr = "abc,def,uvc OR !  ";
        try {
            TimelineReaderWebServicesUtils.parseEventFilters((String)expr);
            Assert.fail((String)"Unexpected not char. Exception should have been thrown");
        }
        catch (TimelineParseException timelineParseException) {
            // empty catch block
        }
        expr = "(abc,def,uvc)) OR (rst, uvx)";
        try {
            TimelineReaderWebServicesUtils.parseEventFilters((String)expr);
            Assert.fail((String)"Unbalanced brackets. Exception should have been thrown");
        }
        catch (TimelineParseException timelineParseException) {
            // empty catch block
        }
        expr = "(((! ,(abc,def,uvc) OR (rst, uvx)) AND (!(abcdefg) OR !(ghj,tyu))) OR ((bcd,tyu) AND uvb))";
        try {
            TimelineReaderWebServicesUtils.parseEventFilters((String)expr);
            Assert.fail((String)"( should follow ! char. Exception should have been thrown");
        }
        catch (TimelineParseException timelineParseException) {
            // empty catch block
        }
        Assert.assertNull((Object)TimelineReaderWebServicesUtils.parseEventFilters(null));
        Assert.assertNull((Object)TimelineReaderWebServicesUtils.parseEventFilters((String)"   "));
    }

    @Test
    public void testRelationFiltersParsing() throws Exception {
        String expr = "type1:entity11,type2:entity21:entity22";
        TimelineFilterList expectedList = new TimelineFilterList(new TimelineFilter[]{new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "type1", (Set)Sets.newHashSet((Object[])new Object[]{"entity11"})), new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "type2", (Set)Sets.newHashSet((Object[])new Object[]{"entity21", "entity22"}))});
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseRelationFilters((String)expr), expectedList);
        expr = "(type1:entity11,type2:entity21:entity22)";
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseRelationFilters((String)expr), expectedList);
        expr = "(type1:entity11,type2:entity21:entity22) OR (type3:entity31:entity32:entity33,type1:entity11:entity12)";
        expectedList = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelineFilterList(new TimelineFilter[]{new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "type1", (Set)Sets.newHashSet((Object[])new Object[]{"entity11"})), new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "type2", (Set)Sets.newHashSet((Object[])new Object[]{"entity21", "entity22"}))}), new TimelineFilterList(new TimelineFilter[]{new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "type3", (Set)Sets.newHashSet((Object[])new Object[]{"entity31", "entity32", "entity33"})), new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "type1", (Set)Sets.newHashSet((Object[])new Object[]{"entity11", "entity12"}))})});
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseRelationFilters((String)expr), expectedList);
        expr = "!(type1:entity11,type2:entity21:entity22,type5:entity51) OR (type3:entity31:entity32:entity33,type1:entity11:entity12)";
        expectedList = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelineFilterList(new TimelineFilter[]{new TimelineKeyValuesFilter(TimelineCompareOp.NOT_EQUAL, "type1", (Set)Sets.newHashSet((Object[])new Object[]{"entity11"})), new TimelineKeyValuesFilter(TimelineCompareOp.NOT_EQUAL, "type2", (Set)Sets.newHashSet((Object[])new Object[]{"entity21", "entity22"})), new TimelineKeyValuesFilter(TimelineCompareOp.NOT_EQUAL, "type5", (Set)Sets.newHashSet((Object[])new Object[]{"entity51"}))}), new TimelineFilterList(new TimelineFilter[]{new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "type3", (Set)Sets.newHashSet((Object[])new Object[]{"entity31", "entity32", "entity33"})), new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "type1", (Set)Sets.newHashSet((Object[])new Object[]{"entity11", "entity12"}))})});
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseRelationFilters((String)expr), expectedList);
        expr = "(((!(type1:entity11,type2:entity21:entity22,type5:entity51) OR (type3:entity31:entity32:entity33,type1:entity11:entity12)) AND (!(type11:entity111) OR !(type4:entity43:entity44:entity47:entity49,type7:entity71))) OR ((type2:entity2,type8:entity88) AND t9:e:e1))";
        expectedList = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelineFilterList(new TimelineFilter[]{new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelineFilterList(new TimelineFilter[]{new TimelineKeyValuesFilter(TimelineCompareOp.NOT_EQUAL, "type1", (Set)Sets.newHashSet((Object[])new Object[]{"entity11"})), new TimelineKeyValuesFilter(TimelineCompareOp.NOT_EQUAL, "type2", (Set)Sets.newHashSet((Object[])new Object[]{"entity21", "entity22"})), new TimelineKeyValuesFilter(TimelineCompareOp.NOT_EQUAL, "type5", (Set)Sets.newHashSet((Object[])new Object[]{"entity51"}))}), new TimelineFilterList(new TimelineFilter[]{new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "type3", (Set)Sets.newHashSet((Object[])new Object[]{"entity31", "entity32", "entity33"})), new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "type1", (Set)Sets.newHashSet((Object[])new Object[]{"entity11", "entity12"}))})}), new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelineFilterList(new TimelineFilter[]{new TimelineKeyValuesFilter(TimelineCompareOp.NOT_EQUAL, "type11", (Set)Sets.newHashSet((Object[])new Object[]{"entity111"}))}), new TimelineFilterList(new TimelineFilter[]{new TimelineKeyValuesFilter(TimelineCompareOp.NOT_EQUAL, "type4", (Set)Sets.newHashSet((Object[])new Object[]{"entity43", "entity44", "entity47", "entity49"})), new TimelineKeyValuesFilter(TimelineCompareOp.NOT_EQUAL, "type7", (Set)Sets.newHashSet((Object[])new Object[]{"entity71"}))})})}), new TimelineFilterList(new TimelineFilter[]{new TimelineFilterList(new TimelineFilter[]{new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "type2", (Set)Sets.newHashSet((Object[])new Object[]{"entity2"})), new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "type8", (Set)Sets.newHashSet((Object[])new Object[]{"entity88"}))}), new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "t9", (Set)Sets.newHashSet((Object[])new Object[]{"e", "e1"}))})});
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseRelationFilters((String)expr), expectedList);
        expr = "   (   (  (   !   (   type1:entity11  ,  type2:entity21:entity22  ,  type5:entity51  )   OR  (   type3:entity31:entity32:entity33       ,   type1:entity11:entity12)) AND (!(  type11:entity111  )  OR     !   (   type4:entity43:entity44:entity47:entity49 , type7:entity71  )  )  ) OR  (  (  type2:entity2 , type8:entity88) AND  t9:e:e1 )    ) ";
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseRelationFilters((String)expr), expectedList);
        expr = "(((!(type1 : entity11,type2:entity21:entity22,type5:entity51) OR (type3:entity31:entity32:entity33,type1:entity11:entity12)) AND (!(type11:entity111) OR !(type4:entity43:entity44:entity47:entity49,type7:entity71))) OR ((type2:entity2,type8:entity88) AND t9:e:e1))";
        try {
            TimelineReaderWebServicesUtils.parseRelationFilters((String)expr);
            Assert.fail((String)"Space not allowed in relation expression. Exception should have been thrown");
        }
        catch (TimelineParseException timelineParseException) {
            // empty catch block
        }
    }

    @Test
    public void testDataToRetrieve() throws Exception {
        String expr = "abc,def";
        TimelineFilterList expectedList = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelinePrefixFilter(TimelineCompareOp.EQUAL, "abc"), new TimelinePrefixFilter(TimelineCompareOp.EQUAL, "def")});
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseDataToRetrieve((String)expr), expectedList);
        expr = "(abc,def)";
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseDataToRetrieve((String)expr), expectedList);
        expr = "   (   abc  ,   def  )   ";
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseDataToRetrieve((String)expr), expectedList);
        expr = "    abc  ,   def   ";
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseDataToRetrieve((String)expr), expectedList);
        expr = "!(abc,def)";
        expectedList = new TimelineFilterList(new TimelineFilter[]{new TimelinePrefixFilter(TimelineCompareOp.NOT_EQUAL, "abc"), new TimelinePrefixFilter(TimelineCompareOp.NOT_EQUAL, "def")});
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseDataToRetrieve((String)expr), expectedList);
        expr = " !  (   abc  ,  def  )  ";
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseDataToRetrieve((String)expr), expectedList);
        expr = "!(abc)";
        expectedList = new TimelineFilterList(new TimelineFilter[]{new TimelinePrefixFilter(TimelineCompareOp.NOT_EQUAL, "abc")});
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseDataToRetrieve((String)expr), expectedList);
        expr = "(abc)";
        expectedList = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelinePrefixFilter(TimelineCompareOp.EQUAL, "abc")});
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseDataToRetrieve((String)expr), expectedList);
        expr = "abc";
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseDataToRetrieve((String)expr), expectedList);
        expr = " !  (   abc  ,  def  , xyz)  ";
        expectedList = new TimelineFilterList(new TimelineFilter[]{new TimelinePrefixFilter(TimelineCompareOp.NOT_EQUAL, "abc"), new TimelinePrefixFilter(TimelineCompareOp.NOT_EQUAL, "def"), new TimelinePrefixFilter(TimelineCompareOp.NOT_EQUAL, "xyz")});
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseDataToRetrieve((String)expr), expectedList);
        expr = "!(abc,def,xyz)";
        TestTimelineReaderWebServicesUtils.verifyFilterList(expr, TimelineReaderWebServicesUtils.parseDataToRetrieve((String)expr), expectedList);
        expr = "!(abc,def,xyz";
        try {
            TimelineReaderWebServicesUtils.parseDataToRetrieve((String)expr);
            Assert.fail((String)"No closing bracket. Exception should have been thrown");
        }
        catch (TimelineParseException timelineParseException) {
            // empty catch block
        }
        expr = "!abc,def,xyz";
        try {
            TimelineReaderWebServicesUtils.parseDataToRetrieve((String)expr);
            Assert.fail((String)"NOT(!) should be followed by opening bracket. Exception should have been thrown");
        }
        catch (TimelineParseException timelineParseException) {
            // empty catch block
        }
        expr = "!abc,def,xyz";
        try {
            TimelineReaderWebServicesUtils.parseDataToRetrieve((String)expr);
            Assert.fail((String)"NOT(!) should be followed by opening bracket. Exception should have been thrown");
        }
        catch (TimelineParseException timelineParseException) {
            // empty catch block
        }
        expr = "!   r(  abc,def,xyz)";
        try {
            TimelineReaderWebServicesUtils.parseDataToRetrieve((String)expr);
            Assert.fail((String)"NOT(!) should be followed by opening bracket. Exception should have been thrown");
        }
        catch (TimelineParseException timelineParseException) {
            // empty catch block
        }
        Assert.assertNull((Object)TimelineReaderWebServicesUtils.parseDataToRetrieve(null));
        Assert.assertNull((Object)TimelineReaderWebServicesUtils.parseDataToRetrieve((String)"     "));
        Assert.assertNull((Object)TimelineReaderWebServicesUtils.parseDataToRetrieve((String)"()"));
        Assert.assertNull((Object)TimelineReaderWebServicesUtils.parseDataToRetrieve((String)"!()"));
        Assert.assertNull((Object)TimelineReaderWebServicesUtils.parseDataToRetrieve((String)"(     )"));
        Assert.assertNull((Object)TimelineReaderWebServicesUtils.parseDataToRetrieve((String)"!(   )"));
        Assert.assertNull((Object)TimelineReaderWebServicesUtils.parseDataToRetrieve((String)"!  (   )"));
    }
}

