/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader.filter;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineCompareOp;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilter;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TimelinePrefixFilter
extends TimelineFilter {
    private TimelineCompareOp compareOp;
    private String prefix;

    public TimelinePrefixFilter() {
    }

    public TimelinePrefixFilter(TimelineCompareOp op, String prefix) {
        this.prefix = prefix;
        if (op != TimelineCompareOp.EQUAL && op != TimelineCompareOp.NOT_EQUAL) {
            throw new IllegalArgumentException("CompareOp for prefix filter should be EQUAL or NOT_EQUAL");
        }
        this.compareOp = op;
    }

    @Override
    public TimelineFilter.TimelineFilterType getFilterType() {
        return TimelineFilter.TimelineFilterType.PREFIX;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public TimelineCompareOp getCompareOp() {
        return this.compareOp;
    }

    @Override
    public String toString() {
        return String.format("%s (%s %s)", this.getClass().getSimpleName(), this.compareOp.name(), this.prefix);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.compareOp == null ? 0 : this.compareOp.hashCode());
        result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimelinePrefixFilter other = (TimelinePrefixFilter)obj;
        if (this.compareOp != other.compareOp) {
            return false;
        }
        return !(this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix));
    }
}

