/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.classification.tools;

import com.sun.javadoc.DocErrorReporter;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.hadoop.hbase.classification.tools.RootDocProcessor;

final class StabilityOptions {
    public static final String STABLE_OPTION = "-stable";
    public static final String EVOLVING_OPTION = "-evolving";
    public static final String UNSTABLE_OPTION = "-unstable";

    private StabilityOptions() {
    }

    public static Integer optionLength(String option) {
        String opt = option.toLowerCase(Locale.ROOT);
        if (opt.equals(UNSTABLE_OPTION)) {
            return 1;
        }
        if (opt.equals(EVOLVING_OPTION)) {
            return 1;
        }
        if (opt.equals(STABLE_OPTION)) {
            return 1;
        }
        return null;
    }

    public static void validOptions(String[][] options, DocErrorReporter reporter) {
        block10: for (String[] option : options) {
            String opt;
            switch (opt = option[0].toLowerCase(Locale.ROOT)) {
                case "-unstable": {
                    RootDocProcessor.stability = UNSTABLE_OPTION;
                    continue block10;
                }
                case "-evolving": {
                    RootDocProcessor.stability = EVOLVING_OPTION;
                    continue block10;
                }
                case "-stable": {
                    RootDocProcessor.stability = STABLE_OPTION;
                    continue block10;
                }
                default: {
                    RootDocProcessor.stability = UNSTABLE_OPTION;
                }
            }
        }
    }

    public static String[][] filterOptions(String[][] options) {
        ArrayList<String[]> optionsList = new ArrayList<String[]>();
        for (String[] option : options) {
            if (option[0].equalsIgnoreCase(UNSTABLE_OPTION) || option[0].equalsIgnoreCase(EVOLVING_OPTION) || option[0].equalsIgnoreCase(STABLE_OPTION)) continue;
            optionsList.add(option);
        }
        String[][] filteredOptions = new String[optionsList.size()][];
        int i = 0;
        for (String[] option : optionsList) {
            filteredOptions[i++] = option;
        }
        return filteredOptions;
    }
}

