/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseCommonTestingUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.http.ssl.KeyStoreTestUtil;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hbase.thirdparty.com.google.common.base.Strings;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class HBaseKerberosUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseKerberosUtils.class);
    public static final String KRB_PRINCIPAL = "hbase.regionserver.kerberos.principal";
    public static final String MASTER_KRB_PRINCIPAL = "hbase.master.kerberos.principal";
    public static final String KRB_KEYTAB_FILE = "hbase.regionserver.keytab.file";
    public static final String CLIENT_PRINCIPAL = "hbase.client.keytab.principal";
    public static final String CLIENT_KEYTAB = "hbase.client.keytab.file";

    private HBaseKerberosUtils() {
    }

    public static boolean isKerberosPropertySetted() {
        String krbPrincipal = System.getProperty(KRB_PRINCIPAL);
        String krbKeytab = System.getProperty(KRB_KEYTAB_FILE);
        return !Strings.isNullOrEmpty((String)krbPrincipal) && !Strings.isNullOrEmpty((String)krbKeytab);
    }

    public static void setPrincipalForTesting(String principal) {
        HBaseKerberosUtils.setSystemProperty(KRB_PRINCIPAL, principal);
    }

    public static void setKeytabFileForTesting(String keytabFile) {
        HBaseKerberosUtils.setSystemProperty(KRB_KEYTAB_FILE, keytabFile);
    }

    public static void setClientPrincipalForTesting(String clientPrincipal) {
        HBaseKerberosUtils.setSystemProperty(CLIENT_PRINCIPAL, clientPrincipal);
    }

    public static void setClientKeytabForTesting(String clientKeytab) {
        HBaseKerberosUtils.setSystemProperty(CLIENT_KEYTAB, clientKeytab);
    }

    public static void setSystemProperty(String propertyName, String propertyValue) {
        System.setProperty(propertyName, propertyValue);
    }

    public static String getKeytabFileForTesting() {
        return System.getProperty(KRB_KEYTAB_FILE);
    }

    public static String getPrincipalForTesting() {
        return System.getProperty(KRB_PRINCIPAL);
    }

    public static String getClientPrincipalForTesting() {
        return System.getProperty(CLIENT_PRINCIPAL);
    }

    public static String getClientKeytabForTesting() {
        return System.getProperty(CLIENT_KEYTAB);
    }

    public static Configuration getConfigurationWoPrincipal() {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hadoop.security.authentication", "kerberos");
        conf.set("hbase.security.authentication", "kerberos");
        conf.setBoolean("hbase.security.authorization", true);
        return conf;
    }

    public static Configuration getSecuredConfiguration() {
        Configuration conf = HBaseConfiguration.create();
        HBaseKerberosUtils.setSecuredConfiguration(conf);
        return conf;
    }

    public static void setSecuredConfiguration(Configuration conf, String servicePrincipal, String spnegoPrincipal) {
        HBaseKerberosUtils.setPrincipalForTesting(servicePrincipal);
        HBaseKerberosUtils.setSecuredConfiguration(conf);
        HBaseKerberosUtils.setSecuredHadoopConfiguration(conf, spnegoPrincipal);
    }

    public static void setSecuredConfiguration(Configuration conf) {
        conf.set("hadoop.security.authentication", "kerberos");
        conf.set("hbase.security.authentication", "kerberos");
        conf.setBoolean("hbase.security.authorization", true);
        conf.set(KRB_KEYTAB_FILE, System.getProperty(KRB_KEYTAB_FILE));
        conf.set(KRB_PRINCIPAL, System.getProperty(KRB_PRINCIPAL));
        conf.set(MASTER_KRB_PRINCIPAL, System.getProperty(KRB_PRINCIPAL));
    }

    private static void setSecuredHadoopConfiguration(Configuration conf, String spnegoServerPrincipal) {
        String serverPrincipal = System.getProperty(KRB_PRINCIPAL);
        String keytabFilePath = System.getProperty(KRB_KEYTAB_FILE);
        conf.set("dfs.namenode.kerberos.principal", serverPrincipal);
        conf.set("dfs.namenode.keytab.file", keytabFilePath);
        conf.set("dfs.datanode.kerberos.principal", serverPrincipal);
        conf.set("dfs.datanode.keytab.file", keytabFilePath);
        conf.setBoolean("dfs.block.access.token.enable", true);
        conf.set("yarn.resourcemanager.principal", KRB_PRINCIPAL);
        conf.set("yarn.nodemanager.principal", KRB_PRINCIPAL);
        if (spnegoServerPrincipal != null) {
            conf.set("dfs.web.authentication.kerberos.principal", spnegoServerPrincipal);
        }
        conf.setBoolean("ignore.secure.ports.for.testing", true);
        UserGroupInformation.setConfiguration((Configuration)conf);
    }

    public static void setSSLConfiguration(HBaseCommonTestingUtil utility, Class<?> clazz) throws Exception {
        Configuration conf = utility.getConfiguration();
        conf.set("dfs.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
        conf.set("dfs.namenode.https-address", "localhost:0");
        conf.set("dfs.datanode.https.address", "localhost:0");
        File keystoresDir = new File(utility.getDataTestDir("keystore").toUri().getPath());
        keystoresDir.mkdirs();
        String sslConfDir = KeyStoreTestUtil.getClasspathDir(clazz);
        KeyStoreTestUtil.setupSSLConfig((String)keystoresDir.getAbsolutePath(), (String)sslConfDir, (Configuration)conf, (boolean)false);
    }

    public static UserGroupInformation loginAndReturnUGI(Configuration conf, String username) throws IOException {
        String hostname = InetAddress.getLocalHost().getHostName();
        String keyTabFileConfKey = "hbase." + username + ".keytab.file";
        String keyTabFileLocation = conf.get(keyTabFileConfKey);
        String principalConfKey = "hbase." + username + ".kerberos.principal";
        String principal = SecurityUtil.getServerPrincipal((String)conf.get(principalConfKey), (String)hostname);
        if (keyTabFileLocation == null || principal == null) {
            LOG.warn("Principal or key tab file null for : " + principalConfKey + ", " + keyTabFileConfKey);
        }
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)principal, (String)keyTabFileLocation);
        return ugi;
    }

    public static UserGroupInformation loginKerberosPrincipal(String krbKeytab, String krbPrincipal) throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        UserGroupInformation.loginUserFromKeytab((String)krbPrincipal, (String)krbKeytab);
        return UserGroupInformation.getLoginUser();
    }
}

