/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BalancerDecision;
import org.apache.hadoop.hbase.client.BalancerRejection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.conf.ConfigurationObserver;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public interface ClusterInfoProvider
extends ConfigurationObserver {
    public Configuration getConfiguration();

    public Connection getConnection();

    public List<RegionInfo> getAssignedRegions();

    public void unassign(RegionInfo var1) throws IOException;

    public TableDescriptor getTableDescriptor(TableName var1) throws IOException;

    public int getNumberOfTables() throws IOException;

    public HDFSBlocksDistribution computeHDFSBlocksDistribution(Configuration var1, TableDescriptor var2, RegionInfo var3) throws IOException;

    public boolean hasRegionReplica(Collection<RegionInfo> var1) throws IOException;

    public List<ServerName> getOnlineServersList();

    public List<ServerName> getOnlineServersListWithPredicator(List<ServerName> var1, Predicate<ServerMetrics> var2);

    public Map<ServerName, List<RegionInfo>> getSnapShotOfAssignment(Collection<RegionInfo> var1);

    public boolean isOffPeakHour();

    public void recordBalancerDecision(Supplier<BalancerDecision> var1);

    public void recordBalancerRejection(Supplier<BalancerRejection> var1);

    public ServerMetrics getLoad(ServerName var1);
}

