/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.WrongRowIOException;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Delete
extends Mutation
implements Comparable<Row> {
    public Delete(byte[] row) {
        this(row, Long.MAX_VALUE);
    }

    public Delete(byte[] row, long timestamp) {
        this(row, 0, row.length, timestamp);
    }

    public Delete(byte[] rowArray, int rowOffset, int rowLength, long ts) {
        Delete.checkRow(rowArray, rowOffset, rowLength);
        this.row = Bytes.copy((byte[])rowArray, (int)rowOffset, (int)rowLength);
        this.ts = ts;
    }

    public Delete(Delete d) {
        this.row = d.getRow();
        this.ts = d.getTimeStamp();
        this.familyMap.putAll(d.getFamilyMap());
        this.writeToWAL = d.writeToWAL;
    }

    public Delete addDeleteMarker(KeyValue kv) throws IOException {
        if (!kv.isDelete()) {
            throw new IOException("The recently added KeyValue is not of type delete. Rowkey: " + Bytes.toStringBinary((byte[])this.row));
        }
        if (Bytes.compareTo((byte[])this.row, (int)0, (int)this.row.length, (byte[])kv.getBuffer(), (int)kv.getRowOffset(), (int)kv.getRowLength()) != 0) {
            throw new WrongRowIOException("The row in " + kv.toString() + " doesn't match the original one " + Bytes.toStringBinary((byte[])this.row));
        }
        byte[] family = kv.getFamily();
        ArrayList<KeyValue> list = (ArrayList<KeyValue>)this.familyMap.get(family);
        if (list == null) {
            list = new ArrayList<KeyValue>();
        }
        list.add(kv);
        this.familyMap.put(family, list);
        return this;
    }

    public Delete deleteFamily(byte[] family) {
        this.deleteFamily(family, Long.MAX_VALUE);
        return this;
    }

    public Delete deleteFamily(byte[] family, long timestamp) {
        ArrayList<KeyValue> list = (ArrayList<KeyValue>)this.familyMap.get(family);
        if (list == null) {
            list = new ArrayList<KeyValue>();
        } else if (!list.isEmpty()) {
            list.clear();
        }
        KeyValue kv = new KeyValue(this.row, family, null, timestamp, KeyValue.Type.DeleteFamily);
        list.add(kv);
        this.familyMap.put(family, list);
        return this;
    }

    public Delete deleteColumns(byte[] family, byte[] qualifier) {
        this.deleteColumns(family, qualifier, Long.MAX_VALUE);
        return this;
    }

    public Delete deleteColumns(byte[] family, byte[] qualifier, long timestamp) {
        ArrayList<KeyValue> list = (ArrayList<KeyValue>)this.familyMap.get(family);
        if (list == null) {
            list = new ArrayList<KeyValue>();
        }
        list.add(new KeyValue(this.row, family, qualifier, timestamp, KeyValue.Type.DeleteColumn));
        this.familyMap.put(family, list);
        return this;
    }

    public Delete deleteColumn(byte[] family, byte[] qualifier) {
        this.deleteColumn(family, qualifier, Long.MAX_VALUE);
        return this;
    }

    public Delete deleteColumn(byte[] family, byte[] qualifier, long timestamp) {
        ArrayList<KeyValue> list = (ArrayList<KeyValue>)this.familyMap.get(family);
        if (list == null) {
            list = new ArrayList<KeyValue>();
        }
        KeyValue kv = new KeyValue(this.row, family, qualifier, timestamp, KeyValue.Type.Delete);
        list.add(kv);
        this.familyMap.put(family, list);
        return this;
    }

    public void setTimestamp(long timestamp) {
        this.ts = timestamp;
    }

    @Override
    public Map<String, Object> toMap(int maxCols) {
        Map<String, Object> map = super.toMap(maxCols);
        map.put("ts", this.ts);
        return map;
    }
}

