/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.ServiceException;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Chore;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.IpcProtocol;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MasterAdminProtocol;
import org.apache.hadoop.hbase.MasterMonitorProtocol;
import org.apache.hadoop.hbase.MasterProtocol;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.Action;
import org.apache.hadoop.hbase.client.AdminProtocol;
import org.apache.hadoop.hbase.client.ClientProtocol;
import org.apache.hadoop.hbase.client.ClusterStatusListener;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.MasterAdminKeepAliveConnection;
import org.apache.hadoop.hbase.client.MasterMonitorKeepAliveConnection;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.MultiAction;
import org.apache.hadoop.hbase.client.MultiResponse;
import org.apache.hadoop.hbase.client.MultiServerCallable;
import org.apache.hadoop.hbase.client.NoServerForRegionException;
import org.apache.hadoop.hbase.client.RegionOfflineException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.ServerCallable;
import org.apache.hadoop.hbase.client.ZooKeeperKeepAliveConnection;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.exceptions.DoNotRetryIOException;
import org.apache.hadoop.hbase.exceptions.MasterNotRunningException;
import org.apache.hadoop.hbase.exceptions.RegionMovedException;
import org.apache.hadoop.hbase.exceptions.RegionOpeningException;
import org.apache.hadoop.hbase.exceptions.RegionServerStoppedException;
import org.apache.hadoop.hbase.exceptions.TableNotFoundException;
import org.apache.hadoop.hbase.exceptions.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.ipc.HBaseClientRPC;
import org.apache.hadoop.hbase.ipc.ProtobufRpcClientEngine;
import org.apache.hadoop.hbase.ipc.RpcClientEngine;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterMonitorProtos;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Addressing;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.SoftValueSortedMap;
import org.apache.hadoop.hbase.util.Triple;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hadoop.hbase.zookeeper.MetaRegionTracker;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.hadoop.hbase.zookeeper.ZKTableReadOnly;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HConnectionManager {
    static final Map<HConnectionKey, HConnectionImplementation> HBASE_INSTANCES;
    public static final int MAX_CACHED_HBASE_INSTANCES;
    public static final String CLIENT_PROTOCOL_CLASS = "hbase.clientprotocol.class";
    public static final String DEFAULT_CLIENT_PROTOCOL_CLASS;
    public static final String REGION_PROTOCOL_CLASS = "hbase.adminprotocol.class";
    public static final String DEFAULT_ADMIN_PROTOCOL_CLASS;
    private static final Log LOG;

    protected HConnectionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HConnection getConnection(Configuration conf) throws IOException {
        HConnectionKey connectionKey = new HConnectionKey(conf);
        Map<HConnectionKey, HConnectionImplementation> map = HBASE_INSTANCES;
        synchronized (map) {
            HConnectionImplementation connection = HBASE_INSTANCES.get(connectionKey);
            if (connection == null) {
                connection = new HConnectionImplementation(conf, true);
                HBASE_INSTANCES.put(connectionKey, connection);
            } else if (connection.isClosed()) {
                HConnectionManager.deleteConnection(connectionKey, true);
                connection = new HConnectionImplementation(conf, true);
                HBASE_INSTANCES.put(connectionKey, connection);
            }
            connection.incCount();
            return connection;
        }
    }

    public static HConnection createConnection(Configuration conf) throws IOException {
        return new HConnectionImplementation(conf, false);
    }

    public static void deleteConnection(Configuration conf) {
        HConnectionManager.deleteConnection(new HConnectionKey(conf), false);
    }

    public static void deleteStaleConnection(HConnection connection) {
        HConnectionManager.deleteConnection(connection, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllConnections() {
        Map<HConnectionKey, HConnectionImplementation> map = HBASE_INSTANCES;
        synchronized (map) {
            HashSet<HConnectionKey> connectionKeys = new HashSet<HConnectionKey>();
            connectionKeys.addAll(HBASE_INSTANCES.keySet());
            for (HConnectionKey connectionKey : connectionKeys) {
                HConnectionManager.deleteConnection(connectionKey, false);
            }
            HBASE_INSTANCES.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteConnection(HConnection connection, boolean staleConnection) {
        Map<HConnectionKey, HConnectionImplementation> map = HBASE_INSTANCES;
        synchronized (map) {
            for (Map.Entry<HConnectionKey, HConnectionImplementation> connectionEntry : HBASE_INSTANCES.entrySet()) {
                if (connectionEntry.getValue() != connection) continue;
                HConnectionManager.deleteConnection(connectionEntry.getKey(), staleConnection);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteConnection(HConnectionKey connectionKey, boolean staleConnection) {
        Map<HConnectionKey, HConnectionImplementation> map = HBASE_INSTANCES;
        synchronized (map) {
            HConnectionImplementation connection = HBASE_INSTANCES.get(connectionKey);
            if (connection != null) {
                connection.decCount();
                if (connection.isZeroReference() || staleConnection) {
                    HBASE_INSTANCES.remove(connectionKey);
                    connection.internalClose();
                }
            } else {
                LOG.error((Object)("Connection not found in the list, can't delete it (connection key=" + connectionKey + "). May be the key was modified?"));
            }
        }
    }

    static int getCachedRegionCount(Configuration conf, final byte[] tableName) throws IOException {
        return HConnectionManager.execute(new HConnectable<Integer>(conf){

            @Override
            public Integer connect(HConnection connection) {
                return ((HConnectionImplementation)connection).getNumberOfCachedRegionLocations(tableName);
            }
        });
    }

    static boolean isRegionCached(Configuration conf, final byte[] tableName, final byte[] row) throws IOException {
        return HConnectionManager.execute(new HConnectable<Boolean>(conf){

            @Override
            public Boolean connect(HConnection connection) {
                return ((HConnectionImplementation)connection).isRegionCached(tableName, row);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T execute(HConnectable<T> connectable) throws IOException {
        if (connectable == null || connectable.conf == null) {
            return null;
        }
        Configuration conf = connectable.conf;
        HConnection connection = HConnectionManager.getConnection(conf);
        boolean connectSucceeded = false;
        try {
            T returnValue = connectable.connect(connection);
            connectSucceeded = true;
            T t = returnValue;
            return t;
        }
        finally {
            block8: {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    if (!connectSucceeded) break block8;
                    throw new IOException("The connection to " + connection + " could not be deleted.", e);
                }
            }
        }
    }

    public static void setServerSideHConnectionRetries(Configuration c, Log log) {
        int hcRetries = c.getInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, HConstants.DEFAULT_HBASE_CLIENT_RETRIES_NUMBER);
        int serversideMultiplier = c.getInt("hbase.client.serverside.retries.multiplier", 10);
        int retries = hcRetries * serversideMultiplier;
        c.setInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, retries);
        log.debug((Object)("HConnection retries=" + retries));
    }

    static {
        DEFAULT_CLIENT_PROTOCOL_CLASS = ClientProtocol.class.getName();
        DEFAULT_ADMIN_PROTOCOL_CLASS = AdminProtocol.class.getName();
        LOG = LogFactory.getLog(HConnectionManager.class);
        MAX_CACHED_HBASE_INSTANCES = HBaseConfiguration.create().getInt("hbase.zookeeper.property.maxClientCnxns", 300) + 1;
        HBASE_INSTANCES = new LinkedHashMap<HConnectionKey, HConnectionImplementation>((int)((float)MAX_CACHED_HBASE_INSTANCES / 0.75f) + 1, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<HConnectionKey, HConnectionImplementation> eldest) {
                return this.size() > MAX_CACHED_HBASE_INSTANCES;
            }
        };
    }

    static class HConnectionImplementation
    implements HConnection,
    Closeable {
        static final Log LOG = LogFactory.getLog(HConnectionImplementation.class);
        private final Class<? extends AdminProtocol> adminClass;
        private final Class<? extends ClientProtocol> clientClass;
        private final long pause;
        private final int numRetries;
        private final int maxRPCAttempts;
        private final int rpcTimeout;
        private final int prefetchRegionLimit;
        private volatile boolean closed;
        private volatile boolean aborted;
        ClusterStatusListener clusterStatusListener;
        private final Object userRegionLock = new Object();
        private final Object masterAndZKLock = new Object();
        private long keepZooKeeperWatcherAliveUntil = Long.MAX_VALUE;
        private final DelayedClosing delayedClosing = DelayedClosing.createAndStart(this);
        private final Configuration conf;
        private RpcClientEngine rpcEngine;
        private final ConcurrentHashMap<String, Map<String, IpcProtocol>> servers = new ConcurrentHashMap();
        private final ConcurrentHashMap<String, String> connectionLock = new ConcurrentHashMap();
        private final Map<Integer, SoftValueSortedMap<byte[], HRegionLocation>> cachedRegionLocations = new HashMap<Integer, SoftValueSortedMap<byte[], HRegionLocation>>();
        private final Set<ServerName> cachedServers = new HashSet<ServerName>();
        private final Set<Integer> regionCachePrefetchDisabledTables = new CopyOnWriteArraySet<Integer>();
        private int refCount;
        private final boolean managed;
        private String clusterId = null;
        private ZooKeeperKeepAliveConnection keepAliveZookeeper;
        private int keepAliveZookeeperUserCount;
        private boolean canCloseZKW = true;
        private static final long keepAlive = 300000L;
        MasterProtocolState masterAdminProtocol = new MasterProtocolState(MasterAdminProtocol.class);
        MasterProtocolState masterMonitorProtocol = new MasterProtocolState(MasterMonitorProtocol.class);

        public HConnectionImplementation(Configuration conf, boolean managed) throws IOException {
            this.conf = conf;
            this.managed = managed;
            String adminClassName = conf.get(HConnectionManager.REGION_PROTOCOL_CLASS, DEFAULT_ADMIN_PROTOCOL_CLASS);
            this.closed = false;
            try {
                this.adminClass = Class.forName(adminClassName);
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException("Unable to find region server interface " + adminClassName, e);
            }
            String clientClassName = conf.get(HConnectionManager.CLIENT_PROTOCOL_CLASS, DEFAULT_CLIENT_PROTOCOL_CLASS);
            try {
                this.clientClass = Class.forName(clientClassName);
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException("Unable to find client protocol " + clientClassName, e);
            }
            this.pause = conf.getLong(HConstants.HBASE_CLIENT_PAUSE, HConstants.DEFAULT_HBASE_CLIENT_PAUSE);
            this.numRetries = conf.getInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, HConstants.DEFAULT_HBASE_CLIENT_RETRIES_NUMBER);
            this.maxRPCAttempts = conf.getInt(HConstants.HBASE_CLIENT_RPC_MAXATTEMPTS, HConstants.DEFAULT_HBASE_CLIENT_RPC_MAXATTEMPTS);
            this.rpcTimeout = conf.getInt(HConstants.HBASE_RPC_TIMEOUT_KEY, HConstants.DEFAULT_HBASE_RPC_TIMEOUT);
            this.prefetchRegionLimit = conf.getInt(HConstants.HBASE_CLIENT_PREFETCH_LIMIT, HConstants.DEFAULT_HBASE_CLIENT_PREFETCH_LIMIT);
            this.retrieveClusterId();
            this.rpcEngine = new ProtobufRpcClientEngine(this.conf, this.clusterId);
            Class listenerClass = conf.getClass("hbase.status.listener.class", ClusterStatusListener.DEFAULT_STATUS_LISTENER_CLASS, ClusterStatusListener.Listener.class);
            if (listenerClass != null) {
                this.clusterStatusListener = new ClusterStatusListener(new ClusterStatusListener.DeadServerHandler(){

                    @Override
                    public void newDead(ServerName sn) {
                        HConnectionImplementation.this.clearCaches(sn);
                        HConnectionImplementation.this.rpcEngine.getClient().cancelConnections(sn.getHostname(), sn.getPort(), null);
                    }
                }, conf, listenerClass);
            }
        }

        public String toString() {
            return "hconnection-0x" + Integer.toHexString(this.hashCode());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void retrieveClusterId() {
            if (this.clusterId != null) {
                return;
            }
            ZooKeeperKeepAliveConnection zkw = null;
            try {
                zkw = this.getKeepAliveZooKeeperWatcher();
                this.clusterId = ZKClusterId.readClusterIdZNode(zkw);
                if (this.clusterId == null) {
                    LOG.info((Object)"ClusterId read in ZooKeeper is null");
                }
            }
            catch (KeeperException e) {
                LOG.warn((Object)"Can't retrieve clusterId from Zookeeper", (Throwable)e);
            }
            catch (IOException e) {
                LOG.warn((Object)"Can't retrieve clusterId from Zookeeper", (Throwable)e);
            }
            finally {
                if (zkw != null) {
                    zkw.close();
                }
            }
            if (this.clusterId == null) {
                this.clusterId = "default-cluster";
            }
            LOG.info((Object)("ClusterId is " + this.clusterId));
        }

        @Override
        public Configuration getConfiguration() {
            return this.conf;
        }

        private MasterProtocol createMasterInterface(MasterProtocolState masterProtocolState) throws IOException, KeeperException, ServiceException {
            ZooKeeperKeepAliveConnection zkw;
            try {
                zkw = this.getKeepAliveZooKeeperWatcher();
            }
            catch (IOException e) {
                throw new ZooKeeperConnectionException("Can't connect to ZooKeeper", e);
            }
            try {
                this.checkIfBaseNodeAvailable(zkw);
                ServerName sn = MasterAddressTracker.getMasterAddress(zkw);
                if (sn == null) {
                    String msg = "ZooKeeper available but no active master location found";
                    LOG.info((Object)msg);
                    throw new MasterNotRunningException(msg);
                }
                InetSocketAddress isa = new InetSocketAddress(sn.getHostname(), sn.getPort());
                MasterProtocol tryMaster = this.rpcEngine.getProxy(masterProtocolState.protocolClass, isa, this.conf, this.rpcTimeout);
                if (tryMaster.isMasterRunning(null, RequestConverter.buildIsMasterRunningRequest()).getIsMasterRunning()) {
                    MasterProtocol masterProtocol = tryMaster;
                    return masterProtocol;
                }
                String msg = "Can create a proxy to master, but it is not running";
                LOG.info((Object)msg);
                throw new MasterNotRunningException(msg);
            }
            finally {
                zkw.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressWarnings(value={"SWL_SLEEP_WITH_LOCK_HELD"})
        private MasterProtocol createMasterWithRetries(MasterProtocolState masterProtocolState) throws MasterNotRunningException {
            Object object = this.masterAndZKLock;
            synchronized (object) {
                Throwable exceptionCaught = null;
                MasterProtocol master = null;
                int tries = 0;
                while (!this.closed && master == null) {
                    ++tries;
                    try {
                        master = this.createMasterInterface(masterProtocolState);
                    }
                    catch (IOException e) {
                        exceptionCaught = e;
                    }
                    catch (KeeperException e) {
                        exceptionCaught = e;
                    }
                    catch (ServiceException e) {
                        exceptionCaught = e;
                    }
                    if (exceptionCaught == null) continue;
                    if (tries < this.numRetries) {
                        long pauseTime = ConnectionUtils.getPauseTime(this.pause, tries - 1);
                        LOG.info((Object)("getMaster attempt " + tries + " of " + this.numRetries + " failed; retrying after sleep of " + pauseTime + ", exception=" + exceptionCaught));
                        try {
                            Thread.sleep(pauseTime);
                            continue;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new RuntimeException("Thread was interrupted while trying to connect to master.", e);
                        }
                    }
                    LOG.info((Object)("getMaster attempt " + tries + " of " + this.numRetries + " failed; no more retrying."), exceptionCaught);
                    throw new MasterNotRunningException((Exception)exceptionCaught);
                }
                if (master == null) {
                    throw new MasterNotRunningException("Connection was closed while trying to get master");
                }
                return master;
            }
        }

        private void checkIfBaseNodeAvailable(ZooKeeperWatcher zkw) throws MasterNotRunningException {
            try {
                if (ZKUtil.checkExists(zkw, zkw.baseZNode) == -1) {
                    String errorMsg = "The node " + zkw.baseZNode + " is not in ZooKeeper. " + "It should have been written by the master. " + "Check the value configured in 'zookeeper.znode.parent'. " + "There could be a mismatch with the one configured in the master.";
                    LOG.error((Object)errorMsg);
                    throw new MasterNotRunningException(errorMsg);
                }
            }
            catch (KeeperException e) {
                String errorMsg = "Can't get connection to ZooKeeper: " + e.getMessage();
                LOG.error((Object)errorMsg);
                throw new MasterNotRunningException(errorMsg, (Exception)((Object)e));
            }
        }

        @Override
        public boolean isMasterRunning() throws MasterNotRunningException, ZooKeeperConnectionException {
            this.getKeepAliveMasterMonitor().close();
            return true;
        }

        @Override
        public HRegionLocation getRegionLocation(byte[] name, byte[] row, boolean reload) throws IOException {
            return reload ? this.relocateRegion(name, row) : this.locateRegion(name, row);
        }

        @Override
        public boolean isTableEnabled(byte[] tableName) throws IOException {
            return this.testTableOnlineState(tableName, true);
        }

        @Override
        public boolean isTableDisabled(byte[] tableName) throws IOException {
            return this.testTableOnlineState(tableName, false);
        }

        @Override
        public boolean isTableAvailable(final byte[] tableName) throws IOException {
            final AtomicBoolean available = new AtomicBoolean(true);
            final AtomicInteger regionCount = new AtomicInteger(0);
            MetaScanner.MetaScannerVisitorBase visitor = new MetaScanner.MetaScannerVisitorBase(){

                @Override
                public boolean processRow(Result row) throws IOException {
                    HRegionInfo info = MetaScanner.getHRegionInfo(row);
                    if (info != null) {
                        if (Bytes.compareTo((byte[])tableName, (byte[])info.getTableName()) == 0) {
                            ServerName server = HRegionInfo.getServerName(row);
                            if (server == null) {
                                available.set(false);
                                return false;
                            }
                            regionCount.incrementAndGet();
                        } else if (Bytes.compareTo((byte[])tableName, (byte[])info.getTableName()) < 0) {
                            return false;
                        }
                    }
                    return true;
                }
            };
            MetaScanner.metaScan(this.conf, visitor, tableName);
            return available.get() && regionCount.get() > 0;
        }

        @Override
        public boolean isTableAvailable(final byte[] tableName, final byte[][] splitKeys) throws IOException {
            final AtomicBoolean available = new AtomicBoolean(true);
            final AtomicInteger regionCount = new AtomicInteger(0);
            MetaScanner.MetaScannerVisitorBase visitor = new MetaScanner.MetaScannerVisitorBase(){

                @Override
                public boolean processRow(Result row) throws IOException {
                    HRegionInfo info = MetaScanner.getHRegionInfo(row);
                    if (info != null) {
                        if (Bytes.compareTo((byte[])tableName, (byte[])info.getTableName()) == 0) {
                            ServerName server = HRegionInfo.getServerName(row);
                            if (server == null) {
                                available.set(false);
                                return false;
                            }
                            if (!Bytes.equals((byte[])info.getStartKey(), (byte[])HConstants.EMPTY_BYTE_ARRAY)) {
                                for (byte[] splitKey : splitKeys) {
                                    if (!Bytes.equals((byte[])info.getStartKey(), (byte[])splitKey)) continue;
                                    regionCount.incrementAndGet();
                                    break;
                                }
                            } else {
                                regionCount.incrementAndGet();
                            }
                        } else if (Bytes.compareTo((byte[])tableName, (byte[])info.getTableName()) < 0) {
                            return false;
                        }
                    }
                    return true;
                }
            };
            MetaScanner.metaScan(this.conf, visitor, tableName);
            return available.get() && regionCount.get() == splitKeys.length + 1;
        }

        private boolean testTableOnlineState(byte[] tableName, boolean enabled) throws IOException {
            String tableNameStr = Bytes.toString((byte[])tableName);
            ZooKeeperKeepAliveConnection zkw = this.getKeepAliveZooKeeperWatcher();
            try {
                if (enabled) {
                    boolean bl = ZKTableReadOnly.isEnabledTable(zkw, tableNameStr);
                    return bl;
                }
                boolean bl = ZKTableReadOnly.isDisabledTable(zkw, tableNameStr);
                return bl;
            }
            catch (KeeperException e) {
                throw new IOException("Enable/Disable failed", e);
            }
            finally {
                zkw.close();
            }
        }

        @Override
        public HRegionLocation locateRegion(byte[] regionName) throws IOException {
            return this.locateRegion(HRegionInfo.getTableName(regionName), HRegionInfo.getStartKey(regionName), false, true);
        }

        @Override
        public boolean isDeadServer(ServerName sn) {
            if (this.clusterStatusListener == null) {
                return false;
            }
            return this.clusterStatusListener.isDeadServer(sn);
        }

        @Override
        public List<HRegionLocation> locateRegions(byte[] tableName) throws IOException {
            return this.locateRegions(tableName, false, true);
        }

        @Override
        public List<HRegionLocation> locateRegions(byte[] tableName, boolean useCache, boolean offlined) throws IOException {
            NavigableMap<HRegionInfo, ServerName> regions = MetaScanner.allTableRegions(this.conf, tableName, offlined);
            ArrayList<HRegionLocation> locations = new ArrayList<HRegionLocation>();
            for (HRegionInfo regionInfo : regions.keySet()) {
                locations.add(this.locateRegion(tableName, regionInfo.getStartKey(), useCache, true));
            }
            return locations;
        }

        @Override
        public HRegionLocation locateRegion(byte[] tableName, byte[] row) throws IOException {
            return this.locateRegion(tableName, row, true, true);
        }

        @Override
        public HRegionLocation relocateRegion(byte[] tableName, byte[] row) throws IOException {
            if (this.isTableDisabled(tableName)) {
                throw new DoNotRetryIOException(Bytes.toString((byte[])tableName) + " is disabled.");
            }
            return this.locateRegion(tableName, row, false, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private HRegionLocation locateRegion(byte[] tableName, byte[] row, boolean useCache, boolean retry) throws IOException {
            if (this.closed) {
                throw new IOException(this.toString() + " closed");
            }
            if (tableName == null || tableName.length == 0) {
                throw new IllegalArgumentException("table name cannot be null or zero length");
            }
            if (Bytes.equals((byte[])tableName, (byte[])HConstants.META_TABLE_NAME)) {
                ZooKeeperKeepAliveConnection zkw = this.getKeepAliveZooKeeperWatcher();
                try {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Looking up meta region location in ZK, connection=" + this));
                    }
                    ServerName servername = MetaRegionTracker.blockUntilAvailable(zkw, this.rpcTimeout);
                    if (LOG.isTraceEnabled()) {
                        LOG.debug((Object)("Looked up meta region location, connection=" + this + "; serverName=" + (servername == null ? "null" : servername)));
                    }
                    if (servername == null) {
                        HRegionLocation hRegionLocation = null;
                        return hRegionLocation;
                    }
                    HRegionLocation hRegionLocation = new HRegionLocation(HRegionInfo.FIRST_META_REGIONINFO, servername, 0L);
                    return hRegionLocation;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    HRegionLocation hRegionLocation = null;
                    return hRegionLocation;
                }
                finally {
                    zkw.close();
                }
            }
            return this.locateRegionInMeta(HConstants.META_TABLE_NAME, tableName, row, useCache, this.userRegionLock, retry);
        }

        private void prefetchRegionCache(final byte[] tableName, byte[] row) {
            MetaScanner.MetaScannerVisitorBase visitor = new MetaScanner.MetaScannerVisitorBase(){

                @Override
                public boolean processRow(Result result) throws IOException {
                    try {
                        HRegionInfo regionInfo = MetaScanner.getHRegionInfo(result);
                        if (regionInfo == null) {
                            return true;
                        }
                        if (!Bytes.equals((byte[])regionInfo.getTableName(), (byte[])tableName)) {
                            return false;
                        }
                        if (regionInfo.isOffline()) {
                            return true;
                        }
                        ServerName serverName = HRegionInfo.getServerName(result);
                        if (serverName == null) {
                            return true;
                        }
                        long seqNum = HRegionInfo.getSeqNumDuringOpen(result);
                        HRegionLocation loc = new HRegionLocation(regionInfo, serverName, seqNum);
                        HConnectionImplementation.this.cacheLocation(tableName, null, loc);
                        return true;
                    }
                    catch (RuntimeException e) {
                        throw new IOException(e);
                    }
                }
            };
            try {
                MetaScanner.metaScan(this.conf, visitor, tableName, row, this.prefetchRegionLimit);
            }
            catch (IOException e) {
                LOG.warn((Object)"Encountered problems when prefetch META table: ", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private HRegionLocation locateRegionInMeta(byte[] parentTable, byte[] tableName, byte[] row, boolean useCache, Object regionLockObject, boolean retry) throws IOException {
            HRegionLocation location;
            if (useCache && (location = this.getCachedLocation(tableName, row)) != null) {
                return location;
            }
            int localNumRetries = retry ? this.numRetries : 1;
            byte[] metaKey = HRegionInfo.createRegionName(tableName, row, "99999999999999", false);
            int tries = 0;
            while (true) {
                block27: {
                    if (tries >= localNumRetries) {
                        throw new NoServerForRegionException("Unable to find region for " + Bytes.toStringBinary((byte[])row) + " after " + this.numRetries + " tries.");
                    }
                    HRegionLocation metaLocation = null;
                    try {
                        Result regionInfoRow;
                        metaLocation = this.locateRegion(parentTable, metaKey, true, false);
                        if (metaLocation == null) break block27;
                        ClientProtocol server = this.getClient(metaLocation.getServerName());
                        Object object = regionLockObject;
                        synchronized (object) {
                            if (Bytes.equals((byte[])parentTable, (byte[])HConstants.META_TABLE_NAME) && this.getRegionCachePrefetch(tableName)) {
                                this.prefetchRegionCache(tableName, row);
                            }
                            if (useCache) {
                                location = this.getCachedLocation(tableName, row);
                                if (location != null) {
                                    return location;
                                }
                            } else {
                                this.forceDeleteCachedLocation(tableName, row);
                            }
                            regionInfoRow = ProtobufUtil.getRowOrBefore(server, metaLocation.getRegionInfo().getRegionName(), metaKey, HConstants.CATALOG_FAMILY);
                        }
                        if (regionInfoRow == null) {
                            throw new TableNotFoundException(Bytes.toString((byte[])tableName));
                        }
                        HRegionInfo regionInfo = MetaScanner.getHRegionInfo(regionInfoRow);
                        if (regionInfo == null) {
                            throw new IOException("HRegionInfo was null or empty in " + Bytes.toString((byte[])parentTable) + ", row=" + regionInfoRow);
                        }
                        if (!Bytes.equals((byte[])regionInfo.getTableName(), (byte[])tableName)) {
                            throw new TableNotFoundException("Table '" + Bytes.toString((byte[])tableName) + "' was not found, got: " + Bytes.toString((byte[])regionInfo.getTableName()) + ".");
                        }
                        if (regionInfo.isSplit()) {
                            throw new RegionOfflineException("the only available region for the required row is a split parent, the daughters should be online soon: " + regionInfo.getRegionNameAsString());
                        }
                        if (regionInfo.isOffline()) {
                            throw new RegionOfflineException("the region is offline, could be caused by a disable table call: " + regionInfo.getRegionNameAsString());
                        }
                        ServerName serverName = HRegionInfo.getServerName(regionInfoRow);
                        if (serverName == null) {
                            throw new NoServerForRegionException("No server address listed in " + Bytes.toString((byte[])parentTable) + " for region " + regionInfo.getRegionNameAsString() + " containing row " + Bytes.toStringBinary((byte[])row));
                        }
                        if (this.isDeadServer(serverName)) {
                            throw new RegionServerStoppedException(".META. says the region " + regionInfo.getRegionNameAsString() + " is managed by the server " + serverName + ", but it is dead.");
                        }
                        location = new HRegionLocation(regionInfo, serverName, HRegionInfo.getSeqNumDuringOpen(regionInfoRow));
                        this.cacheLocation(tableName, null, location);
                        return location;
                    }
                    catch (TableNotFoundException e) {
                        throw e;
                    }
                    catch (IOException e) {
                        if (e instanceof RemoteException) {
                            e = RemoteExceptionHandler.decodeRemoteException((RemoteException)((Object)e));
                        }
                        if (tries < this.numRetries - 1) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("locateRegionInMeta parentTable=" + Bytes.toString((byte[])parentTable) + ", metaLocation=" + (metaLocation == null ? "null" : "{" + metaLocation + "}") + ", attempt=" + tries + " of " + this.numRetries + " failed; retrying after sleep of " + ConnectionUtils.getPauseTime(this.pause, tries) + " because: " + e.getMessage()));
                            }
                        } else {
                            throw e;
                        }
                        if (!(e instanceof RegionOfflineException) && !(e instanceof NoServerForRegionException)) {
                            this.relocateRegion(parentTable, metaKey);
                        }
                        try {
                            Thread.sleep(ConnectionUtils.getPauseTime(this.pause, tries));
                        }
                        catch (InterruptedException e2) {
                            Thread.currentThread().interrupt();
                            throw new IOException("Giving up trying to location region in meta: thread is interrupted.");
                        }
                    }
                }
                ++tries;
            }
        }

        HRegionLocation getCachedLocation(byte[] tableName, byte[] row) {
            SoftValueSortedMap<byte[], HRegionLocation> tableLocations = this.getTableLocations(tableName);
            if (tableLocations.isEmpty()) {
                return null;
            }
            HRegionLocation possibleRegion = (HRegionLocation)tableLocations.get((Object)row);
            if (possibleRegion != null) {
                return possibleRegion;
            }
            possibleRegion = (HRegionLocation)tableLocations.lowerValueByKey((Object)row);
            if (possibleRegion == null) {
                return null;
            }
            byte[] endKey = possibleRegion.getRegionInfo().getEndKey();
            if (Bytes.equals((byte[])endKey, (byte[])HConstants.EMPTY_END_ROW) || KeyValue.getRowComparator((byte[])tableName).compareRows(endKey, 0, endKey.length, row, 0, row.length) > 0) {
                return possibleRegion;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void forceDeleteCachedLocation(byte[] tableName, byte[] row) {
            HRegionLocation rl = null;
            Map<Integer, SoftValueSortedMap<byte[], HRegionLocation>> map = this.cachedRegionLocations;
            synchronized (map) {
                SoftValueSortedMap<byte[], HRegionLocation> tableLocations = this.getTableLocations(tableName);
                if (!tableLocations.isEmpty() && (rl = this.getCachedLocation(tableName, row)) != null) {
                    tableLocations.remove(rl.getRegionInfo().getStartKey());
                }
            }
            if (rl != null && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removed " + rl.getHostname() + ":" + rl.getPort() + " as a location of " + rl.getRegionInfo().getRegionNameAsString() + " for tableName=" + Bytes.toString((byte[])tableName) + " from cache"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clearCaches(ServerName serverName) {
            boolean deletedSomething = false;
            Map<Integer, SoftValueSortedMap<byte[], HRegionLocation>> map = this.cachedRegionLocations;
            synchronized (map) {
                if (!this.cachedServers.contains(serverName)) {
                    return;
                }
                for (SoftValueSortedMap<byte[], HRegionLocation> tableLocations : this.cachedRegionLocations.values()) {
                    for (Map.Entry e : tableLocations.entrySet()) {
                        if (!serverName.equals(((HRegionLocation)e.getValue()).getServerName())) continue;
                        tableLocations.remove(e.getKey());
                        deletedSomething = true;
                    }
                }
                this.cachedServers.remove(serverName);
            }
            if (deletedSomething && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removed all cached region locations that map to " + serverName));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SoftValueSortedMap<byte[], HRegionLocation> getTableLocations(byte[] tableName) {
            SoftValueSortedMap result;
            Integer key = Bytes.mapKey((byte[])tableName);
            Map<Integer, SoftValueSortedMap<byte[], HRegionLocation>> map = this.cachedRegionLocations;
            synchronized (map) {
                result = this.cachedRegionLocations.get(key);
                if (result == null) {
                    result = new SoftValueSortedMap(Bytes.BYTES_COMPARATOR);
                    this.cachedRegionLocations.put(key, (SoftValueSortedMap<byte[], HRegionLocation>)result);
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clearRegionCache() {
            Map<Integer, SoftValueSortedMap<byte[], HRegionLocation>> map = this.cachedRegionLocations;
            synchronized (map) {
                this.cachedRegionLocations.clear();
                this.cachedServers.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clearRegionCache(byte[] tableName) {
            Map<Integer, SoftValueSortedMap<byte[], HRegionLocation>> map = this.cachedRegionLocations;
            synchronized (map) {
                this.cachedRegionLocations.remove(Bytes.mapKey((byte[])tableName));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cacheLocation(byte[] tableName, HRegionLocation source, HRegionLocation location) {
            boolean isFromMeta = source == null;
            byte[] startKey = location.getRegionInfo().getStartKey();
            SoftValueSortedMap<byte[], HRegionLocation> tableLocations = this.getTableLocations(tableName);
            boolean isNewCacheEntry = false;
            boolean isStaleUpdate = false;
            HRegionLocation oldLocation = null;
            Map<Integer, SoftValueSortedMap<byte[], HRegionLocation>> map = this.cachedRegionLocations;
            synchronized (map) {
                this.cachedServers.add(location.getServerName());
                oldLocation = (HRegionLocation)tableLocations.get(startKey);
                boolean bl = isNewCacheEntry = oldLocation == null;
                if (!isNewCacheEntry && !oldLocation.equals(source)) {
                    long newLocationSeqNum = location.getSeqNum();
                    boolean isStaleMetaRecord = isFromMeta && oldLocation.getSeqNum() > newLocationSeqNum;
                    boolean isStaleRedirect = !isFromMeta && oldLocation.getSeqNum() >= newLocationSeqNum;
                    boolean bl2 = isStaleUpdate = isStaleMetaRecord || isStaleRedirect;
                }
                if (!isStaleUpdate) {
                    tableLocations.put(startKey, location);
                }
            }
            if (isNewCacheEntry) {
                LOG.debug((Object)("Cached location for " + location.getRegionInfo().getRegionNameAsString() + " is " + location.getHostnamePort()));
            } else if (isStaleUpdate && !location.equals(oldLocation)) {
                LOG.debug((Object)("Ignoring stale location update for " + location.getRegionInfo().getRegionNameAsString() + ": " + location.getHostnamePort() + " at " + location.getSeqNum() + "; local " + oldLocation.getHostnamePort() + " at " + oldLocation.getSeqNum()));
            }
        }

        @Override
        @Deprecated
        public AdminProtocol getAdmin(String hostname, int port) throws IOException {
            return this.getAdmin(new ServerName(hostname, port, 0L));
        }

        @Override
        public AdminProtocol getAdmin(ServerName serverName) throws IOException {
            return this.getAdmin(serverName, false);
        }

        @Override
        @Deprecated
        public ClientProtocol getClient(String hostname, int port) throws IOException {
            return (ClientProtocol)this.getProtocol(hostname, port, this.clientClass);
        }

        @Override
        public ClientProtocol getClient(ServerName serverName) throws IOException {
            if (this.isDeadServer(serverName)) {
                throw new RegionServerStoppedException("The server " + serverName + " is dead.");
            }
            return (ClientProtocol)this.getProtocol(serverName.getHostname(), serverName.getPort(), this.clientClass);
        }

        @Override
        @Deprecated
        public AdminProtocol getAdmin(String hostname, int port, boolean master) throws IOException {
            return (AdminProtocol)this.getProtocol(hostname, port, this.adminClass);
        }

        @Override
        public AdminProtocol getAdmin(ServerName serverName, boolean master) throws IOException {
            if (this.isDeadServer(serverName)) {
                throw new RegionServerStoppedException("The server " + serverName + " is dead.");
            }
            return (AdminProtocol)this.getProtocol(serverName.getHostname(), serverName.getPort(), this.adminClass);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        IpcProtocol getProtocol(String hostname, int port, Class<? extends IpcProtocol> protocolClass) throws IOException {
            String protocol;
            IpcProtocol server;
            Map<String, IpcProtocol> existingProtocols;
            String rsName = Addressing.createHostAndPortStr((String)hostname, (int)port);
            Map<String, IpcProtocol> protocols = this.servers.get(rsName);
            if (protocols == null && (existingProtocols = this.servers.putIfAbsent(rsName, protocols = new HashMap<String, IpcProtocol>())) != null) {
                protocols = existingProtocols;
            }
            if ((server = protocols.get(protocol = protocolClass.getName())) == null) {
                String lockKey = protocol + "@" + rsName;
                this.connectionLock.putIfAbsent(lockKey, lockKey);
                String string = this.connectionLock.get(lockKey);
                synchronized (string) {
                    server = protocols.get(protocol);
                    if (server == null) {
                        try {
                            InetSocketAddress address = new InetSocketAddress(hostname, port);
                            server = HBaseClientRPC.waitForProxy(this.rpcEngine, protocolClass, address, this.conf, this.maxRPCAttempts, this.rpcTimeout, this.rpcTimeout);
                            protocols.put(protocol, server);
                        }
                        catch (RemoteException e) {
                            LOG.warn((Object)"RemoteException connecting to RS", (Throwable)e);
                            throw e.unwrapRemoteException();
                        }
                    }
                }
            }
            return server;
        }

        @Override
        @Deprecated
        public ZooKeeperWatcher getZooKeeperWatcher() throws ZooKeeperConnectionException {
            this.canCloseZKW = false;
            try {
                return this.getKeepAliveZooKeeperWatcher();
            }
            catch (ZooKeeperConnectionException e) {
                throw e;
            }
            catch (IOException e) {
                throw new ZooKeeperConnectionException("Can't create a zookeeper connection", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ZooKeeperKeepAliveConnection getKeepAliveZooKeeperWatcher() throws IOException {
            Object object = this.masterAndZKLock;
            synchronized (object) {
                if (this.keepAliveZookeeper == null) {
                    this.keepAliveZookeeper = new ZooKeeperKeepAliveConnection(this.conf, this.toString(), this);
                }
                ++this.keepAliveZookeeperUserCount;
                this.keepZooKeeperWatcherAliveUntil = Long.MAX_VALUE;
                return this.keepAliveZookeeper;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void releaseZooKeeperWatcher(ZooKeeperWatcher zkw) {
            if (zkw == null) {
                return;
            }
            Object object = this.masterAndZKLock;
            synchronized (object) {
                --this.keepAliveZookeeperUserCount;
                if (this.keepAliveZookeeperUserCount <= 0) {
                    this.keepZooKeeperWatcherAliveUntil = System.currentTimeMillis() + 300000L;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeZooKeeperWatcher() {
            Object object = this.masterAndZKLock;
            synchronized (object) {
                if (this.keepAliveZookeeper != null) {
                    LOG.info((Object)("Closing zookeeper sessionid=0x" + Long.toHexString(this.keepAliveZookeeper.getRecoverableZooKeeper().getSessionId())));
                    this.keepAliveZookeeper.internalClose();
                    this.keepAliveZookeeper = null;
                }
                this.keepAliveZookeeperUserCount = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object getKeepAliveMasterProtocol(MasterProtocolState protocolState, Class connectionClass) throws MasterNotRunningException {
            Object object = this.masterAndZKLock;
            synchronized (object) {
                if (!this.isKeepAliveMasterConnectedAndRunning(protocolState)) {
                    protocolState.protocol = null;
                    protocolState.protocol = this.createMasterWithRetries(protocolState);
                }
                ++protocolState.userCount;
                protocolState.keepAliveUntil = Long.MAX_VALUE;
                return Proxy.newProxyInstance(connectionClass.getClassLoader(), new Class[]{connectionClass}, (InvocationHandler)new MasterProtocolHandler(this, protocolState));
            }
        }

        @Override
        public MasterAdminProtocol getMasterAdmin() throws MasterNotRunningException {
            return this.getKeepAliveMasterAdmin();
        }

        @Override
        public MasterMonitorProtocol getMasterMonitor() throws MasterNotRunningException {
            return this.getKeepAliveMasterMonitor();
        }

        @Override
        public MasterAdminKeepAliveConnection getKeepAliveMasterAdmin() throws MasterNotRunningException {
            return (MasterAdminKeepAliveConnection)this.getKeepAliveMasterProtocol(this.masterAdminProtocol, MasterAdminKeepAliveConnection.class);
        }

        @Override
        public MasterMonitorKeepAliveConnection getKeepAliveMasterMonitor() throws MasterNotRunningException {
            return (MasterMonitorKeepAliveConnection)this.getKeepAliveMasterProtocol(this.masterMonitorProtocol, MasterMonitorKeepAliveConnection.class);
        }

        private boolean isKeepAliveMasterConnectedAndRunning(MasterProtocolState protocolState) {
            if (protocolState.protocol == null) {
                return false;
            }
            try {
                return protocolState.protocol.isMasterRunning(null, RequestConverter.buildIsMasterRunningRequest()).getIsMasterRunning();
            }
            catch (UndeclaredThrowableException e) {
                LOG.info((Object)"Master connection is not running anymore", e.getUndeclaredThrowable());
                return false;
            }
            catch (ServiceException se) {
                LOG.warn((Object)"Checking master connection", (Throwable)se);
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void releaseMaster(MasterProtocolState protocolState) {
            if (protocolState.protocol == null) {
                return;
            }
            Object object = this.masterAndZKLock;
            synchronized (object) {
                --protocolState.userCount;
                if (protocolState.userCount <= 0) {
                    protocolState.keepAliveUntil = System.currentTimeMillis() + 300000L;
                }
            }
        }

        private void closeMasterProtocol(MasterProtocolState protocolState) {
            if (protocolState.protocol != null) {
                LOG.info((Object)("Closing master protocol: " + protocolState.protocolClass.getName()));
                protocolState.protocol = null;
            }
            protocolState.userCount = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeMaster() {
            Object object = this.masterAndZKLock;
            synchronized (object) {
                this.closeMasterProtocol(this.masterAdminProtocol);
                this.closeMasterProtocol(this.masterMonitorProtocol);
            }
        }

        @Override
        public <T> T getRegionServerWithRetries(ServerCallable<T> callable) throws IOException, RuntimeException {
            return callable.withRetries();
        }

        @Override
        public <T> T getRegionServerWithoutRetries(ServerCallable<T> callable) throws IOException, RuntimeException {
            return callable.withoutRetries();
        }

        @Deprecated
        private <R> Callable<MultiResponse> createCallable(final HRegionLocation loc, final MultiAction<R> multi, final byte[] tableName) {
            final HConnectionImplementation connection = this;
            return new Callable<MultiResponse>(){

                @Override
                public MultiResponse call() throws Exception {
                    MultiServerCallable callable = new MultiServerCallable(connection, tableName, loc, multi);
                    return (MultiResponse)callable.withoutRetries();
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateCachedLocation(HRegionInfo hri, HRegionLocation source, ServerName serverName, long seqNum) {
            HRegionLocation newHrl = new HRegionLocation(hri, serverName, seqNum);
            Map<Integer, SoftValueSortedMap<byte[], HRegionLocation>> map = this.cachedRegionLocations;
            synchronized (map) {
                this.cacheLocation(hri.getTableName(), source, newHrl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void deleteCachedLocation(HRegionInfo hri, HRegionLocation source) {
            boolean isStaleDelete = false;
            HRegionLocation oldLocation = null;
            Map<Integer, SoftValueSortedMap<byte[], HRegionLocation>> map = this.cachedRegionLocations;
            synchronized (map) {
                SoftValueSortedMap<byte[], HRegionLocation> tableLocations = this.getTableLocations(hri.getTableName());
                oldLocation = (HRegionLocation)tableLocations.get(hri.getStartKey());
                if (oldLocation != null) {
                    boolean bl = isStaleDelete = source != null && !oldLocation.equals(source);
                    if (!isStaleDelete) {
                        tableLocations.remove(hri.getStartKey());
                    }
                }
            }
            if (isStaleDelete) {
                LOG.debug((Object)("Received an error from " + source.getHostnamePort() + " for region " + hri.getRegionNameAsString() + "; not removing " + oldLocation.getHostnamePort() + " from cache."));
            }
        }

        private void updateCachedLocations(byte[] tableName, Row row, Object exception, HRegionLocation source) {
            if (row == null || tableName == null) {
                LOG.warn((Object)("Coding error, see method javadoc. row=" + (row == null ? "null" : row) + ", tableName=" + (tableName == null ? "null" : Bytes.toString((byte[])tableName))));
                return;
            }
            HRegionLocation oldLocation = this.getCachedLocation(tableName, row.getRow());
            if (oldLocation == null) {
                return;
            }
            HRegionInfo regionInfo = oldLocation.getRegionInfo();
            RegionMovedException rme = RegionMovedException.find(exception);
            if (rme != null) {
                LOG.info((Object)("Region " + regionInfo.getRegionNameAsString() + " moved to " + rme.getHostname() + ":" + rme.getPort() + " according to " + source.getHostnamePort()));
                this.updateCachedLocation(regionInfo, source, rme.getServerName(), rme.getLocationSeqNum());
            } else if (RegionOpeningException.find(exception) != null) {
                LOG.info((Object)("Region " + regionInfo.getRegionNameAsString() + " is being opened on " + source.getHostnamePort() + "; not deleting the cache entry"));
            } else {
                this.deleteCachedLocation(regionInfo, source);
            }
        }

        @Override
        @Deprecated
        public void processBatch(List<? extends Row> list, byte[] tableName, ExecutorService pool, Object[] results) throws IOException, InterruptedException {
            if (results.length != list.size()) {
                throw new IllegalArgumentException("argument results must be the same size as argument list");
            }
            this.processBatchCallback(list, tableName, pool, results, null);
        }

        @Override
        @Deprecated
        public <R> void processBatchCallback(List<? extends Row> list, byte[] tableName, ExecutorService pool, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
            Process p = new Process(this, list, tableName, pool, results, callback);
            p.processBatchCallback();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int getNumberOfCachedRegionLocations(byte[] tableName) {
            Integer key = Bytes.mapKey((byte[])tableName);
            Map<Integer, SoftValueSortedMap<byte[], HRegionLocation>> map = this.cachedRegionLocations;
            synchronized (map) {
                Map tableLocs = (Map)this.cachedRegionLocations.get(key);
                if (tableLocs == null) {
                    return 0;
                }
                return tableLocs.values().size();
            }
        }

        boolean isRegionCached(byte[] tableName, byte[] row) {
            HRegionLocation location = this.getCachedLocation(tableName, row);
            return location != null;
        }

        @Override
        public void setRegionCachePrefetch(byte[] tableName, boolean enable) {
            if (!enable) {
                this.regionCachePrefetchDisabledTables.add(Bytes.mapKey((byte[])tableName));
            } else {
                this.regionCachePrefetchDisabledTables.remove(Bytes.mapKey((byte[])tableName));
            }
        }

        @Override
        public boolean getRegionCachePrefetch(byte[] tableName) {
            return !this.regionCachePrefetchDisabledTables.contains(Bytes.mapKey((byte[])tableName));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void abort(String msg, Throwable t) {
            if (t instanceof KeeperException.SessionExpiredException && this.keepAliveZookeeper != null) {
                Object object = this.masterAndZKLock;
                synchronized (object) {
                    if (this.keepAliveZookeeper != null) {
                        LOG.warn((Object)"This client just lost it's session with ZooKeeper, closing it. It will be recreated next time someone needs it", t);
                        this.closeZooKeeperWatcher();
                    }
                }
            } else {
                if (t != null) {
                    LOG.fatal((Object)msg, t);
                } else {
                    LOG.fatal((Object)msg);
                }
                this.aborted = true;
                this.close();
                this.closed = true;
            }
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public boolean isAborted() {
            return this.aborted;
        }

        @Override
        public int getCurrentNrHRS() throws IOException {
            ZooKeeperKeepAliveConnection zkw = this.getKeepAliveZooKeeperWatcher();
            try {
                int n = ZKUtil.getNumberOfChildren(zkw, zkw.rsZNode);
                return n;
            }
            catch (KeeperException ke) {
                throw new IOException("Unexpected ZooKeeper exception", ke);
            }
            finally {
                zkw.close();
            }
        }

        void incCount() {
            ++this.refCount;
        }

        void decCount() {
            if (this.refCount > 0) {
                --this.refCount;
            }
        }

        boolean isZeroReference() {
            return this.refCount == 0;
        }

        void internalClose() {
            if (this.closed) {
                return;
            }
            this.delayedClosing.stop("Closing connection");
            this.closeMaster();
            this.closeZooKeeperWatcher();
            this.servers.clear();
            this.rpcEngine.close();
            if (this.clusterStatusListener != null) {
                this.clusterStatusListener.close();
            }
            this.closed = true;
        }

        @Override
        public void close() {
            if (this.managed) {
                if (this.aborted) {
                    HConnectionManager.deleteStaleConnection(this);
                } else {
                    HConnectionManager.deleteConnection(this, false);
                }
            } else {
                this.internalClose();
            }
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.refCount = 1;
            this.close();
        }

        @Override
        public HTableDescriptor[] listTables() throws IOException {
            MasterMonitorKeepAliveConnection master = this.getKeepAliveMasterMonitor();
            try {
                MasterMonitorProtos.GetTableDescriptorsRequest req = RequestConverter.buildGetTableDescriptorsRequest(null);
                HTableDescriptor[] hTableDescriptorArray = ProtobufUtil.getHTableDescriptorArray(master.getTableDescriptors(null, req));
                return hTableDescriptorArray;
            }
            catch (ServiceException se) {
                throw ProtobufUtil.getRemoteException(se);
            }
            finally {
                master.close();
            }
        }

        @Override
        public HTableDescriptor[] getHTableDescriptors(List<String> tableNames) throws IOException {
            if (tableNames == null || tableNames.isEmpty()) {
                return new HTableDescriptor[0];
            }
            MasterMonitorKeepAliveConnection master = this.getKeepAliveMasterMonitor();
            try {
                MasterMonitorProtos.GetTableDescriptorsRequest req = RequestConverter.buildGetTableDescriptorsRequest(tableNames);
                HTableDescriptor[] hTableDescriptorArray = ProtobufUtil.getHTableDescriptorArray(master.getTableDescriptors(null, req));
                return hTableDescriptorArray;
            }
            catch (ServiceException se) {
                throw ProtobufUtil.getRemoteException(se);
            }
            finally {
                master.close();
            }
        }

        @Override
        public HTableDescriptor getHTableDescriptor(byte[] tableName) throws IOException {
            MasterMonitorProtos.GetTableDescriptorsResponse htds;
            if (tableName == null || tableName.length == 0) {
                return null;
            }
            if (Bytes.equals((byte[])tableName, (byte[])HConstants.META_TABLE_NAME)) {
                return HTableDescriptor.META_TABLEDESC;
            }
            MasterMonitorKeepAliveConnection master = this.getKeepAliveMasterMonitor();
            try {
                MasterMonitorProtos.GetTableDescriptorsRequest req = RequestConverter.buildGetTableDescriptorsRequest(null);
                htds = master.getTableDescriptors(null, req);
            }
            catch (ServiceException se) {
                throw ProtobufUtil.getRemoteException(se);
            }
            finally {
                master.close();
            }
            for (HBaseProtos.TableSchema ts : htds.getTableSchemaList()) {
                if (!Bytes.equals((byte[])tableName, (byte[])ts.getName().toByteArray())) continue;
                return HTableDescriptor.convert(ts);
            }
            throw new TableNotFoundException(Bytes.toString((byte[])tableName));
        }

        void setRpcEngine(RpcClientEngine engine) {
            this.rpcEngine = engine;
        }

        private static class Process<R> {
            private final HConnectionImplementation hci;
            private final List<? extends Row> rows;
            private final byte[] tableName;
            private final ExecutorService pool;
            private final Object[] results;
            private final Batch.Callback<R> callback;
            private final List<Action<R>> toReplay;
            private final LinkedList<Triple<MultiAction<R>, HRegionLocation, Future<MultiResponse>>> inProgress;
            private int curNumRetries;
            private final List<MultiAction<R>> finishedTasks = new ArrayList<MultiAction<R>>();

            private Process(HConnectionImplementation hci, List<? extends Row> list, byte[] tableName, ExecutorService pool, Object[] results, Batch.Callback<R> callback) {
                this.hci = hci;
                this.rows = list;
                this.tableName = tableName;
                this.pool = pool;
                this.results = results;
                this.callback = callback;
                this.toReplay = new ArrayList<Action<R>>();
                this.inProgress = new LinkedList();
                this.curNumRetries = 0;
            }

            private void submit(List<Action<R>> actionsList, long sleepTime) throws IOException {
                HashMap<HRegionLocation, MultiAction<R>> actionsByServer = new HashMap<HRegionLocation, MultiAction<R>>();
                for (Action<R> action : actionsList) {
                    Row row = action.getAction();
                    if (row == null) continue;
                    HRegionLocation loc = this.hci.locateRegion(this.tableName, row.getRow());
                    if (loc == null) {
                        throw new IOException("No location found, aborting submit.");
                    }
                    byte[] regionName = loc.getRegionInfo().getRegionName();
                    MultiAction<R> actions = (MultiAction<R>)actionsByServer.get(loc);
                    if (actions == null) {
                        actions = new MultiAction<R>();
                        actionsByServer.put(loc, actions);
                    }
                    actions.add(regionName, action);
                }
                for (Map.Entry entry : actionsByServer.entrySet()) {
                    Callable<MultiResponse> callable = this.createDelayedCallable(sleepTime, (HRegionLocation)entry.getKey(), (MultiAction)entry.getValue());
                    if (LOG.isTraceEnabled() && sleepTime > 0L) {
                        StringBuilder sb = new StringBuilder();
                        for (Action action : ((MultiAction)entry.getValue()).allActions()) {
                            sb.append(Bytes.toStringBinary((byte[])action.getAction().getRow())).append(';');
                        }
                        LOG.trace((Object)("Sending requests to [" + ((HRegionLocation)entry.getKey()).getHostnamePort() + "] with delay of [" + sleepTime + "] for rows [" + sb.toString() + "]"));
                    }
                    Triple p = new Triple(entry.getValue(), entry.getKey(), this.pool.submit(callable));
                    this.inProgress.addLast(p);
                }
            }

            private void doRetry() throws IOException {
                long sleepTime = ConnectionUtils.getPauseTime(this.hci.pause, this.curNumRetries - 1);
                this.submit(this.toReplay, sleepTime);
                this.toReplay.clear();
            }

            private void processBatchCallback() throws IOException, InterruptedException {
                boolean noRetry;
                if (this.results.length != this.rows.size()) {
                    throw new IllegalArgumentException("argument results (size=" + this.results.length + ") must be the same size as " + "argument list (size=" + this.rows.size() + ")");
                }
                if (this.rows.isEmpty()) {
                    return;
                }
                boolean isTraceEnabled = LOG.isTraceEnabled();
                BatchErrors errors = new BatchErrors();
                BatchErrors retriedErrors = null;
                if (isTraceEnabled) {
                    retriedErrors = new BatchErrors();
                }
                int[] nbRetries = new int[this.results.length];
                ArrayList<Action<R>> listActions = new ArrayList<Action<R>>(this.rows.size());
                for (int i = 0; i < this.rows.size(); ++i) {
                    Action action = new Action(this.rows.get(i), i);
                    listActions.add(action);
                }
                this.submit(listActions, 0L);
                boolean lastRetry = false;
                boolean bl = noRetry = this.hci.numRetries < 2;
                while (!this.inProgress.isEmpty()) {
                    Triple<MultiAction<R>, HRegionLocation, Future<MultiResponse>> currentTask = this.removeFirstDone();
                    MultiResponse responses = null;
                    ExecutionException exception = null;
                    try {
                        responses = (MultiResponse)((Future)currentTask.getThird()).get();
                    }
                    catch (ExecutionException e) {
                        exception = e;
                    }
                    if (responses == null) {
                        for (List list : ((MultiAction)currentTask.getFirst()).actions.values()) {
                            for (Action action : list) {
                                Row row = action.getAction();
                                this.hci.updateCachedLocations(this.tableName, row, null, (HRegionLocation)currentTask.getSecond());
                                if (noRetry) {
                                    errors.add(exception, row, currentTask);
                                    continue;
                                }
                                if (isTraceEnabled) {
                                    retriedErrors.add(exception, row, currentTask);
                                }
                                lastRetry = this.addToReplay(nbRetries, action);
                            }
                        }
                    } else {
                        for (Map.Entry entry : responses.getResults().entrySet()) {
                            for (Pair regionResult : (List)entry.getValue()) {
                                Object result;
                                Action correspondingAction = (Action)listActions.get((Integer)regionResult.getFirst());
                                this.results[correspondingAction.getOriginalIndex()] = result = regionResult.getSecond();
                                if (result == null || result instanceof Throwable) {
                                    Row row = correspondingAction.getAction();
                                    this.hci.updateCachedLocations(this.tableName, row, result, (HRegionLocation)currentTask.getSecond());
                                    if (result instanceof DoNotRetryIOException || noRetry) {
                                        errors.add((Exception)result, row, currentTask);
                                        continue;
                                    }
                                    if (isTraceEnabled) {
                                        retriedErrors.add((Exception)result, row, currentTask);
                                    }
                                    lastRetry = this.addToReplay(nbRetries, correspondingAction);
                                    continue;
                                }
                                if (this.callback == null) continue;
                                this.callback.update((byte[])entry.getKey(), this.rows.get((Integer)regionResult.getFirst()).getRow(), result);
                            }
                        }
                    }
                    if (noRetry || this.toReplay.isEmpty()) continue;
                    if (isTraceEnabled) {
                        LOG.trace((Object)("Retrying due to errors" + (lastRetry ? " (one last time)" : "") + ": " + retriedErrors.getDescriptionAndClear()));
                    }
                    this.doRetry();
                    if (!lastRetry) continue;
                    noRetry = true;
                }
                errors.rethrowIfAny();
            }

            private boolean addToReplay(int[] nbRetries, Action<R> action) {
                this.toReplay.add(action);
                int n = action.getOriginalIndex();
                nbRetries[n] = nbRetries[n] + 1;
                if (nbRetries[action.getOriginalIndex()] > this.curNumRetries) {
                    this.curNumRetries = nbRetries[action.getOriginalIndex()];
                }
                return this.curNumRetries + 1 >= this.hci.numRetries;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Triple<MultiAction<R>, HRegionLocation, Future<MultiResponse>> removeFirstDone() throws InterruptedException {
                while (true) {
                    List<MultiAction<R>> list = this.finishedTasks;
                    synchronized (list) {
                        if (!this.finishedTasks.isEmpty()) {
                            MultiAction<R> done = this.finishedTasks.remove(this.finishedTasks.size() - 1);
                            Iterator it = this.inProgress.iterator();
                            while (it.hasNext()) {
                                Triple task = (Triple)it.next();
                                if (task.getFirst() != done) continue;
                                it.remove();
                                return task;
                            }
                            LOG.error((Object)("Development error: We didn't see a task in the list. " + done.getRegions()));
                        }
                        this.finishedTasks.wait(10L);
                    }
                }
            }

            private Callable<MultiResponse> createDelayedCallable(final long delay, HRegionLocation loc, final MultiAction<R> multi) {
                final Callable delegate = this.hci.createCallable(loc, multi, this.tableName);
                return new Callable<MultiResponse>(){
                    private final long creationTime = System.currentTimeMillis();

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public MultiResponse call() throws Exception {
                        try {
                            long waitingTime = delay + this.creationTime - System.currentTimeMillis();
                            if (waitingTime > 0L) {
                                Thread.sleep(waitingTime);
                            }
                            MultiResponse multiResponse = (MultiResponse)delegate.call();
                            return multiResponse;
                        }
                        finally {
                            List list = Process.this.finishedTasks;
                            synchronized (list) {
                                Process.this.finishedTasks.add(multi);
                                Process.this.finishedTasks.notifyAll();
                            }
                        }
                    }
                };
            }

            private class BatchErrors {
                private List<Throwable> exceptions = new ArrayList<Throwable>();
                private List<Row> actions = new ArrayList<Row>();
                private List<String> addresses = new ArrayList<String>();

                private BatchErrors() {
                }

                public void add(Exception ex, Row row, Triple<MultiAction<R>, HRegionLocation, Future<MultiResponse>> obj) {
                    this.exceptions.add(ex);
                    this.actions.add(row);
                    this.addresses.add(((HRegionLocation)obj.getSecond()).getHostnamePort());
                }

                public void rethrowIfAny() throws RetriesExhaustedWithDetailsException {
                    if (!this.exceptions.isEmpty()) {
                        throw this.makeException();
                    }
                }

                public String getDescriptionAndClear() {
                    if (this.exceptions.isEmpty()) {
                        return "";
                    }
                    String result = this.makeException().getExhaustiveDescription();
                    this.exceptions.clear();
                    this.actions.clear();
                    this.addresses.clear();
                    return result;
                }

                private RetriesExhaustedWithDetailsException makeException() {
                    return new RetriesExhaustedWithDetailsException(this.exceptions, this.actions, this.addresses);
                }
            }
        }

        private static class MasterProtocolHandler
        implements InvocationHandler {
            private HConnectionImplementation connection;
            private MasterProtocolState protocolStateTracker;

            protected MasterProtocolHandler(HConnectionImplementation connection, MasterProtocolState protocolStateTracker) {
                this.connection = connection;
                this.protocolStateTracker = protocolStateTracker;
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("close") && method.getParameterTypes().length == 0) {
                    this.release(this.connection, this.protocolStateTracker);
                    return null;
                }
                try {
                    return method.invoke((Object)this.protocolStateTracker.protocol, args);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause == null) {
                        throw new RuntimeException("Proxy invocation failed and getCause is null", e);
                    }
                    if (cause instanceof UndeclaredThrowableException) {
                        cause = cause.getCause();
                    }
                    throw cause;
                }
            }

            private void release(HConnectionImplementation connection, MasterProtocolState target) {
                connection.releaseMaster(target);
            }
        }

        private static class DelayedClosing
        extends Chore
        implements Stoppable {
            private HConnectionImplementation hci;
            Stoppable stoppable;

            private DelayedClosing(HConnectionImplementation hci, Stoppable stoppable) {
                super("ZooKeeperWatcher and Master delayed closing for connection " + hci, 60000, stoppable);
                this.hci = hci;
                this.stoppable = stoppable;
            }

            static DelayedClosing createAndStart(HConnectionImplementation hci) {
                Stoppable stoppable = new Stoppable(){
                    private volatile boolean isStopped = false;

                    @Override
                    public void stop(String why) {
                        this.isStopped = true;
                    }

                    @Override
                    public boolean isStopped() {
                        return this.isStopped;
                    }
                };
                return new DelayedClosing(hci, stoppable);
            }

            protected void closeMasterProtocol(MasterProtocolState protocolState) {
                if (System.currentTimeMillis() > protocolState.keepAliveUntil) {
                    this.hci.closeMasterProtocol(protocolState);
                    protocolState.keepAliveUntil = Long.MAX_VALUE;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void chore() {
                Object object = this.hci.masterAndZKLock;
                synchronized (object) {
                    if (this.hci.canCloseZKW && System.currentTimeMillis() > this.hci.keepZooKeeperWatcherAliveUntil) {
                        this.hci.closeZooKeeperWatcher();
                        this.hci.keepZooKeeperWatcherAliveUntil = Long.MAX_VALUE;
                    }
                    this.closeMasterProtocol(this.hci.masterAdminProtocol);
                    this.closeMasterProtocol(this.hci.masterMonitorProtocol);
                }
            }

            @Override
            public void stop(String why) {
                this.stoppable.stop(why);
            }

            @Override
            public boolean isStopped() {
                return this.stoppable.isStopped();
            }
        }

        private static class MasterProtocolState {
            public MasterProtocol protocol;
            public int userCount;
            public long keepAliveUntil = Long.MAX_VALUE;
            public final Class<? extends MasterProtocol> protocolClass;

            public MasterProtocolState(Class<? extends MasterProtocol> protocolClass) {
                this.protocolClass = protocolClass;
            }
        }
    }

    public static class HConnectionKey {
        static final String[] CONNECTION_PROPERTIES = new String[]{"hbase.zookeeper.quorum", "zookeeper.znode.parent", "hbase.zookeeper.property.clientPort", "hbase.zookeeper.recoverable.waittime", HConstants.HBASE_CLIENT_PAUSE, HConstants.HBASE_CLIENT_RETRIES_NUMBER, HConstants.HBASE_CLIENT_RPC_MAXATTEMPTS, HConstants.HBASE_RPC_TIMEOUT_KEY, HConstants.HBASE_CLIENT_PREFETCH_LIMIT, HConstants.HBASE_META_SCANNER_CACHING, HConstants.HBASE_CLIENT_INSTANCE_ID};
        private Map<String, String> properties;
        private String username;

        public HConnectionKey(Configuration conf) {
            HashMap<String, String> m = new HashMap<String, String>();
            if (conf != null) {
                for (String property : CONNECTION_PROPERTIES) {
                    String value = conf.get(property);
                    if (value == null) continue;
                    m.put(property, value);
                }
            }
            this.properties = Collections.unmodifiableMap(m);
            try {
                User currentUser = User.getCurrent();
                if (currentUser != null) {
                    this.username = currentUser.getName();
                }
            }
            catch (IOException ioe) {
                LOG.warn((Object)"Error obtaining current user, skipping username in HConnectionKey", (Throwable)ioe);
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            if (this.username != null) {
                result = this.username.hashCode();
            }
            for (String property : CONNECTION_PROPERTIES) {
                String value = this.properties.get(property);
                if (value == null) continue;
                result = 31 * result + value.hashCode();
            }
            return result;
        }

        @SuppressWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"}, justification="Optimization")
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HConnectionKey that = (HConnectionKey)obj;
            if (this.username != null && !this.username.equals(that.username)) {
                return false;
            }
            if (this.username == null && that.username != null) {
                return false;
            }
            if (this.properties == null) {
                if (that.properties != null) {
                    return false;
                }
            } else {
                if (that.properties == null) {
                    return false;
                }
                for (String property : CONNECTION_PROPERTIES) {
                    String thatValue;
                    String thisValue = this.properties.get(property);
                    if (thisValue == (thatValue = that.properties.get(property)) || thisValue != null && thisValue.equals(thatValue)) continue;
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            return "HConnectionKey{properties=" + this.properties + ", username='" + this.username + '\'' + '}';
        }
    }

    public static abstract class HConnectable<T> {
        public Configuration conf;

        protected HConnectable(Configuration conf) {
            this.conf = conf;
        }

        public abstract T connect(HConnection var1) throws IOException;
    }
}

