/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScannerCallable;
import org.apache.hadoop.hbase.client.UnmodifyableHRegionInfo;
import org.apache.hadoop.hbase.exceptions.TableNotFoundException;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class MetaScanner {
    private static final Log LOG = LogFactory.getLog(MetaScanner.class);

    public static void metaScan(Configuration configuration, MetaScannerVisitor visitor) throws IOException {
        MetaScanner.metaScan(configuration, visitor, null);
    }

    public static void metaScan(Configuration configuration, MetaScannerVisitor visitor, byte[] userTableName) throws IOException {
        MetaScanner.metaScan(configuration, visitor, userTableName, null, Integer.MAX_VALUE);
    }

    public static void metaScan(Configuration configuration, MetaScannerVisitor visitor, byte[] userTableName, byte[] row, int rowLimit) throws IOException {
        MetaScanner.metaScan(configuration, visitor, userTableName, row, rowLimit, HConstants.META_TABLE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void metaScan(Configuration configuration, final MetaScannerVisitor visitor, final byte[] tableName, final byte[] row, final int rowLimit, final byte[] metaTableName) throws IOException {
        try {
            HConnectionManager.execute(new HConnectionManager.HConnectable<Void>(configuration){

                @Override
                public Void connect(HConnection connection) throws IOException {
                    MetaScanner.metaScan(this.conf, connection, visitor, tableName, row, rowLimit, metaTableName);
                    return null;
                }
            });
        }
        finally {
            visitor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void metaScan(Configuration configuration, HConnection connection, MetaScannerVisitor visitor, byte[] tableName, byte[] row, int rowLimit, byte[] metaTableName) throws IOException {
        byte[] startRow;
        int rowUpperLimit;
        int n = rowUpperLimit = rowLimit > 0 ? rowLimit : Integer.MAX_VALUE;
        if (row != null) {
            assert (tableName != null);
            byte[] searchRow = HRegionInfo.createRegionName(tableName, row, "99999999999999", false);
            HTable metaTable = null;
            try {
                metaTable = new HTable(configuration, HConstants.META_TABLE_NAME);
                Result startRowResult = metaTable.getRowOrBefore(searchRow, HConstants.CATALOG_FAMILY);
                if (startRowResult == null) {
                    throw new TableNotFoundException("Cannot find row in .META. for table: " + Bytes.toString((byte[])tableName) + ", row=" + Bytes.toStringBinary((byte[])searchRow));
                }
                HRegionInfo regionInfo = MetaScanner.getHRegionInfo(startRowResult);
                if (regionInfo == null) {
                    throw new IOException("HRegionInfo was null or empty in Meta for " + Bytes.toString((byte[])tableName) + ", row=" + Bytes.toStringBinary((byte[])searchRow));
                }
                byte[] rowBefore = regionInfo.getStartKey();
                startRow = HRegionInfo.createRegionName(tableName, rowBefore, "00000000000000", false);
            }
            finally {
                if (metaTable != null) {
                    metaTable.close();
                }
            }
        } else {
            startRow = tableName == null || tableName.length == 0 ? HConstants.EMPTY_START_ROW : HRegionInfo.createRegionName(tableName, HConstants.EMPTY_START_ROW, "00000000000000", false);
        }
        int rows = Math.min(rowLimit, configuration.getInt(HConstants.HBASE_META_SCANNER_CACHING, HConstants.DEFAULT_HBASE_META_SCANNER_CACHING));
        do {
            Scan scan = new Scan(startRow).addFamily(HConstants.CATALOG_FAMILY);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Scanning " + Bytes.toString((byte[])metaTableName) + " starting at row=" + Bytes.toStringBinary((byte[])startRow) + " for max=" + rowUpperLimit + " rows using " + connection.toString()));
            }
            ScannerCallable callable = new ScannerCallable(connection, metaTableName, scan, null);
            callable.withRetries();
            int processedRows = 0;
            try {
                Result[] rrs;
                callable.setCaching(rows);
                block7: while (processedRows < rowUpperLimit && (rrs = (Result[])callable.withRetries()) != null && rrs.length != 0 && rrs[0].size() != 0) {
                    for (Result rr : rrs) {
                        if (processedRows >= rowUpperLimit || !visitor.processRow(rr)) break block7;
                        ++processedRows;
                    }
                }
                startRow = callable.getHRegionInfo().getEndKey();
            }
            finally {
                callable.setClose();
                callable.withRetries();
            }
        } while (Bytes.compareTo((byte[])startRow, (byte[])HConstants.LAST_ROW) != 0);
    }

    public static HRegionInfo getHRegionInfo(Result data) {
        byte[] bytes = data.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
        if (bytes == null) {
            return null;
        }
        HRegionInfo info = HRegionInfo.parseFromOrNull(bytes);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Current INFO from scan results = " + info));
        }
        return info;
    }

    public static List<HRegionInfo> listAllRegions(Configuration conf) throws IOException {
        return MetaScanner.listAllRegions(conf, true);
    }

    public static List<HRegionInfo> listAllRegions(Configuration conf, final boolean offlined) throws IOException {
        final ArrayList<HRegionInfo> regions = new ArrayList<HRegionInfo>();
        DefaultMetaScannerVisitor visitor = new DefaultMetaScannerVisitor(conf){

            @Override
            public boolean processRowInternal(Result result) throws IOException {
                if (result == null || result.isEmpty()) {
                    return true;
                }
                HRegionInfo regionInfo = MetaScanner.getHRegionInfo(result);
                if (regionInfo == null) {
                    LOG.warn((Object)("Null REGIONINFO_QUALIFIER: " + result));
                    return true;
                }
                if (regionInfo.isOffline() && !offlined) {
                    return true;
                }
                regions.add(regionInfo);
                return true;
            }
        };
        MetaScanner.metaScan(conf, visitor);
        return regions;
    }

    public static NavigableMap<HRegionInfo, ServerName> allTableRegions(Configuration conf, byte[] tablename, boolean offlined) throws IOException {
        final TreeMap<HRegionInfo, ServerName> regions = new TreeMap<HRegionInfo, ServerName>();
        TableMetaScannerVisitor visitor = new TableMetaScannerVisitor(conf, tablename){

            @Override
            public boolean processRowInternal(Result rowResult) throws IOException {
                HRegionInfo info = MetaScanner.getHRegionInfo(rowResult);
                ServerName serverName = HRegionInfo.getServerName(rowResult);
                regions.put(new UnmodifyableHRegionInfo(info), serverName);
                return true;
            }
        };
        MetaScanner.metaScan(conf, visitor, tablename);
        return regions;
    }

    public static abstract class TableMetaScannerVisitor
    extends DefaultMetaScannerVisitor {
        private byte[] tableName;

        public TableMetaScannerVisitor(Configuration conf, byte[] tableName) {
            super(conf);
            this.tableName = tableName;
        }

        @Override
        public final boolean processRow(Result rowResult) throws IOException {
            HRegionInfo info = MetaScanner.getHRegionInfo(rowResult);
            if (info == null) {
                return true;
            }
            if (!Bytes.equals((byte[])info.getTableName(), (byte[])this.tableName)) {
                return false;
            }
            return super.processRow(rowResult);
        }
    }

    public static abstract class DefaultMetaScannerVisitor
    extends MetaScannerVisitorBase {
        protected Configuration conf;

        public DefaultMetaScannerVisitor(Configuration conf) {
            this.conf = conf;
        }

        public abstract boolean processRowInternal(Result var1) throws IOException;

        @Override
        public boolean processRow(Result rowResult) throws IOException {
            HRegionInfo info = MetaScanner.getHRegionInfo(rowResult);
            if (info == null) {
                return true;
            }
            if (!info.isOffline() && !info.isSplit()) {
                return this.processRowInternal(rowResult);
            }
            return true;
        }
    }

    public static abstract class MetaScannerVisitorBase
    implements MetaScannerVisitor {
        @Override
        public void close() throws IOException {
        }
    }

    public static interface MetaScannerVisitor
    extends Closeable {
        public boolean processRow(Result var1) throws IOException;
    }
}

