/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.WrongRowIOException;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Put
extends Mutation
implements HeapSize,
Comparable<Row> {
    public Put(byte[] row) {
        this(row, Long.MAX_VALUE);
    }

    public Put(byte[] row, long ts) {
        this(row, 0, row.length, ts);
    }

    public Put(byte[] rowArray, int rowOffset, int rowLength, long ts) {
        Put.checkRow(rowArray, rowOffset, rowLength);
        this.row = Bytes.copy((byte[])rowArray, (int)rowOffset, (int)rowLength);
        this.ts = ts;
    }

    public Put(Put putToCopy) {
        this(putToCopy.getRow(), putToCopy.ts);
        this.familyMap = new TreeMap(Bytes.BYTES_COMPARATOR);
        for (Map.Entry entry : putToCopy.getFamilyMap().entrySet()) {
            this.familyMap.put(entry.getKey(), entry.getValue());
        }
        this.writeToWAL = putToCopy.writeToWAL;
    }

    public Put add(byte[] family, byte[] qualifier, byte[] value) {
        return this.add(family, qualifier, this.ts, value);
    }

    public Put add(byte[] family, byte[] qualifier, long ts, byte[] value) {
        List<? extends Cell> list = this.getCellList(family);
        KeyValue kv = this.createPutKeyValue(family, qualifier, ts, value);
        list.add((Cell)kv);
        this.familyMap.put(kv.getFamily(), list);
        return this;
    }

    public Put add(KeyValue kv) throws IOException {
        byte[] family = kv.getFamily();
        List<? extends Cell> list = this.getCellList(family);
        int res = Bytes.compareTo((byte[])this.row, (int)0, (int)this.row.length, (byte[])kv.getBuffer(), (int)kv.getRowOffset(), (int)kv.getRowLength());
        if (res != 0) {
            throw new WrongRowIOException("The row in " + kv.toString() + " doesn't match the original one " + Bytes.toStringBinary((byte[])this.row));
        }
        list.add((Cell)kv);
        this.familyMap.put(family, list);
        return this;
    }

    public boolean has(byte[] family, byte[] qualifier) {
        return this.has(family, qualifier, this.ts, new byte[0], true, true);
    }

    public boolean has(byte[] family, byte[] qualifier, long ts) {
        return this.has(family, qualifier, ts, new byte[0], false, true);
    }

    public boolean has(byte[] family, byte[] qualifier, byte[] value) {
        return this.has(family, qualifier, this.ts, value, true, false);
    }

    public boolean has(byte[] family, byte[] qualifier, long ts, byte[] value) {
        return this.has(family, qualifier, ts, value, false, false);
    }

    private boolean has(byte[] family, byte[] qualifier, long ts, byte[] value, boolean ignoreTS, boolean ignoreValue) {
        List<? extends Cell> list = this.getCellList(family);
        if (list.size() == 0) {
            return false;
        }
        if (!ignoreTS && !ignoreValue) {
            for (Cell cell : list) {
                KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                if (!Arrays.equals(kv.getFamily(), family) || !Arrays.equals(kv.getQualifier(), qualifier) || !Arrays.equals(kv.getValue(), value) || kv.getTimestamp() != ts) continue;
                return true;
            }
        } else if (ignoreValue && !ignoreTS) {
            for (Cell cell : list) {
                KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                if (!Arrays.equals(kv.getFamily(), family) || !Arrays.equals(kv.getQualifier(), qualifier) || kv.getTimestamp() != ts) continue;
                return true;
            }
        } else if (!ignoreValue && ignoreTS) {
            for (Cell cell : list) {
                KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                if (!Arrays.equals(kv.getFamily(), family) || !Arrays.equals(kv.getQualifier(), qualifier) || !Arrays.equals(kv.getValue(), value)) continue;
                return true;
            }
        } else {
            for (Cell cell : list) {
                KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                if (!Arrays.equals(kv.getFamily(), family) || !Arrays.equals(kv.getQualifier(), qualifier)) continue;
                return true;
            }
        }
        return false;
    }

    public List<KeyValue> get(byte[] family, byte[] qualifier) {
        ArrayList<KeyValue> filteredList = new ArrayList<KeyValue>();
        for (Cell cell : this.getCellList(family)) {
            KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
            if (!Arrays.equals(kv.getQualifier(), qualifier)) continue;
            filteredList.add(kv);
        }
        return filteredList;
    }
}

