/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.io.Writable;

@InterfaceAudience.Private
public class RegionState
implements Writable {
    private final AtomicLong stamp;
    private HRegionInfo region;
    private volatile ServerName serverName;
    private volatile State state;

    public RegionState() {
        this.stamp = new AtomicLong(System.currentTimeMillis());
    }

    public RegionState(HRegionInfo region, State state) {
        this(region, state, System.currentTimeMillis(), null);
    }

    public RegionState(HRegionInfo region, State state, long stamp, ServerName serverName) {
        this.region = region;
        this.state = state;
        this.stamp = new AtomicLong(stamp);
        this.serverName = serverName;
    }

    public void updateTimestampToNow() {
        this.setTimestamp(System.currentTimeMillis());
    }

    public State getState() {
        return this.state;
    }

    public long getStamp() {
        return this.stamp.get();
    }

    public HRegionInfo getRegion() {
        return this.region;
    }

    public ServerName getServerName() {
        return this.serverName;
    }

    public boolean isClosing() {
        return this.state == State.CLOSING;
    }

    public boolean isClosed() {
        return this.state == State.CLOSED;
    }

    public boolean isPendingClose() {
        return this.state == State.PENDING_CLOSE;
    }

    public boolean isOpening() {
        return this.state == State.OPENING;
    }

    public boolean isOpened() {
        return this.state == State.OPEN;
    }

    public boolean isPendingOpen() {
        return this.state == State.PENDING_OPEN;
    }

    public boolean isOffline() {
        return this.state == State.OFFLINE;
    }

    public boolean isSplitting() {
        return this.state == State.SPLITTING;
    }

    public boolean isSplit() {
        return this.state == State.SPLIT;
    }

    public boolean isFailedOpen() {
        return this.state == State.FAILED_OPEN;
    }

    public boolean isFailedClose() {
        return this.state == State.FAILED_CLOSE;
    }

    public boolean isPendingOpenOrOpeningOnServer(ServerName sn) {
        return this.isOnServer(sn) && (this.isPendingOpen() || this.isOpening());
    }

    public boolean isPendingCloseOrClosingOnServer(ServerName sn) {
        return this.isOnServer(sn) && (this.isPendingClose() || this.isClosing());
    }

    public boolean isOnServer(ServerName sn) {
        return this.serverName != null && this.serverName.equals(sn);
    }

    public String toString() {
        return "{" + this.region.getRegionNameAsString() + " state=" + (Object)((Object)this.state) + ", ts=" + this.stamp + ", server=" + this.serverName + "}";
    }

    public String toDescriptiveString() {
        long lstamp = this.stamp.get();
        long relTime = System.currentTimeMillis() - lstamp;
        return this.region.getRegionNameAsString() + " state=" + (Object)((Object)this.state) + ", ts=" + new Date(lstamp) + " (" + relTime / 1000L + "s ago)" + ", server=" + this.serverName;
    }

    public ClusterStatusProtos.RegionState convert() {
        ClusterStatusProtos.RegionState.State rs;
        ClusterStatusProtos.RegionState.Builder regionState = ClusterStatusProtos.RegionState.newBuilder();
        switch (regionState.getState()) {
            case OFFLINE: {
                rs = ClusterStatusProtos.RegionState.State.OFFLINE;
                break;
            }
            case PENDING_OPEN: {
                rs = ClusterStatusProtos.RegionState.State.PENDING_OPEN;
                break;
            }
            case OPENING: {
                rs = ClusterStatusProtos.RegionState.State.OPENING;
                break;
            }
            case OPEN: {
                rs = ClusterStatusProtos.RegionState.State.OPEN;
                break;
            }
            case PENDING_CLOSE: {
                rs = ClusterStatusProtos.RegionState.State.PENDING_CLOSE;
                break;
            }
            case CLOSING: {
                rs = ClusterStatusProtos.RegionState.State.CLOSING;
                break;
            }
            case CLOSED: {
                rs = ClusterStatusProtos.RegionState.State.CLOSED;
                break;
            }
            case SPLITTING: {
                rs = ClusterStatusProtos.RegionState.State.SPLITTING;
                break;
            }
            case SPLIT: {
                rs = ClusterStatusProtos.RegionState.State.SPLIT;
                break;
            }
            case FAILED_OPEN: {
                rs = ClusterStatusProtos.RegionState.State.FAILED_OPEN;
                break;
            }
            case FAILED_CLOSE: {
                rs = ClusterStatusProtos.RegionState.State.FAILED_CLOSE;
                break;
            }
            default: {
                throw new IllegalStateException("");
            }
        }
        regionState.setRegionInfo(HRegionInfo.convert(this.region));
        regionState.setState(rs);
        regionState.setStamp(this.getStamp());
        return regionState.build();
    }

    public static RegionState convert(ClusterStatusProtos.RegionState proto) {
        State state;
        switch (proto.getState()) {
            case OFFLINE: {
                state = State.OFFLINE;
                break;
            }
            case PENDING_OPEN: {
                state = State.PENDING_OPEN;
                break;
            }
            case OPENING: {
                state = State.OPENING;
                break;
            }
            case OPEN: {
                state = State.OPEN;
                break;
            }
            case PENDING_CLOSE: {
                state = State.PENDING_CLOSE;
                break;
            }
            case CLOSING: {
                state = State.CLOSING;
                break;
            }
            case CLOSED: {
                state = State.CLOSED;
                break;
            }
            case SPLITTING: {
                state = State.SPLITTING;
                break;
            }
            case SPLIT: {
                state = State.SPLIT;
                break;
            }
            case FAILED_OPEN: {
                state = State.FAILED_OPEN;
                break;
            }
            case FAILED_CLOSE: {
                state = State.FAILED_CLOSE;
                break;
            }
            default: {
                throw new IllegalStateException("");
            }
        }
        return new RegionState(HRegionInfo.convert(proto.getRegionInfo()), state, proto.getStamp(), null);
    }

    protected void setTimestamp(long timestamp) {
        this.stamp.set(timestamp);
    }

    @Deprecated
    public void readFields(DataInput in) throws IOException {
        this.region = new HRegionInfo();
        this.region.readFields(in);
        this.state = State.valueOf(in.readUTF());
        this.stamp.set(in.readLong());
    }

    @Deprecated
    public void write(DataOutput out) throws IOException {
        this.region.write(out);
        out.writeUTF(this.state.name());
        out.writeLong(this.stamp.get());
    }

    public static enum State {
        OFFLINE,
        PENDING_OPEN,
        OPENING,
        OPEN,
        PENDING_CLOSE,
        CLOSING,
        CLOSED,
        SPLITTING,
        SPLIT,
        FAILED_OPEN,
        FAILED_CLOSE;

    }
}

