/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class MetaRegionTracker
extends ZooKeeperNodeTracker {
    public MetaRegionTracker(ZooKeeperWatcher watcher, Abortable abortable) {
        super(watcher, watcher.metaServerZNode, abortable);
    }

    public boolean isLocationAvailable() {
        return super.getData(true) != null;
    }

    public ServerName getMetaRegionLocation() throws InterruptedException {
        try {
            return ServerName.parseFrom(super.getData(true));
        }
        catch (DeserializationException e) {
            LOG.warn((Object)"Failed parse", (Throwable)e);
            return null;
        }
    }

    public static ServerName getMetaRegionLocation(ZooKeeperWatcher zkw) throws KeeperException {
        try {
            return ServerName.parseFrom(ZKUtil.getData(zkw, zkw.metaServerZNode));
        }
        catch (DeserializationException e) {
            throw ZKUtil.convert(e);
        }
    }

    public ServerName waitMetaRegionLocation(long timeout) throws InterruptedException {
        if (!this.checkIfBaseNodeAvailable()) {
            String errorMsg = "Check the value configured in 'zookeeper.znode.parent'. There could be a mismatch with the one configured in the master.";
            LOG.error((Object)errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        try {
            return ServerName.parseFrom(super.blockUntilAvailable(timeout, true));
        }
        catch (DeserializationException e) {
            LOG.warn((Object)"Failed parse", (Throwable)e);
            return null;
        }
    }

    public static void setMetaLocation(ZooKeeperWatcher zookeeper, ServerName location) throws KeeperException {
        LOG.info((Object)("Setting META region location in ZooKeeper as " + location));
        byte[] data = MetaRegionTracker.toByteArray(location);
        try {
            ZKUtil.createAndWatch(zookeeper, zookeeper.metaServerZNode, data);
        }
        catch (KeeperException.NodeExistsException nee) {
            LOG.debug((Object)"META region location already existed, updated location");
            ZKUtil.setData(zookeeper, zookeeper.metaServerZNode, data);
        }
    }

    static byte[] toByteArray(ServerName sn) {
        HBaseProtos.ServerName pbsn = HBaseProtos.ServerName.newBuilder().setHostName(sn.getHostname()).setPort(sn.getPort()).setStartCode(sn.getStartcode()).build();
        ZooKeeperProtos.RootRegionServer pbrsr = ZooKeeperProtos.RootRegionServer.newBuilder().setServer(pbsn).build();
        return ProtobufUtil.prependPBMagic(pbrsr.toByteArray());
    }

    public static void deleteMetaLocation(ZooKeeperWatcher zookeeper) throws KeeperException {
        LOG.info((Object)"Unsetting META region location in ZooKeeper");
        try {
            ZKUtil.deleteNode(zookeeper, zookeeper.metaServerZNode);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
    }

    public static ServerName blockUntilAvailable(ZooKeeperWatcher zkw, long timeout) throws InterruptedException {
        byte[] data = ZKUtil.blockUntilAvailable(zkw, zkw.metaServerZNode, timeout);
        if (data == null) {
            return null;
        }
        try {
            return ServerName.parseFrom(data);
        }
        catch (DeserializationException e) {
            LOG.warn((Object)"Failed parse", (Throwable)e);
            return null;
        }
    }
}

