/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.zookeeper.ZKTableReadOnly;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class ZKTable {
    private static final Log LOG = LogFactory.getLog(ZKTable.class);
    private final ZooKeeperWatcher watcher;
    private final Map<String, ZooKeeperProtos.Table.State> cache = new HashMap<String, ZooKeeperProtos.Table.State>();

    public ZKTable(ZooKeeperWatcher zkw) throws KeeperException {
        this.watcher = zkw;
        this.populateTableStates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateTableStates() throws KeeperException {
        Map<String, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            List<String> children = ZKUtil.listChildrenNoWatch(this.watcher, this.watcher.tableZNode);
            if (children == null) {
                return;
            }
            for (String child : children) {
                ZooKeeperProtos.Table.State state = ZKTableReadOnly.getTableState(this.watcher, child);
                if (state == null) continue;
                this.cache.put(child, state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisabledTable(String tableName) throws KeeperException {
        Map<String, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            if (!this.isDisablingOrDisabledTable(tableName)) {
                LOG.warn((Object)("Moving table " + tableName + " state to disabled but was " + "not first in disabling state: " + this.cache.get(tableName)));
            }
            this.setTableState(tableName, ZooKeeperProtos.Table.State.DISABLED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisablingTable(String tableName) throws KeeperException {
        Map<String, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            if (!this.isEnabledOrDisablingTable(tableName)) {
                LOG.warn((Object)("Moving table " + tableName + " state to disabling but was " + "not first in enabled state: " + this.cache.get(tableName)));
            }
            this.setTableState(tableName, ZooKeeperProtos.Table.State.DISABLING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnablingTable(String tableName) throws KeeperException {
        Map<String, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            if (!this.isDisabledOrEnablingTable(tableName)) {
                LOG.warn((Object)("Moving table " + tableName + " state to enabling but was " + "not first in disabled state: " + this.cache.get(tableName)));
            }
            this.setTableState(tableName, ZooKeeperProtos.Table.State.ENABLING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAndSetEnablingTable(String tableName) throws KeeperException {
        Map<String, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            if (this.isEnablingTable(tableName)) {
                return false;
            }
            this.setTableState(tableName, ZooKeeperProtos.Table.State.ENABLING);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkDisabledAndSetEnablingTable(String tableName) throws KeeperException {
        Map<String, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            if (!this.isDisabledTable(tableName)) {
                return false;
            }
            this.setTableState(tableName, ZooKeeperProtos.Table.State.ENABLING);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkEnabledAndSetDisablingTable(String tableName) throws KeeperException {
        Map<String, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            if (this.cache.get(tableName) != null && !this.isEnabledTable(tableName)) {
                return false;
            }
            this.setTableState(tableName, ZooKeeperProtos.Table.State.DISABLING);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTableState(String tableName, ZooKeeperProtos.Table.State state) throws KeeperException {
        String znode = ZKUtil.joinZNode(this.watcher.tableZNode, tableName);
        if (ZKUtil.checkExists(this.watcher, znode) == -1) {
            ZKUtil.createAndFailSilent(this.watcher, znode);
        }
        Map<String, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            ZooKeeperProtos.Table.Builder builder = ZooKeeperProtos.Table.newBuilder();
            builder.setState(state);
            byte[] data = ProtobufUtil.prependPBMagic(builder.build().toByteArray());
            ZKUtil.setData(this.watcher, znode, data);
            this.cache.put(tableName, state);
        }
    }

    public boolean isDisabledTable(String tableName) {
        return this.isTableState(tableName, ZooKeeperProtos.Table.State.DISABLED);
    }

    public boolean isDisablingTable(String tableName) {
        return this.isTableState(tableName, ZooKeeperProtos.Table.State.DISABLING);
    }

    public boolean isEnablingTable(String tableName) {
        return this.isTableState(tableName, ZooKeeperProtos.Table.State.ENABLING);
    }

    public boolean isEnabledTable(String tableName) {
        return this.isTableState(tableName, ZooKeeperProtos.Table.State.ENABLED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisablingOrDisabledTable(String tableName) {
        Map<String, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            return this.isDisablingTable(tableName) || this.isDisabledTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabledOrDisablingTable(String tableName) {
        Map<String, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            return this.isEnabledTable(tableName) || this.isDisablingTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisabledOrEnablingTable(String tableName) {
        Map<String, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            return this.isDisabledTable(tableName) || this.isEnablingTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTableState(String tableName, ZooKeeperProtos.Table.State state) {
        Map<String, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            ZooKeeperProtos.Table.State currentState = this.cache.get(tableName);
            return ZKTableReadOnly.isTableState(currentState, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeletedTable(String tableName) throws KeeperException {
        Map<String, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            if (this.cache.remove(tableName) == null) {
                LOG.warn((Object)("Moving table " + tableName + " state to deleted but was " + "already deleted"));
            }
            ZKUtil.deleteNodeFailSilent(this.watcher, ZKUtil.joinZNode(this.watcher.tableZNode, tableName));
        }
    }

    public void setEnabledTable(String tableName) throws KeeperException {
        this.setTableState(tableName, ZooKeeperProtos.Table.State.ENABLED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTablePresent(String tableName) {
        Map<String, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            ZooKeeperProtos.Table.State state = this.cache.get(tableName);
            return state != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getDisabledTables() {
        HashSet<String> disabledTables = new HashSet<String>();
        Map<String, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            Set<String> tables = this.cache.keySet();
            for (String table : tables) {
                if (!this.isDisabledTable(table)) continue;
                disabledTables.add(table);
            }
        }
        return disabledTables;
    }

    public static Set<String> getDisabledTables(ZooKeeperWatcher zkw) throws KeeperException {
        return ZKTable.getAllTables(zkw, ZooKeeperProtos.Table.State.DISABLED);
    }

    public static Set<String> getDisablingTables(ZooKeeperWatcher zkw) throws KeeperException {
        return ZKTable.getAllTables(zkw, ZooKeeperProtos.Table.State.DISABLING);
    }

    public static Set<String> getEnablingTables(ZooKeeperWatcher zkw) throws KeeperException {
        return ZKTable.getAllTables(zkw, ZooKeeperProtos.Table.State.ENABLING);
    }

    public static Set<String> getDisabledOrDisablingTables(ZooKeeperWatcher zkw) throws KeeperException {
        return ZKTable.getAllTables(zkw, ZooKeeperProtos.Table.State.DISABLED, ZooKeeperProtos.Table.State.DISABLING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEnablingTable(String tableName) {
        Map<String, ZooKeeperProtos.Table.State> map = this.cache;
        synchronized (map) {
            if (this.isEnablingTable(tableName)) {
                this.cache.remove(tableName);
            }
        }
    }

    static Set<String> getAllTables(ZooKeeperWatcher zkw, ZooKeeperProtos.Table.State ... states) throws KeeperException {
        HashSet<String> allTables = new HashSet<String>();
        List<String> children = ZKUtil.listChildrenNoWatch(zkw, zkw.tableZNode);
        block0: for (String child : children) {
            ZooKeeperProtos.Table.State state = ZKTableReadOnly.getTableState(zkw, child);
            for (ZooKeeperProtos.Table.State expectedState : states) {
                if (state != expectedState) continue;
                allTables.add(child);
                continue block0;
            }
        }
        return allTables;
    }
}

