/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import com.google.protobuf.InvalidProtocolBufferException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

public class ZKTableReadOnly {
    private ZKTableReadOnly() {
    }

    public static boolean isDisabledTable(ZooKeeperWatcher zkw, String tableName) throws KeeperException {
        ZooKeeperProtos.Table.State state = ZKTableReadOnly.getTableState(zkw, tableName);
        return ZKTableReadOnly.isTableState(ZooKeeperProtos.Table.State.DISABLED, state);
    }

    public static boolean isEnabledTable(ZooKeeperWatcher zkw, String tableName) throws KeeperException {
        return ZKTableReadOnly.getTableState(zkw, tableName) == ZooKeeperProtos.Table.State.ENABLED;
    }

    public static boolean isDisablingOrDisabledTable(ZooKeeperWatcher zkw, String tableName) throws KeeperException {
        ZooKeeperProtos.Table.State state = ZKTableReadOnly.getTableState(zkw, tableName);
        return ZKTableReadOnly.isTableState(ZooKeeperProtos.Table.State.DISABLING, state) || ZKTableReadOnly.isTableState(ZooKeeperProtos.Table.State.DISABLED, state);
    }

    public static Set<String> getDisabledTables(ZooKeeperWatcher zkw) throws KeeperException {
        HashSet<String> disabledTables = new HashSet<String>();
        List<String> children = ZKUtil.listChildrenNoWatch(zkw, zkw.tableZNode);
        for (String child : children) {
            ZooKeeperProtos.Table.State state = ZKTableReadOnly.getTableState(zkw, child);
            if (state != ZooKeeperProtos.Table.State.DISABLED) continue;
            disabledTables.add(child);
        }
        return disabledTables;
    }

    public static Set<String> getDisabledOrDisablingTables(ZooKeeperWatcher zkw) throws KeeperException {
        HashSet<String> disabledTables = new HashSet<String>();
        List<String> children = ZKUtil.listChildrenNoWatch(zkw, zkw.tableZNode);
        for (String child : children) {
            ZooKeeperProtos.Table.State state = ZKTableReadOnly.getTableState(zkw, child);
            if (state != ZooKeeperProtos.Table.State.DISABLED && state != ZooKeeperProtos.Table.State.DISABLING) continue;
            disabledTables.add(child);
        }
        return disabledTables;
    }

    static boolean isTableState(ZooKeeperProtos.Table.State expectedState, ZooKeeperProtos.Table.State currentState) {
        return currentState != null && currentState.equals((Object)expectedState);
    }

    static ZooKeeperProtos.Table.State getTableState(ZooKeeperWatcher zkw, String child) throws KeeperException {
        String znode = ZKUtil.joinZNode(zkw.tableZNode, child);
        byte[] data = ZKUtil.getData(zkw, znode);
        if (data == null || data.length <= 0) {
            return ZooKeeperProtos.Table.State.ENABLED;
        }
        try {
            ProtobufUtil.expectPBMagicPrefix(data);
            ZooKeeperProtos.Table.Builder builder = ZooKeeperProtos.Table.newBuilder();
            int magicLen = ProtobufUtil.lengthOfPBMagic();
            ZooKeeperProtos.Table t = ((ZooKeeperProtos.Table.Builder)builder.mergeFrom(data, magicLen, data.length - magicLen)).build();
            return t.getState();
        }
        catch (InvalidProtocolBufferException e) {
            KeeperException.DataInconsistencyException ke = new KeeperException.DataInconsistencyException();
            ke.initCause((Throwable)e);
            throw ke;
        }
        catch (DeserializationException e) {
            throw ZKUtil.convert(e);
        }
    }
}

